/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.internal.ws.api.client;

import com.sun.istack.internal.NotNull;
import com.sun.istack.internal.Nullable;
import com.sun.xml.internal.ws.api.WSFeatureList;
import com.sun.xml.internal.ws.api.client.WSPortInfo;
import com.sun.xml.internal.ws.developer.WSBindingProvider;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.xml.ws.WebServiceFeature;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class ServiceInterceptor {
    public List<WebServiceFeature> preCreateBinding(@NotNull WSPortInfo wSPortInfo, @Nullable Class<?> clazz, @NotNull WSFeatureList wSFeatureList) {
        return Collections.emptyList();
    }

    public void postCreateProxy(@NotNull WSBindingProvider wSBindingProvider, @NotNull Class<?> clazz) {
    }

    public void postCreateDispatch(@NotNull WSBindingProvider wSBindingProvider) {
    }

    public static ServiceInterceptor aggregate(final ServiceInterceptor ... serviceInterceptorArray) {
        if (serviceInterceptorArray.length == 1) {
            return serviceInterceptorArray[0];
        }
        return new ServiceInterceptor(){

            @Override
            public List<WebServiceFeature> preCreateBinding(@NotNull WSPortInfo wSPortInfo, @Nullable Class<?> clazz, @NotNull WSFeatureList wSFeatureList) {
                ArrayList<WebServiceFeature> arrayList = new ArrayList<WebServiceFeature>();
                for (ServiceInterceptor serviceInterceptor : serviceInterceptorArray) {
                    arrayList.addAll(serviceInterceptor.preCreateBinding(wSPortInfo, clazz, wSFeatureList));
                }
                return arrayList;
            }

            @Override
            public void postCreateProxy(@NotNull WSBindingProvider wSBindingProvider, @NotNull Class<?> clazz) {
                for (ServiceInterceptor serviceInterceptor : serviceInterceptorArray) {
                    serviceInterceptor.postCreateProxy(wSBindingProvider, clazz);
                }
            }

            @Override
            public void postCreateDispatch(@NotNull WSBindingProvider wSBindingProvider) {
                for (ServiceInterceptor serviceInterceptor : serviceInterceptorArray) {
                    serviceInterceptor.postCreateDispatch(wSBindingProvider);
                }
            }
        };
    }
}

