!IF "$(CFG)" == ""
CFG=layoutex - Win32 Release
!ENDIF

NULL=

!IF  "$(CFG)" == "layoutex - Win32 Release"

OUTDIR=.\..\..\lib
INTDIR=.\Release

!IF "$(RECURSE)" == "0"

ALL : "..\..\include\layout\RunArrays.h" "..\..\include\layout\ParagraphLayout.h" "..\..\bin\iculx40.dll"

!ELSE

ALL : "layout - Win32 Release" "i18n - Win32 Release" "common - Win32 Release" "..\..\include\layout\RunArrays.h" "..\..\include\layout\ParagraphLayout.h" "..\..\bin\iculx40.dll"

!ENDIF

"$(OUTDIR)" :
    if not exist "$(OUTDIR)/$(NULL)" mkdir "$(OUTDIR)"

"$(INTDIR)" :
    if not exist "$(INTDIR)/$(NULL)" mkdir "$(INTDIR)"

CPP=cl.exe
CPP_PROJ=/nologo /O2 $(EXCEPTIONSWITCH) /Ob2 /Op /I "..\..\include" /I "..\common" /D "NDEBUG" /D "WIN32" /D "_WINDOWS" /D "_USRDLL" /D "U_LAYOUTEX_IMPLEMENTATION" /D "_MBCS" /D "_WINDLL" /D "_CRT_SECURE_NO_DEPRECATE" /GF /FD /MT /Gy /Fp".\Release/layoutex.pch" /Fo".\Release/" /Fd".\Release/" /W3 /c

.c{$(INTDIR)}.obj::
   $(CPP) @<<
   $(CPP_PROJ) $<
<<

.cpp{$(INTDIR)}.obj::
   $(CPP) @<<
   $(CPP_PROJ) $<
<<

.cxx{$(INTDIR)}.obj::
   $(CPP) @<<
   $(CPP_PROJ) $<
<<

.c{$(INTDIR)}.sbr::
   $(CPP) @<<
   $(CPP_PROJ) $<
<<

.cpp{$(INTDIR)}.sbr::
   $(CPP) @<<
   $(CPP_PROJ) $<
<<

.cxx{$(INTDIR)}.sbr::
   $(CPP) @<<
   $(CPP_PROJ) $<
<<

MTL=midl.exe
MTL_PROJ=/nologo /D "NDEBUG" /mktyplib203 /win32
RSC=rc.exe
RSC_PROJ=/l 0x409 /fo"$(INTDIR)\layoutex.res" /d "NDEBUG"
BSC32=bscmake.exe
BSC32_FLAGS=/nologo /o"$(OUTDIR)\layoutex.bsc"
BSC32_SBRS= \

LINK32=link.exe
LINK32_FLAGS=..\..\lib\icuuc.lib ..\..\lib\icule.lib /nologo /dll /incremental:no /pdb:"$(OUTDIR)\iculx40.pdb" /machine:I386 /out:"..\..\bin\iculx40.dll" /implib:"$(OUTDIR)\iculx.lib"
LINK32_OBJS= \
	"$(INTDIR)\LXUtilities.obj" \
	"$(INTDIR)\ParagraphLayout.obj" \
	"$(INTDIR)\RunArrays.obj" \
	"$(INTDIR)\layoutex.res" \
	"$(OUTDIR)\icuuc.lib" \
	"$(OUTDIR)\icuin.lib" \
	"$(OUTDIR)\icule.lib"

"..\..\bin\iculx40.dll" : "$(OUTDIR)" $(DEF_FILE) $(LINK32_OBJS)
    $(LINK32) @<<
  $(LINK32_FLAGS) $(LINK32_OBJS)
<<

!ELSEIF  "$(CFG)" == "layoutex - Win32 Debug"

!ENDIF


!IF "$(NO_EXTERNAL_DEPS)" != "1"
!IF EXISTS("layoutex.dep")
!INCLUDE "layoutex.dep"
!ELSE
!MESSAGE Warning: cannot find "layoutex.dep"
!ENDIF
!ENDIF


!IF "$(CFG)" == "layoutex - Win32 Release" || "$(CFG)" == "layoutex - Win32 Debug"

SOURCE=.\ParagraphLayout.cpp
"$(INTDIR)\ParagraphLayout.obj": $(SOURCE) "$(INTDIR)" "..\common\unicode\ubidi.h" "..\common\unicode\uchriter.h" "..\common\unicode\brkiter.h"

SOURCE=.\RunArrays.cpp
"$(INTDIR)\RunArrays.obj": $(SOURCE) "$(INTDIR)" "..\common\unicode\locid.h"

SOURCE=.\layoutex.rc
"$(INTDIR)\layoutex.res" : $(SOURCE) "$(INTDIR)"
	$(RSC) /l 0x409 /fo"$(INTDIR)\layoutex.res" /i "..\common" /d "NDEBUG" $(SOURCE)

SOURCE=LXUtilities.cpp
"$(INTDIR)\LXUtilities.obj": $(SOURCE) "$(INTDIR)"


SOURCE=.\layout\ParagraphLayout.h
InputPath=.\layout\ParagraphLayout.h

"..\..\include\layout\ParagraphLayout.h" : $(SOURCE) "$(INTDIR)" "$(OUTDIR)"
	<<tempfile.bat
	@echo off
	copy  $(InputPath)  ..\..\include\layout
<<


SOURCE=.\layout\RunArrays.h
InputPath=.\layout\RunArrays.h

"..\..\include\layout\RunArrays.h" : $(SOURCE) "$(INTDIR)" "$(OUTDIR)"
	<<tempfile.bat
	@echo off
	copy  $(InputPath)  ..\..\include\layout
<<




!IF  "$(CFG)" == "layoutex - Win32 Release"

"common - Win32 Release" :
   cd "..\common"
   $(MAKE) /$(MAKEFLAGS) /F .\common.mak CFG="common - Win32 Release"
   cd "..\layoutex"

"common - Win32 ReleaseCLEAN" :
   cd "..\common"
   $(MAKE) /$(MAKEFLAGS) /F .\common.mak CFG="common - Win32 Release" RECURSE=1 CLEAN
   cd "..\layoutex"

!ELSEIF  "$(CFG)" == "layoutex - Win32 Debug"

"common - Win32 Debug" :
   cd "..\common"
   $(MAKE) /$(MAKEFLAGS) /F .\common.mak CFG="common - Win32 Debug"
   cd "..\layoutex"

"common - Win32 DebugCLEAN" :
   cd "..\common"
   $(MAKE) /$(MAKEFLAGS) /F .\common.mak CFG="common - Win32 Debug" RECURSE=1 CLEAN
   cd "..\layoutex"

!ENDIF

!IF  "$(CFG)" == "layoutex - Win32 Release"

"i18n - Win32 Release" :
   cd "..\i18n"
   $(MAKE) /$(MAKEFLAGS) /F .\i18n.mak CFG="i18n - Win32 Release"
   cd "..\layoutex"

"i18n - Win32 ReleaseCLEAN" :
   cd "..\i18n"
   $(MAKE) /$(MAKEFLAGS) /F .\i18n.mak CFG="i18n - Win32 Release" RECURSE=1 CLEAN
   cd "..\layoutex"

!ELSEIF  "$(CFG)" == "layoutex - Win32 Debug"

"i18n - Win32 Debug" :
   cd "..\i18n"
   $(MAKE) /$(MAKEFLAGS) /F .\i18n.mak CFG="i18n - Win32 Debug"
   cd "..\layoutex"

"i18n - Win32 DebugCLEAN" :
   cd "..\i18n"
   $(MAKE) /$(MAKEFLAGS) /F .\i18n.mak CFG="i18n - Win32 Debug" RECURSE=1 CLEAN
   cd "..\layoutex"

!ENDIF

!IF  "$(CFG)" == "layoutex - Win32 Release"

"layout - Win32 Release" :
   cd "..\layout"
   $(MAKE) /$(MAKEFLAGS) /F .\layout.mak CFG="layout - Win32 Release"
   cd "..\layoutex"

"layout - Win32 ReleaseCLEAN" :
   cd "..\layout"
   $(MAKE) /$(MAKEFLAGS) /F .\layout.mak CFG="layout - Win32 Release" RECURSE=1 CLEAN
   cd "..\layoutex"

!ELSEIF  "$(CFG)" == "layoutex - Win32 Debug"

"layout - Win32 Debug" :
   cd "..\layout"
   $(MAKE) /$(MAKEFLAGS) /F .\layout.mak CFG="layout - Win32 Debug"
   cd "..\layoutex"

"layout - Win32 DebugCLEAN" :
   cd "..\layout"
   $(MAKE) /$(MAKEFLAGS) /F .\layout.mak CFG="layout - Win32 Debug" RECURSE=1 CLEAN
   cd "..\layoutex"

!ENDIF


!ENDIF