!IF "$(CFG)" == ""
CFG=ctestfw - Win32 Release
!ENDIF

NULL=

!IF  "$(CFG)" == "ctestfw - Win32 Release"

OUTDIR=.\..\..\..\lib
INTDIR=.\Release

!IF "$(RECURSE)" == "0"

ALL : "..\..\..\include\unicode\ctest.h" "..\..\..\include\unicode\udbgutil.h" "..\..\..\include\unicode\testtype.h" "..\..\..\bin\icutest.dll"

!ELSE

ALL : "common - Win32 Release" "..\..\..\include\unicode\ctest.h" "..\..\..\bin\ctestfw.dll"

!ENDIF

!IF "$(RECURSE)" == "1"
CLEAN :"common - Win32 ReleaseCLEAN"
!ELSE
CLEAN :
!ENDIF
	-@erase "$(INTDIR)\ctest.obj"
	-@erase "$(INTDIR)\vc60.idb"
	-@erase "$(OUTDIR)\ctestfw.exp"
	-@erase "$(OUTDIR)\ctestfw.lib"
	-@erase "..\..\..\bin\ctestfw.dll"
	-@erase "..\..\..\include\unicode\ctest.h"

"$(OUTDIR)" :
    if not exist "$(OUTDIR)/$(NULL)" mkdir "$(OUTDIR)"

"$(INTDIR)" :
    if not exist "$(INTDIR)/$(NULL)" mkdir "$(INTDIR)"

CPP=cl.exe
CPP_PROJ=/O2 $(EXCEPTIONSWITCH) /Op /I "..\..\..\include" /I "..\..\common" /I "..\toolutil" /D "WIN32" /D "NDEBUG" /D "T_CTEST_IMPLEMENTATION" /D "_WINDLL" /D "_MBCS" /FD /MD /Za /Fp".\Release/icutest.pch" /Fo".\Release/" /Fd".\Release/" /W3 /nologo /c

.c{$(INTDIR)}.obj::
   $(CPP) @<<
   $(CPP_PROJ) $<
<<

.cpp{$(INTDIR)}.obj::
   $(CPP) @<<
   $(CPP_PROJ) $<
<<

.cxx{$(INTDIR)}.obj::
   $(CPP) @<<
   $(CPP_PROJ) $<
<<

.c{$(INTDIR)}.sbr::
   $(CPP) @<<
   $(CPP_PROJ) $<
<<

.cpp{$(INTDIR)}.sbr::
   $(CPP) @<<
   $(CPP_PROJ) $<
<<

.cxx{$(INTDIR)}.sbr::
   $(CPP) @<<
   $(CPP_PROJ) $<
<<

MTL=midl.exe
MTL_PROJ=/nologo /D "NDEBUG" /mktyplib203 /win32
RSC=rc.exe

LINK32=link.exe
LINK32_FLAGS=icuuc.lib icutu.lib /nologo /dll /incremental:no /pdb:"$(OUTDIR)\icutest.pdb" /machine:I386 /out:"..\..\..\bin\icutest.dll" /implib:"$(OUTDIR)\icutest.lib" /libpath:"..\..\..\lib"
LINK32_OBJS= \
	$(INTDIR)\ctest.obj\
	$(INTDIR)\datamap.obj\
    $(INTDIR)\dbgutil.obj\
	$(INTDIR)\testdata.obj\
	$(INTDIR)\tstdtmod.obj\
    $(INTDIR)\udbgutil.obj\
	$(INTDIR)\uperf.obj\

"..\..\..\bin\icutest.dll" : "$(OUTDIR)" $(DEF_FILE) $(LINK32_OBJS)
    $(LINK32) @<<
  $(LINK32_FLAGS) $(LINK32_OBJS)
<<

!ELSEIF  "$(CFG)" == "ctestfw - Win32 Debug"

!ENDIF


!IF "$(NO_EXTERNAL_DEPS)" != "1"
!IF EXISTS("ctestfw.dep")
!INCLUDE "ctestfw.dep"
!ELSE
!MESSAGE Warning: cannot find "ctestfw.dep"
!ENDIF
!ENDIF


SOURCE=.\ctest.c
"$(INTDIR)\ctest.obj": $(SOURCE) "$(INTDIR)" "..\..\common\unicode\utrace.h" ".\unicode\ctest.h"

SOURCE=.\datamap.cpp
"$(INTDIR)\datamap.obj": $(SOURCE) "$(INTDIR)" ".\unicode\datamap.h" "..\..\common\unicode\resbund.h"

SOURCE=.\testdata.cpp
"$(INTDIR)\testdata.obj": $(SOURCE) "$(INTDIR)" ".\unicode\testdata.h"

SOURCE=.\tstdtmod.cpp
"$(INTDIR)\tstdtmod.obj": $(SOURCE) "$(INTDIR)" ".\unicode\tstdtmod.h"

SOURCE=.\uperf.cpp
"$(INTDIR)\uperf.obj": $(SOURCE) "$(INTDIR)" ".\unicode\uperf.h"
CPP_SWITCHES=/O2 $(EXCEPTIONSWITCH) /Op /I "..\..\..\include" /I "..\..\common" /I "..\toolutil" /D "WIN32" /D "NDEBUG" /D "T_CTEST_IMPLEMENTATION" /D "_WINDLL" /D "_MBCS" /FD /MD /Fp".\Release/icutest.pch" /Fo".\Release/" /Fd".\Release/" /W3 /nologo /c
"$(INTDIR)\uperf.obj": $(SOURCE) "$(INTDIR)"
	$(CPP) @<<
  $(CPP_SWITCHES) $(SOURCE)
<<

SOURCE=.\unicode\ctest.h
InputPath=.\unicode\ctest.h

"..\..\..\include\unicode\ctest.h" : $(SOURCE) "$(INTDIR)" "$(OUTDIR)"
	<<tempfile.bat
	@echo off
	copy    $(InputPath)    ..\..\..\include\unicode
<<

SOURCE=.\unicode\udbgutil.h
InputPath=.\unicode\udbgutil.h

"..\..\..\include\unicode\udbgutil.h" : $(SOURCE) "$(INTDIR)" "$(OUTDIR)"
	<<tempfile.bat
	@echo off
	copy    $(InputPath)    ..\..\..\include\unicode
<<

SOURCE=.\unicode\testtype.h
InputPath=.\unicode\testtype.h

"..\..\..\include\unicode\testtype.h" : $(SOURCE) "$(INTDIR)" "$(OUTDIR)"
	<<tempfile.bat
	@echo off
	copy    $(InputPath)    ..\..\..\include\unicode
<<

!IF  "$(CFG)" == "ctestfw - Win32 Release"

"common - Win32 Release" :
   cd "..\..\common"
   $(MAKE) /$(MAKEFLAGS) /F .\common.mak CFG="common - Win32 Release"
   cd "..\tools\ctestfw"

"common - Win32 ReleaseCLEAN" :
   cd "..\..\common"
   $(MAKE) /$(MAKEFLAGS) /F .\common.mak CFG="common - Win32 Release" RECURSE=1 CLEAN
   cd "..\tools\ctestfw"

!ELSEIF  "$(CFG)" == "ctestfw - Win32 Debug"

"common - Win32 Debug" :
   cd "..\..\common"
   $(MAKE) /$(MAKEFLAGS) /F .\common.mak CFG="common - Win32 Debug"
   cd "..\tools\ctestfw"

"common - Win32 DebugCLEAN" :
   cd "..\..\common"
   $(MAKE) /$(MAKEFLAGS) /F .\common.mak CFG="common - Win32 Debug" RECURSE=1 CLEAN
   cd "..\tools\ctestfw"

!ENDIF