/*************************************************************************
 *
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER.
 * 
 * Copyright 2008 by Sun Microsystems, Inc.
 *
 * OpenOffice.org - a multi-platform office productivity suite
 *
 * $RCSfile: xtextedt.hxx,v $
 * $Revision: 1.3 $
 *
 * This file is part of OpenOffice.org.
 *
 * OpenOffice.org is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License version 3
 * only, as published by the Free Software Foundation.
 *
 * OpenOffice.org is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License version 3 for more details
 * (a copy is included in the LICENSE file that accompanied this code).
 *
 * You should have received a copy of the GNU Lesser General Public License
 * version 3 along with OpenOffice.org.  If not, see
 * <http://www.openoffice.org/license.html>
 * for a copy of the LGPLv3 License.
 *
 ************************************************************************/
#ifndef _XTEXTEDT_HXX
#define _XTEXTEDT_HXX

#include "svtools/svtdllapi.h"
#include <svtools/texteng.hxx>
#include <svtools/textview.hxx>

#define XTEXTUNDO_REPLACEALL	(XTEXTUNDO_START+1)
#define XTEXTUNDO_INDENTBLOCK		122
#define XTEXTUNDO_UNINDENTBLOCK		123

namespace com {
namespace sun {
namespace star {
namespace util {
	struct SearchOptions;
}}}}

class SVT_DLLPUBLIC ExtTextEngine : public TextEngine
{
private:
	String				maGroupChars;

public:
						ExtTextEngine();
						~ExtTextEngine();

	const String&		GetGroupChars() const { return maGroupChars; }
	void				SetGroupChars( const String& r ) { maGroupChars = r; }
	TextSelection		MatchGroup( const TextPaM& rCursor ) const;

	BOOL				Search( TextSelection& rSel, const ::com::sun::star::util::SearchOptions& rSearchOptions, BOOL bForward = TRUE );
};

class SVT_DLLPUBLIC ExtTextView : public TextView
{
protected:
	BOOL				ImpIndentBlock( BOOL bRight );

public:
						ExtTextView( ExtTextEngine* pEng, Window* pWindow );
						~ExtTextView();

	BOOL				MatchGroup();

	BOOL				Search( const ::com::sun::star::util::SearchOptions& rSearchOptions, BOOL bForward );
	USHORT				Replace( const ::com::sun::star::util::SearchOptions& rSearchOptions, BOOL bAll, BOOL bForward );

	BOOL				IndentBlock();
	BOOL				UnindentBlock();
};

#endif // _XTEXTEDT_HXX
