/*************************************************************************
 *
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER.
 * 
 * Copyright 2008 by Sun Microsystems, Inc.
 *
 * OpenOffice.org - a multi-platform office productivity suite
 *
 * $RCSfile: slideview.hxx,v $
 * $Revision: 1.5 $
 *
 * This file is part of OpenOffice.org.
 *
 * OpenOffice.org is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License version 3
 * only, as published by the Free Software Foundation.
 *
 * OpenOffice.org is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License version 3 for more details
 * (a copy is included in the LICENSE file that accompanied this code).
 *
 * You should have received a copy of the GNU Lesser General Public License
 * version 3 along with OpenOffice.org.  If not, see
 * <http://www.openoffice.org/license.html>
 * for a copy of the LGPLv3 License.
 *
 ************************************************************************/

#ifndef INCLUDED_SLIDESHOW_SLIDEVIEW_HXX
#define INCLUDED_SLIDESHOW_SLIDEVIEW_HXX

#include "unoview.hxx"

/* Definition of SlideView factory method */
namespace slideshow
{
    namespace internal
    {
        class EventQueue;
        class EventMultiplexer;

        /** Factory for SlideView

            @param xView
            UNO slide view this object should encapsulate

            @param rEventQueue
            Global event queue, to be used for notification
            messages.

            @param rViewChangeFunc
            Functor to call, when the UNO view signals a repaint.
        */
        UnoViewSharedPtr createSlideView(
            ::com::sun::star::uno::Reference<
                ::com::sun::star::presentation::XSlideShowView> const& xView,
            EventQueue&                                                rEventQueue,
            EventMultiplexer&                                          rEventMultiplexer );
    }
}

#endif /* INCLUDED_SLIDESHOW_SLIDEVIEW_HXX */

