/*************************************************************************
 *
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER.
 * 
 * Copyright 2008 by Sun Microsystems, Inc.
 *
 * OpenOffice.org - a multi-platform office productivity suite
 *
 * $RCSfile: _XPresentation.java,v $
 * $Revision: 1.4 $
 *
 * This file is part of OpenOffice.org.
 *
 * OpenOffice.org is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License version 3
 * only, as published by the Free Software Foundation.
 *
 * OpenOffice.org is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License version 3 for more details
 * (a copy is included in the LICENSE file that accompanied this code).
 *
 * You should have received a copy of the GNU Lesser General Public License
 * version 3 along with OpenOffice.org.  If not, see
 * <http://www.openoffice.org/license.html>
 * for a copy of the LGPLv3 License.
 *
 ************************************************************************/

package ifc.presentation;

import lib.MultiMethodTest;

import com.sun.star.presentation.XPresentation;

/**
* Testing <code>com.sun.star.presentation.XPresentation</code>
* interface methods :
* <ul>
*  <li><code> start()</code></li>
*  <li><code> end()</code></li>
*  <li><code> rehearseTimings()</code></li>
* </ul> <p>
* @see com.sun.star.presentation.XPresentation
*/
public class _XPresentation extends MultiMethodTest {

    public XPresentation oObj = null;

    /**
    * Test calls the method. <p>
    * Has <b> OK </b> status if the method successfully returns. <p>
    */
    public void _start() {
        oObj.start();
        tRes.tested("start()", true);
    }

    /**
    * Test calls the method. <p>
    * Has <b> OK </b> status if the method successfully returns. <p>
    * The following method tests are to be completed successfully before :
    * <ul>
    *  <li> <code> start() </code> : presentation must be started before</li>
    * </ul>
    */
    public void _end() {
        requiredMethod("start()");

        oObj.end();
        tRes.tested("end()", true);
    }

    /**
    * Test calls the method. <p>
    * Has <b> OK </b> status if the method successfully returns. <p>
    */
    public void _rehearseTimings() {
        oObj.rehearseTimings();
        tRes.tested("rehearseTimings()", true);
    }

}  // finish class _XPresentation


