/*************************************************************************
 *
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER.
 * 
 * Copyright 2008 by Sun Microsystems, Inc.
 *
 * OpenOffice.org - a multi-platform office productivity suite
 *
 * $RCSfile: fmtatr2.cxx,v $
 * $Revision: 1.30 $
 *
 * This file is part of OpenOffice.org.
 *
 * OpenOffice.org is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License version 3
 * only, as published by the Free Software Foundation.
 *
 * OpenOffice.org is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License version 3 for more details
 * (a copy is included in the LICENSE file that accompanied this code).
 *
 * You should have received a copy of the GNU Lesser General Public License
 * version 3 along with OpenOffice.org.  If not, see
 * <http://www.openoffice.org/license.html>
 * for a copy of the LGPLv3 License.
 *
 ************************************************************************/

// MARKER(update_precomp.py): autogen include statement, do not remove
#include "precompiled_sw.hxx"



#include "hintids.hxx"
#include "unomid.h"

#ifndef __SBX_SBXVARIABLE_HXX //autogen
#include <basic/sbxvar.hxx>
#endif
#include <svtools/macitem.hxx>
#include <svtools/stritem.hxx>
#include <svtools/stylepool.hxx>
#include <fmtautofmt.hxx>
#include <fchrfmt.hxx>
#include <fmtinfmt.hxx>
#include <txtatr.hxx>
#include <fmtruby.hxx>
#include <charfmt.hxx>
#include <hints.hxx>        // SwUpdateAttr
#include <unostyle.hxx>
#include <unoevent.hxx>		// SwHyperlinkEventDescriptor
#ifndef _COM_SUN_STAR_TEXT_RUBYADJUST_HDL_
#include <com/sun/star/text/RubyAdjust.hdl>
#endif

#ifndef _CMDID_H
#include <cmdid.h>
#endif
#include <com/sun/star/uno/Any.h>
#include <SwStyleNameMapper.hxx>

using namespace ::com::sun::star;
using ::rtl::OUString;

TYPEINIT1_AUTOFACTORY(SwFmtINetFmt, SfxPoolItem);
TYPEINIT1_AUTOFACTORY(SwFmtAutoFmt, SfxPoolItem);

/*************************************************************************
|*
|*    class SwFmtCharFmt
|*    Beschreibung
|*    Ersterstellung    JP 23.11.90
|*    Letzte Aenderung  JP 09.08.94
|*
*************************************************************************/

SwFmtCharFmt::SwFmtCharFmt( SwCharFmt *pFmt )
	: SfxPoolItem( RES_TXTATR_CHARFMT ),
	SwClient(pFmt),
    pTxtAttr( 0 )
{
}



SwFmtCharFmt::SwFmtCharFmt( const SwFmtCharFmt& rAttr )
	: SfxPoolItem( RES_TXTATR_CHARFMT ),
	SwClient( rAttr.GetCharFmt() ),
    pTxtAttr( 0 )
{
}



SwFmtCharFmt::~SwFmtCharFmt() {}



int SwFmtCharFmt::operator==( const SfxPoolItem& rAttr ) const
{
	ASSERT( SfxPoolItem::operator==( rAttr ), "keine gleichen Attribute" );
	return GetCharFmt() == ((SwFmtCharFmt&)rAttr).GetCharFmt();
}



SfxPoolItem* SwFmtCharFmt::Clone( SfxItemPool* ) const
{
	return new SwFmtCharFmt( *this );
}



// weiterleiten an das TextAttribut
void SwFmtCharFmt::Modify( SfxPoolItem* pOld, SfxPoolItem* pNew )
{
	if( pTxtAttr )
		pTxtAttr->Modify( pOld, pNew );
}



// weiterleiten an das TextAttribut
BOOL SwFmtCharFmt::GetInfo( SfxPoolItem& rInfo ) const
{
	return pTxtAttr ? pTxtAttr->GetInfo( rInfo ) : FALSE;
}
BOOL SwFmtCharFmt::QueryValue( uno::Any& rVal, BYTE ) const
{
	String sCharFmtName;
	if(GetCharFmt())
		SwStyleNameMapper::FillProgName(GetCharFmt()->GetName(), sCharFmtName,  nsSwGetPoolIdFromName::GET_POOLID_CHRFMT, sal_True );
	rVal <<= OUString( sCharFmtName );
	return TRUE;
}
BOOL SwFmtCharFmt::PutValue( const uno::Any& , BYTE   )
{
	DBG_ERROR("Zeichenvorlage kann mit PutValue nicht gesetzt werden!");
	return FALSE;
}

/*************************************************************************
|*
|*    class SwFmtAutoFmt
|*    Beschreibung
|*    Ersterstellung    AMA 12.05.06
|*    Letzte Aenderung  AMA 12.05.06
|*
*************************************************************************/

SwFmtAutoFmt::SwFmtAutoFmt( USHORT nInitWhich )
    : SfxPoolItem( nInitWhich )
{
}

SwFmtAutoFmt::SwFmtAutoFmt( const SwFmtAutoFmt& rAttr )
    : SfxPoolItem( rAttr.Which() ), mpHandle( rAttr.mpHandle )
{
}

SwFmtAutoFmt::~SwFmtAutoFmt()
{
}

int SwFmtAutoFmt::operator==( const SfxPoolItem& rAttr ) const
{
	ASSERT( SfxPoolItem::operator==( rAttr ), "different attributes" );
    return mpHandle == ((SwFmtAutoFmt&)rAttr).mpHandle;
}

SfxPoolItem* SwFmtAutoFmt::Clone( SfxItemPool* ) const
{
	return new SwFmtAutoFmt( *this );
}

BOOL SwFmtAutoFmt::QueryValue( uno::Any& rVal, BYTE ) const
{
	String sCharFmtName = StylePool::nameOf( mpHandle );
	rVal <<= OUString( sCharFmtName );
	return TRUE;
}

BOOL SwFmtAutoFmt::PutValue( const uno::Any& , BYTE )
{
	DBG_ERROR("ToDo!");
	return FALSE;
}

/*************************************************************************
|*
|*    class SwFmtINetFmt
|*    Beschreibung
|*    Ersterstellung    AMA 02.08.96
|*    Letzte Aenderung  AMA 02.08.96
|*
*************************************************************************/

SwFmtINetFmt::SwFmtINetFmt()
	: SfxPoolItem( RES_TXTATR_INETFMT ),
    pMacroTbl( 0 ),
    pTxtAttr( 0 ),
    nINetId( 0 ),
	nVisitedId( 0 )
{}

SwFmtINetFmt::SwFmtINetFmt( const XubString& rURL, const XubString& rTarget )
	: SfxPoolItem( RES_TXTATR_INETFMT ),
	aURL( rURL ),
	aTargetFrame( rTarget ),
    pMacroTbl( 0 ),
    pTxtAttr( 0 ),
    nINetId( 0 ),
	nVisitedId( 0 )
{
}

SwFmtINetFmt::SwFmtINetFmt( const SwFmtINetFmt& rAttr )
	: SfxPoolItem( RES_TXTATR_INETFMT ),
	aURL( rAttr.GetValue() ),
    aTargetFrame( rAttr.aTargetFrame ),
    aINetFmt( rAttr.aINetFmt ),
    aVisitedFmt( rAttr.aVisitedFmt ),
    aName( rAttr.aName ),
    pMacroTbl( 0 ),
    pTxtAttr( 0 ),
    nINetId( rAttr.nINetId ),
	nVisitedId( rAttr.nVisitedId )
{
	if( rAttr.GetMacroTbl() )
		pMacroTbl = new SvxMacroTableDtor( *rAttr.GetMacroTbl() );
}

SwFmtINetFmt::~SwFmtINetFmt()
{
	delete pMacroTbl;
}



int SwFmtINetFmt::operator==( const SfxPoolItem& rAttr ) const
{
	ASSERT( SfxPoolItem::operator==( rAttr ), "keine gleichen Attribute" );
	BOOL bRet = SfxPoolItem::operator==( (SfxPoolItem&) rAttr )
				&& aURL == ((SwFmtINetFmt&)rAttr).aURL
				&& aName == ((SwFmtINetFmt&)rAttr).aName
				&& aTargetFrame == ((SwFmtINetFmt&)rAttr).aTargetFrame
				&& aINetFmt == ((SwFmtINetFmt&)rAttr).aINetFmt
				&& aVisitedFmt == ((SwFmtINetFmt&)rAttr).aVisitedFmt
				&& nINetId == ((SwFmtINetFmt&)rAttr).nINetId
				&& nVisitedId == ((SwFmtINetFmt&)rAttr).nVisitedId;

	if( !bRet )
		return FALSE;

	const SvxMacroTableDtor* pOther = ((SwFmtINetFmt&)rAttr).pMacroTbl;
	if( !pMacroTbl )
		return ( !pOther || !pOther->Count() );
	if( !pOther )
		return 0 == pMacroTbl->Count();

	const SvxMacroTableDtor& rOwn = *pMacroTbl;
	const SvxMacroTableDtor& rOther = *pOther;

	// Anzahl unterschiedlich => auf jeden Fall ungleich
	if( rOwn.Count() != rOther.Count() )
		return FALSE;

	// einzeln vergleichen; wegen Performance ist die Reihenfolge wichtig
	for( USHORT nNo = 0; nNo < rOwn.Count(); ++nNo )
	{
		const SvxMacro *pOwnMac = rOwn.GetObject(nNo);
		const SvxMacro *pOtherMac = rOther.GetObject(nNo);
		if ( 	rOwn.GetKey(pOwnMac) != rOther.GetKey(pOtherMac)  ||
				pOwnMac->GetLibName() != pOtherMac->GetLibName() ||
				pOwnMac->GetMacName() != pOtherMac->GetMacName() )
			return FALSE;
	}
	return TRUE;
}



SfxPoolItem* SwFmtINetFmt::Clone( SfxItemPool* ) const
{
	return new SwFmtINetFmt( *this );
}



void SwFmtINetFmt::SetMacroTbl( const SvxMacroTableDtor* pNewTbl )
{
	if( pNewTbl )
	{
		if( pMacroTbl )
			*pMacroTbl = *pNewTbl;
		else
			pMacroTbl = new SvxMacroTableDtor( *pNewTbl );
	}
	else if( pMacroTbl )
		delete pMacroTbl, pMacroTbl = 0;
}



void SwFmtINetFmt::SetMacro( USHORT nEvent, const SvxMacro& rMacro )
{
	if( !pMacroTbl )
		pMacroTbl = new SvxMacroTableDtor;

	SvxMacro *pOldMacro;
	if( 0 != ( pOldMacro = pMacroTbl->Get( nEvent )) )
	{
		delete pOldMacro;
		pMacroTbl->Replace( nEvent, new SvxMacro( rMacro ) );
	}
	else
		pMacroTbl->Insert( nEvent, new SvxMacro( rMacro ) );
}



const SvxMacro* SwFmtINetFmt::GetMacro( USHORT nEvent ) const
{
	const SvxMacro* pRet = 0;
	if( pMacroTbl && pMacroTbl->IsKeyValid( nEvent ) )
		pRet = pMacroTbl->Get( nEvent );
	return pRet;
}



BOOL SwFmtINetFmt::QueryValue( uno::Any& rVal, BYTE nMemberId ) const
{
	BOOL bRet = TRUE;
	XubString sVal;
    nMemberId &= ~CONVERT_TWIPS;
	switch(nMemberId)
	{
		case MID_URL_URL:
			sVal = aURL;
		break;
		case MID_URL_TARGET:
			sVal = aTargetFrame;
		break;
		case MID_URL_HYPERLINKNAME:
			sVal = aName;
		break;
		case MID_URL_VISITED_FMT:
			sVal = aVisitedFmt;
			if( !sVal.Len() && nVisitedId != 0 )
				SwStyleNameMapper::FillUIName( nVisitedId, sVal );
			if( sVal.Len() )
				SwStyleNameMapper::FillProgName( sVal, sVal, nsSwGetPoolIdFromName::GET_POOLID_CHRFMT, sal_True );
		break;
		case MID_URL_UNVISITED_FMT:
			sVal = aINetFmt;
			if( !sVal.Len() && nINetId != 0 )
				SwStyleNameMapper::FillUIName( nINetId, sVal );
			if( sVal.Len() )
				SwStyleNameMapper::FillProgName( sVal, sVal, nsSwGetPoolIdFromName::GET_POOLID_CHRFMT, sal_True );
		break;
		case MID_URL_HYPERLINKEVENTS:
		{
			// create (and return) event descriptor
			SwHyperlinkEventDescriptor* pEvents =
				new SwHyperlinkEventDescriptor();
			pEvents->copyMacrosFromINetFmt(*this);
			uno::Reference<container::XNameReplace> xNameReplace(pEvents);

			// all others return a string; so we just set rVal here and exit
			rVal <<= xNameReplace;
			return bRet;
		}
        default:
        break;
	}
	rVal <<= OUString(sVal);
	return bRet;
}
BOOL SwFmtINetFmt::PutValue( const uno::Any& rVal, BYTE nMemberId  )
{
	BOOL bRet = TRUE;
    nMemberId &= ~CONVERT_TWIPS;

	// all properties except HyperlinkEvents are of type string, hence
	// we treat HyperlinkEvents specially
	if (MID_URL_HYPERLINKEVENTS == nMemberId)
	{
		uno::Reference<container::XNameReplace> xReplace;
		rVal >>= xReplace;
		if (xReplace.is())
		{
			// Create hyperlink event descriptor. Then copy events
			// from argument into descriptor. Then copy events from
			// the descriptor into the format.
			SwHyperlinkEventDescriptor* pEvents = new SwHyperlinkEventDescriptor();
            uno::Reference< lang::XServiceInfo> xHold = pEvents;
			pEvents->copyMacrosFromNameReplace(xReplace);
			pEvents->copyMacrosIntoINetFmt(*this);
		}
		else
		{
			// wrong type!
			bRet = FALSE;
		}
	}
	else
	{
		// all string properties:
		if(rVal.getValueType() != ::getCppuType((rtl::OUString*)0))
			return FALSE;
		XubString sVal = *(rtl::OUString*)rVal.getValue();
		switch(nMemberId)
		{
			case MID_URL_URL:
				aURL = sVal;
				break;
			case MID_URL_TARGET:
				aTargetFrame = sVal;
				break;
			case MID_URL_HYPERLINKNAME:
				aName = sVal;
				break;
			case MID_URL_VISITED_FMT:
			{
				String aString;
				SwStyleNameMapper::FillUIName( sVal, aString, nsSwGetPoolIdFromName::GET_POOLID_CHRFMT, sal_True );
				aVisitedFmt = OUString ( aString );
				nVisitedId = SwStyleNameMapper::GetPoolIdFromUIName( aVisitedFmt,
											   nsSwGetPoolIdFromName::GET_POOLID_CHRFMT );
			}
			break;
			case MID_URL_UNVISITED_FMT:
			{
				String aString;
				SwStyleNameMapper::FillUIName( sVal, aString, nsSwGetPoolIdFromName::GET_POOLID_CHRFMT, sal_True );
				aINetFmt = OUString ( aString );
				nINetId = SwStyleNameMapper::GetPoolIdFromUIName( aINetFmt,	nsSwGetPoolIdFromName::GET_POOLID_CHRFMT );
			}
			break;
			default:
				bRet = FALSE;
		}
	}
	return bRet;
}


/*************************************************************************
|*    class SwFmtRuby
*************************************************************************/

SwFmtRuby::SwFmtRuby( const String& rRubyTxt )
	: SfxPoolItem( RES_TXTATR_CJK_RUBY ),
	sRubyTxt( rRubyTxt ),
    pTxtAttr( 0 ),
    nCharFmtId( 0 ),
    nPosition( 0 ),
    nAdjustment( 0 )
{
}

SwFmtRuby::SwFmtRuby( const SwFmtRuby& rAttr )
	: SfxPoolItem( RES_TXTATR_CJK_RUBY ),
	sRubyTxt( rAttr.sRubyTxt ),
	sCharFmtName( rAttr.sCharFmtName ),
    pTxtAttr( 0 ),
    nCharFmtId( rAttr.nCharFmtId),
    nPosition( rAttr.nPosition ),
    nAdjustment( rAttr.nAdjustment )
{
}

SwFmtRuby::~SwFmtRuby()
{
}

SwFmtRuby& SwFmtRuby::operator=( const SwFmtRuby& rAttr )
{
	sRubyTxt = rAttr.sRubyTxt;
	sCharFmtName = rAttr.sCharFmtName;
	nCharFmtId = rAttr.nCharFmtId;
	nPosition = rAttr.nPosition;
	nAdjustment = rAttr.nAdjustment;
	pTxtAttr =  0;
	return *this;
}

int SwFmtRuby::operator==( const SfxPoolItem& rAttr ) const
{
	ASSERT( SfxPoolItem::operator==( rAttr ), "keine gleichen Attribute" );
	return sRubyTxt == ((SwFmtRuby&)rAttr).sRubyTxt &&
		   sCharFmtName == ((SwFmtRuby&)rAttr).sCharFmtName &&
		   nCharFmtId == ((SwFmtRuby&)rAttr).nCharFmtId &&
		   nPosition == ((SwFmtRuby&)rAttr).nPosition &&
		   nAdjustment == ((SwFmtRuby&)rAttr).nAdjustment;
}

SfxPoolItem* SwFmtRuby::Clone( SfxItemPool* ) const
{
	return new SwFmtRuby( *this );
}

BOOL SwFmtRuby::QueryValue( uno::Any& rVal,
							BYTE nMemberId ) const
{
	BOOL bRet = TRUE;
    nMemberId &= ~CONVERT_TWIPS;
	switch( nMemberId )
	{
		case MID_RUBY_TEXT: rVal <<= (OUString)sRubyTxt; 					break;
 		case MID_RUBY_ADJUST:	rVal <<= (sal_Int16)nAdjustment;	break;
		case MID_RUBY_CHARSTYLE:
		{
			String aString;
			SwStyleNameMapper::FillProgName(sCharFmtName, aString, nsSwGetPoolIdFromName::GET_POOLID_CHRFMT, sal_True );
			rVal <<= OUString ( aString );
		}
		break;
        case MID_RUBY_ABOVE:
        {
            sal_Bool bAbove = !nPosition;
            rVal.setValue(&bAbove, ::getBooleanCppuType());
        }
        break;
        default:
			bRet = FALSE;
	}
	return bRet;
}
BOOL SwFmtRuby::PutValue( const uno::Any& rVal,
							BYTE nMemberId  )
{
	BOOL bRet = TRUE;
    nMemberId &= ~CONVERT_TWIPS;
	switch( nMemberId )
	{
		case MID_RUBY_TEXT:
		{
			OUString sTmp;
			bRet = rVal >>= sTmp;
			sRubyTxt = sTmp;
		}
		break;
 		case MID_RUBY_ADJUST:
		{
			sal_Int16 nSet = 0;
			rVal >>= nSet;
            if(nSet >= 0 && nSet <= text::RubyAdjust_INDENT_BLOCK)
				nAdjustment = nSet;
			else
				bRet = sal_False;
		}
		break;
        case MID_RUBY_ABOVE:
        {
            const uno::Type& rType = ::getBooleanCppuType();
            if(rVal.hasValue() && rVal.getValueType() == rType)
            {
                sal_Bool bAbove = *(sal_Bool*)rVal.getValue();
                nPosition = bAbove ? 0 : 1;
            }
        }
        break;
        case MID_RUBY_CHARSTYLE:
        {
            OUString sTmp;
            bRet = rVal >>= sTmp;
            if(bRet)
                sCharFmtName = SwStyleNameMapper::GetUIName(sTmp, nsSwGetPoolIdFromName::GET_POOLID_CHRFMT );
        }
        break;
		default:
			bRet = FALSE;
	}
	return bRet;
}

