/*************************************************************************
 *
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER.
 * 
 * Copyright 2008 by Sun Microsystems, Inc.
 *
 * OpenOffice.org - a multi-platform office productivity suite
 *
 * $RCSfile: DocumentSettings.java,v $
 * $Revision: 1.4 $
 *
 * This file is part of OpenOffice.org.
 *
 * OpenOffice.org is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License version 3
 * only, as published by the Free Software Foundation.
 *
 * OpenOffice.org is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License version 3 for more details
 * (a copy is included in the LICENSE file that accompanied this code).
 *
 * You should have received a copy of the GNU Lesser General Public License
 * version 3 along with OpenOffice.org.  If not, see
 * <http://www.openoffice.org/license.html>
 * for a copy of the LGPLv3 License.
 *
 ************************************************************************/
package mod._sw;

import com.sun.star.lang.XMultiServiceFactory;
import com.sun.star.text.XTextDocument;
import com.sun.star.uno.XInterface;

import lib.StatusException;
import lib.TestCase;
import lib.TestEnvironment;
import lib.TestParameters;

import util.SOfficeFactory;
import util.WriterTools;

import java.io.PrintWriter;


public class DocumentSettings extends TestCase
{
    XTextDocument xTextDoc = null;

    /**
    * Creates text document.
    */
    protected void initialize(TestParameters tParam, PrintWriter log)
    {
        log.println("    opening xTextDoc ");
        xTextDoc =
            WriterTools.createTextDoc((XMultiServiceFactory) tParam.getMSF());
    }

    /**
    * Disposes text document.
    */
    protected void cleanup(TestParameters tParam, PrintWriter log)
    {
        log.println("    disposing xTextDoc ");
        util.DesktopTools.closeDoc(xTextDoc);
    }

    protected TestEnvironment createTestEnvironment(
        TestParameters tParam, PrintWriter log
    )
    {
        SOfficeFactory SOF =
            SOfficeFactory.getFactory((XMultiServiceFactory) tParam.getMSF());
        XInterface oObj = null;

        log.println("creating a test environment");

        oObj =
            (XInterface) SOF.createInstance(
                xTextDoc, "com.sun.star.text.DocumentSettings"
            );

        TestEnvironment tEnv = new TestEnvironment(oObj);

        return tEnv;
    }
}
