/*************************************************************************
 *
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER.
 * 
 * Copyright 2008 by Sun Microsystems, Inc.
 *
 * OpenOffice.org - a multi-platform office productivity suite
 *
 * $RCSfile: _XThesaurus.java,v $
 * $Revision: 1.4 $
 *
 * This file is part of OpenOffice.org.
 *
 * OpenOffice.org is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License version 3
 * only, as published by the Free Software Foundation.
 *
 * OpenOffice.org is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License version 3 for more details
 * (a copy is included in the LICENSE file that accompanied this code).
 *
 * You should have received a copy of the GNU Lesser General Public License
 * version 3 along with OpenOffice.org.  If not, see
 * <http://www.openoffice.org/license.html>
 * for a copy of the LGPLv3 License.
 *
 ************************************************************************/

package ifc.linguistic2;

import lib.MultiMethodTest;

import com.sun.star.beans.PropertyValue;
import com.sun.star.lang.Locale;
import com.sun.star.linguistic2.XMeaning;
import com.sun.star.linguistic2.XThesaurus;

/**
* Testing <code>com.sun.star.linguistic2.XThesaurus</code>
* interface methods:
* <ul>
*   <li><code>queryMeanings()</code></li>
* </ul> <p>
* @see com.sun.star.linguistic2.XThesaurus
*/
public class _XThesaurus extends MultiMethodTest {

    public XThesaurus oObj = null;

    /**
    * Test calls the method for one of supported language and checks
    * returned value. <p>
    * Has <b> OK </b> status if returned array is not empty
    * and no exceptions were thrown. <p>
    */
    public void _queryMeanings() {
        boolean res = true;
        try {
            XMeaning[] mean = oObj.queryMeanings(
                "survive",new Locale("en","US",""), new PropertyValue[0]);
            res = (mean.length > 0);
        } catch (com.sun.star.lang.IllegalArgumentException ex) {
            log.println("Exception while checking 'queryMeanings'");
            res = false;
            ex.printStackTrace(log);
        }
        tRes.tested("queryMeanings()",res);
    }


}  // finish class


