!IF "$(CFG)" == ""
CFG=makeconv - Win32 Release
!ENDIF

NULL=

!IF  "$(CFG)" == "makeconv - Win32 Release"

OUTDIR=.\Release
INTDIR=.\Release
# Begin Custom Macros
OutDir=.\Release
# End Custom Macros

!IF "$(RECURSE)" == "0"

ALL : "$(OUTDIR)\makeconv.exe" "..\..\..\bin\makeconv.exe"

!ELSE

ALL : "toolutil - Win32 Release" "common - Win32 Release" "$(OUTDIR)\makeconv.exe" "..\..\..\bin\makeconv.exe"

!ENDIF

"$(OUTDIR)" :
    if not exist "$(OUTDIR)" mkdir "$(OUTDIR)"

MTL=midl.exe
CPP=cl.exe
CPP_PROJ=/nologo   /Za /W3 $(EXCEPTIONSWITCH) /I "..\..\..\include" /I "..\..\..\source\common" /I "..\toolutil" /D "WIN32" /D "NDEBUG" /D "_CONSOLE" /D "_MBCS" /D "_CRT_SECURE_NO_DEPRECATE" /Fo"$(INTDIR)\\" /Fd"$(INTDIR)\\" /FD /c

.c{$(INTDIR)}.obj::
   $(CPP) @<<
   $(CPP_PROJ) $<
<<

.cpp{$(INTDIR)}.obj::
   $(CPP) @<<
   $(CPP_PROJ) $<
<<

.cxx{$(INTDIR)}.obj::
   $(CPP) @<<
   $(CPP_PROJ) $<
<<

.c{$(INTDIR)}.sbr::
   $(CPP) @<<
   $(CPP_PROJ) $<
<<

.cpp{$(INTDIR)}.sbr::
   $(CPP) @<<
   $(CPP_PROJ) $<
<<

.cxx{$(INTDIR)}.sbr::
   $(CPP) @<<
   $(CPP_PROJ) $<
<<

RSC=rc.exe
BSC32=bscmake.exe
BSC32_FLAGS=/nologo /o"$(OUTDIR)\makeconv.bsc"
BSC32_SBRS= \

LINK32=link.exe
LINK32_FLAGS=icuuc.lib icutu.lib /nologo /subsystem:console /incremental:no /pdb:"$(OUTDIR)\makeconv.pdb" /machine:I386 /out:"$(OUTDIR)\makeconv.exe" /libpath:"..\..\..\lib"
LINK32_OBJS= \
	$(INTDIR)\gencnvex.obj\
	$(INTDIR)\genmbcs.obj\
	$(INTDIR)\makeconv.obj\
	$(INTDIR)\ucnvstat.obj\
	"..\..\..\lib\icuuc.lib" \
	"..\..\..\lib\icutu.lib"

"$(OUTDIR)\makeconv.exe" : "$(OUTDIR)" $(DEF_FILE) $(LINK32_OBJS)
    $(LINK32) @<<
  $(LINK32_FLAGS) $(LINK32_OBJS)
<<

TargetPath=.\Release\makeconv.exe
InputPath=.\Release\makeconv.exe
InputName=makeconv
SOURCE="$(InputPath)"

"..\..\..\bin\makeconv.exe" : $(SOURCE) "$(INTDIR)" "$(OUTDIR)"
	<<tempfile.bat
	@echo off
	copy $(TargetPath) ..\..\..\bin
<<


!ELSEIF  "$(CFG)" == "makeconv - Win32 Debug"
!ENDIF


!IF "$(NO_EXTERNAL_DEPS)" != "1"
!IF EXISTS("makeconv.dep")
!INCLUDE "makeconv.dep"
!ELSE
!MESSAGE Warning: cannot find "makeconv.dep"
!ENDIF
!ENDIF


!IF "$(CFG)" == "makeconv - Win32 Release" || "$(CFG)" == "makeconv - Win32 Debug"

SOURCE=.\gencnvex.c
"$(INTDIR)\gencnvex.obj": $(SOURCE) "$(INTDIR)" "..\..\common\unicode\utypes.h" "..\..\common\unicode\ustring.h"

SOURCE=.\genmbcs.c
"$(INTDIR)\genmbcs.obj": $(SOURCE) "$(INTDIR)" "..\..\common\unicode\utypes.h"

SOURCE=.\makeconv.c
"$(INTDIR)\makeconv.obj": $(SOURCE) "$(INTDIR)" "..\..\common\unicode\putil.h" "..\..\common\unicode\ucnv_err.h" "..\..\common\unicode\udata.h"

SOURCE=.\ucnvstat.c
"$(INTDIR)\ucnvstat.obj": $(SOURCE) "$(INTDIR)" "..\..\common\unicode\utypes.h" "..\..\common\unicode\ucnv.h"


!IF  "$(CFG)" == "makeconv - Win32 Release"

"common - Win32 Release" :
   cd "..\..\common"
   $(MAKE) /$(MAKEFLAGS) /F .\common.mak CFG="common - Win32 Release"
   cd "..\tools\makeconv"

"common - Win32 ReleaseCLEAN" :
   cd "..\..\common"
   $(MAKE) /$(MAKEFLAGS) /F .\common.mak CFG="common - Win32 Release" RECURSE=1 CLEAN
   cd "..\tools\makeconv"

!ELSEIF  "$(CFG)" == "makeconv - Win32 Debug"

"common - Win32 Debug" :
   cd "..\..\common"
   $(MAKE) /$(MAKEFLAGS) /F .\common.mak CFG="common - Win32 Debug"
   cd "..\tools\makeconv"

"common - Win32 DebugCLEAN" :
   cd "..\..\common"
   $(MAKE) /$(MAKEFLAGS) /F .\common.mak CFG="common - Win32 Debug" RECURSE=1 CLEAN
   cd "..\tools\makeconv"

!ENDIF

!IF  "$(CFG)" == "makeconv - Win32 Release"

"toolutil - Win32 Release" :
   cd "..\..\tools\toolutil"
   $(MAKE) /$(MAKEFLAGS) /F .\toolutil.mak CFG="toolutil - Win32 Release"
   cd "..\makeconv"

"toolutil - Win32 ReleaseCLEAN" :
   cd "..\..\tools\toolutil"
   $(MAKE) /$(MAKEFLAGS) /F .\toolutil.mak CFG="toolutil - Win32 Release" RECURSE=1 CLEAN
   cd "..\makeconv"

!ELSEIF  "$(CFG)" == "makeconv - Win32 Debug"

"toolutil - Win32 Debug" :
   cd "..\..\tools\toolutil"
   $(MAKE) /$(MAKEFLAGS) /F .\toolutil.mak CFG="toolutil - Win32 Debug"
   cd "..\makeconv"

"toolutil - Win32 DebugCLEAN" :
   cd "..\..\tools\toolutil"
   $(MAKE) /$(MAKEFLAGS) /F .\toolutil.mak CFG="toolutil - Win32 Debug" RECURSE=1 CLEAN
   cd "..\makeconv"

!ENDIF


!ENDIF