/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.internal.ws.transport.http.server;

import com.sun.net.httpserver.HttpContext;
import com.sun.net.httpserver.HttpServer;
import com.sun.xml.internal.ws.server.ServerRtException;
import java.net.InetSocketAddress;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.logging.Logger;

final class ServerMgr {
    private static final ServerMgr serverMgr = new ServerMgr();
    private static final Logger logger = Logger.getLogger("javax.enterprise.resource.webservices.jaxws.server.http");
    private final Map<InetSocketAddress, ServerState> servers = new HashMap<InetSocketAddress, ServerState>();

    private ServerMgr() {
    }

    public static ServerMgr getInstance() {
        return serverMgr;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public HttpContext createContext(String string) {
        try {
            ServerState serverState;
            URL uRL = new URL(string);
            int n = uRL.getPort();
            if (n == -1) {
                n = uRL.getDefaultPort();
            }
            InetSocketAddress inetSocketAddress = new InetSocketAddress(uRL.getHost(), n);
            Object object = this.servers;
            synchronized (object) {
                serverState = this.servers.get(inetSocketAddress);
                if (serverState == null) {
                    logger.fine("Creating new HTTP Server at " + inetSocketAddress);
                    HttpServer httpServer = HttpServer.create(inetSocketAddress, 5);
                    httpServer.setExecutor(Executors.newFixedThreadPool(5));
                    String string2 = uRL.toURI().getPath();
                    logger.fine("Creating HTTP Context at = " + string2);
                    HttpContext httpContext = httpServer.createContext(string2);
                    httpServer.start();
                    logger.fine("HTTP server started = " + inetSocketAddress);
                    serverState = new ServerState(httpServer);
                    this.servers.put(inetSocketAddress, serverState);
                    return httpContext;
                }
            }
            HttpServer httpServer = serverState.getServer();
            logger.fine("Creating HTTP Context at = " + uRL.getPath());
            object = httpServer.createContext(uRL.getPath());
            serverState.oneMoreContext();
            return object;
        }
        catch (Exception exception) {
            throw new ServerRtException("server.rt.err", new Object[]{exception});
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeContext(HttpContext httpContext) {
        InetSocketAddress inetSocketAddress = httpContext.getServer().getAddress();
        Map<InetSocketAddress, ServerState> map = this.servers;
        synchronized (map) {
            ServerState serverState = this.servers.get(inetSocketAddress);
            int n = serverState.noOfContexts();
            if (n < 2) {
                ((ExecutorService)serverState.getServer().getExecutor()).shutdown();
                serverState.getServer().stop(0);
                this.servers.remove(inetSocketAddress);
            } else {
                serverState.getServer().removeContext(httpContext);
                serverState.oneLessContext();
            }
        }
    }

    private static final class ServerState {
        private final HttpServer server;
        private int instances;

        ServerState(HttpServer httpServer) {
            this.server = httpServer;
            this.instances = 1;
        }

        public HttpServer getServer() {
            return this.server;
        }

        public void oneMoreContext() {
            ++this.instances;
        }

        public void oneLessContext() {
            --this.instances;
        }

        public int noOfContexts() {
            return this.instances;
        }
    }
}

