/*************************************************************************
 *
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER.
 * 
 * Copyright 2008 by Sun Microsystems, Inc.
 *
 * OpenOffice.org - a multi-platform office productivity suite
 *
 * $RCSfile: StyleMapperXmlFactoryModule.java,v $
 * $Revision: 1.1.1.1 $
 *
 * This file is part of OpenOffice.org.
 *
 * OpenOffice.org is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License version 3
 * only, as published by the Free Software Foundation.
 *
 * OpenOffice.org is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License version 3 for more details
 * (a copy is included in the LICENSE file that accompanied this code).
 *
 * You should have received a copy of the GNU Lesser General Public License
 * version 3 along with OpenOffice.org.  If not, see
 * <http://www.openoffice.org/license.html>
 * for a copy of the LGPLv3 License.
 *
 ************************************************************************/
package com.sun.star.report.pentaho.styles;

import org.jfree.xmlns.parser.XmlDocumentInfo;
import org.jfree.xmlns.parser.XmlFactoryModule;
import org.jfree.xmlns.parser.XmlReadHandler;

/**
 * An XML-FactoryModule that load the style-mapper contents.
 *
 * @author Thomas Morgner
 * @since 12.03.2007
 */
public class StyleMapperXmlFactoryModule implements XmlFactoryModule
{

    public static final String NAMESPACE =
            "http://jfreereport.sourceforge.net/namespaces/engine/openoffice/stylemapper";

    public StyleMapperXmlFactoryModule()
    {
    }

    public XmlReadHandler createReadHandler(final XmlDocumentInfo documentInfo)
    {
        return new StyleMappingDocumentReadHandler();
    }

    public int getDocumentSupport(final XmlDocumentInfo documentInfo)
    {
        final String rootNamespace = documentInfo.getRootElementNameSpace();
        if (StyleMapperXmlFactoryModule.NAMESPACE.equals(rootNamespace) &&
                "style-mapper-definition".equals(documentInfo.getRootElement()))
        {

            return XmlFactoryModule.RECOGNIZED_BY_NAMESPACE;
        }
        return XmlFactoryModule.NOT_RECOGNIZED;
    }

    public String getDefaultNamespace(final XmlDocumentInfo documentInfo)
    {
        return null;
    }
}

