/*************************************************************************
 *
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER.
 * 
 * Copyright 2008 by Sun Microsystems, Inc.
 *
 * OpenOffice.org - a multi-platform office productivity suite
 *
 * $RCSfile: e3dsphereproperties.cxx,v $
 * $Revision: 1.7 $
 *
 * This file is part of OpenOffice.org.
 *
 * OpenOffice.org is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License version 3
 * only, as published by the Free Software Foundation.
 *
 * OpenOffice.org is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License version 3 for more details
 * (a copy is included in the LICENSE file that accompanied this code).
 *
 * You should have received a copy of the GNU Lesser General Public License
 * version 3 along with OpenOffice.org.  If not, see
 * <http://www.openoffice.org/license.html>
 * for a copy of the LGPLv3 License.
 *
 ************************************************************************/

// MARKER(update_precomp.py): autogen include statement, do not remove
#include "precompiled_svx.hxx"
#include <svx/sdr/properties/e3dsphereproperties.hxx>
#include <svtools/itemset.hxx>
#include <svx/sphere3d.hxx>

//////////////////////////////////////////////////////////////////////////////

namespace sdr
{
	namespace properties
	{
		E3dSphereProperties::E3dSphereProperties(SdrObject& rObj)
		:	E3dCompoundProperties(rObj)
		{
		}

		E3dSphereProperties::E3dSphereProperties(const E3dSphereProperties& rProps, SdrObject& rObj)
		:	E3dCompoundProperties(rProps, rObj)
		{
		}

		E3dSphereProperties::~E3dSphereProperties()
		{
		}

		BaseProperties& E3dSphereProperties::Clone(SdrObject& rObj) const
		{
			return *(new E3dSphereProperties(*this, rObj));
		}

		void E3dSphereProperties::PostItemChange(const sal_uInt16 nWhich)
		{
			// call parent
			E3dCompoundProperties::PostItemChange(nWhich);

			// handle value change
			E3dSphereObj& rObj = (E3dSphereObj&)GetSdrObject();

			switch(nWhich)
			{
				case SDRATTR_3DOBJ_HORZ_SEGS:
				{
					rObj.InvalidateGeometry();
					break;
				}
				case SDRATTR_3DOBJ_VERT_SEGS:
				{
					rObj.InvalidateGeometry();
					break;
				}
			}
		}
	} // end of namespace properties
} // end of namespace sdr

//////////////////////////////////////////////////////////////////////////////
// eof
