/*************************************************************************
 *
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER.
 * 
 * Copyright 2008 by Sun Microsystems, Inc.
 *
 * OpenOffice.org - a multi-platform office productivity suite
 *
 * $RCSfile: viewobjectcontactlist.hxx,v $
 * $Revision: 1.6 $
 *
 * This file is part of OpenOffice.org.
 *
 * OpenOffice.org is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License version 3
 * only, as published by the Free Software Foundation.
 *
 * OpenOffice.org is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License version 3 for more details
 * (a copy is included in the LICENSE file that accompanied this code).
 *
 * You should have received a copy of the GNU Lesser General Public License
 * version 3 along with OpenOffice.org.  If not, see
 * <http://www.openoffice.org/license.html>
 * for a copy of the LGPLv3 License.
 *
 ************************************************************************/

#ifndef _SDR_CONTACT_VIEWOBJECTCONTACTLIST_HXX
#define _SDR_CONTACT_VIEWOBJECTCONTACTLIST_HXX

#include <sal/types.h>

#include <vector>

//////////////////////////////////////////////////////////////////////////////
// predeclarations

class Region;

namespace sdr
{
	namespace contact
	{
		class ViewObjectContact;

		// typedefs for a vector of ViewObjectContacts
		typedef ::std::vector< ViewObjectContact* > ViewObjectContactVector;

		class ObjectContact;
		class DisplayInfo;
		class ViewContact;
	} // end of namespace contact
} // end of namespace sdr

//////////////////////////////////////////////////////////////////////////////

namespace sdr
{
	namespace contact
	{
		class ViewObjectContactList
		{
		private:
			
			// counter for entries
			sal_uInt32											mnCount;

			// entries in a union to allow list or single pointer
			union
			{
				ViewObjectContactVector*						mpVOCVector;
				ViewObjectContact*								mpVOContact;
			} maUnion;

            //no copy constructor
            ViewObjectContactList(const ViewObjectContactList& rSource);

		public:
			ViewObjectContactList();

			~ViewObjectContactList();

			sal_uInt32 Count() const { return mnCount; }

			ViewObjectContact* GetObject(sal_uInt32 nIndex) const;

			ViewObjectContact* GetLastObjectAndRemove();

			void Clear();

			void Append(ViewObjectContact* pNew);

			// Returns sal_True if remove was successful
			sal_Bool Remove(ViewObjectContact* pOld);

			sal_Bool Contains(ViewObjectContact* pOld);

			// This method only recursively clears the draw hierarchy structure between the
			// DrawObjectContacts, it does not delete any to make them reusable.
			void ClearDrawHierarchy();

			// This method recursively rebuilds the draw hierarchy structure in parallel
			// to the SdrObject structure.
			void BuildDrawHierarchy(ObjectContact& rObjectContact, ViewContact& rSourceNode, ViewObjectContact* pParent);

			// This method recursively checks the draw hierarchy structure in parallel
			// to the SdrObject structure and rebuilds the invalid parts.
			void CheckDrawHierarchy(ObjectContact& rObjectContact);

			// If DrawHierarchy is handled by a object itself, the sub-objects are set 
			// to be equally painted to that object
			void CopyPaintFlagsFromParent(const ViewObjectContact& rParent);

            void FlatCopyFrom( const ViewObjectContactList& rSource );
		};
	} // end of namespace contact
} // end of namespace sdr

//////////////////////////////////////////////////////////////////////////////

#endif //_SDR_CONTACT_VIEWOBJECTCONTACTLIST_HXX

// eof
