/*************************************************************************
 *
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER.
 * 
 * Copyright 2008 by Sun Microsystems, Inc.
 *
 * OpenOffice.org - a multi-platform office productivity suite
 *
 * $RCSfile: transliteration_caseignore.hxx,v $
 * $Revision: 1.5 $
 *
 * This file is part of OpenOffice.org.
 *
 * OpenOffice.org is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License version 3
 * only, as published by the Free Software Foundation.
 *
 * OpenOffice.org is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License version 3 for more details
 * (a copy is included in the LICENSE file that accompanied this code).
 *
 * You should have received a copy of the GNU Lesser General Public License
 * version 3 along with OpenOffice.org.  If not, see
 * <http://www.openoffice.org/license.html>
 * for a copy of the LGPLv3 License.
 *
 ************************************************************************/
#ifndef TRANSLITERATION_CASE_IGNORE_H
#define TRANSLITERATION_CASE_IGNORE_H

#define TRANSLITERATION_UPPER_LOWER
#include "transliteration_body.hxx"

namespace com { namespace sun { namespace star { namespace i18n {

class Transliteration_caseignore: public Transliteration_body
{
public:
	Transliteration_caseignore();

	// Methods which are shared.
	sal_Int16 SAL_CALL getType() throw(com::sun::star::uno::RuntimeException);

	void SAL_CALL loadModule( TransliterationModules modName, const com::sun::star::lang::Locale& rLocale )
	throw(com::sun::star::uno::RuntimeException);

	com::sun::star::uno::Sequence< rtl::OUString > SAL_CALL transliterateRange(
	    const rtl::OUString& str1, const rtl::OUString& str2 ) 
	throw(com::sun::star::uno::RuntimeException);

	sal_Bool SAL_CALL equals(
	    const rtl::OUString& str1, sal_Int32 pos1, sal_Int32 nCount1, sal_Int32& nMatch1,
	    const rtl::OUString& src2, sal_Int32 pos2, sal_Int32 nCount2, sal_Int32& nMatch2)
	throw(com::sun::star::uno::RuntimeException);

	sal_Int32 SAL_CALL compareSubstring(
	    const rtl::OUString& s1, sal_Int32 off1, sal_Int32 len1,
	    const rtl::OUString& s2, sal_Int32 off2, sal_Int32 len2)
	throw(com::sun::star::uno::RuntimeException);

	sal_Int32 SAL_CALL compareString(
	    const rtl::OUString& s1,
	    const rtl::OUString& s2)
	throw(com::sun::star::uno::RuntimeException);

protected:
	TransliterationModules moduleLoaded;
private:
	sal_Int32 SAL_CALL compare( 
	    const rtl::OUString& str1, sal_Int32 pos1, sal_Int32 nCount1, sal_Int32& nMatch1, 
	    const rtl::OUString& str2, sal_Int32 pos2, sal_Int32 nCount2, sal_Int32& nMatch2) 
	throw(com::sun::star::uno::RuntimeException);
};

class Transliteration_simplecaseignore: public Transliteration_caseignore
{
public:
	Transliteration_simplecaseignore();
};

} } } }

#endif
