/*************************************************************************
 *
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER.
 * 
 * Copyright 2008 by Sun Microsystems, Inc.
 *
 * OpenOffice.org - a multi-platform office productivity suite
 *
 * $RCSfile: resetableguard.cxx,v $
 * $Revision: 1.4 $
 *
 * This file is part of OpenOffice.org.
 *
 * OpenOffice.org is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License version 3
 * only, as published by the Free Software Foundation.
 *
 * OpenOffice.org is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License version 3 for more details
 * (a copy is included in the LICENSE file that accompanied this code).
 *
 * You should have received a copy of the GNU Lesser General Public License
 * version 3 along with OpenOffice.org.  If not, see
 * <http://www.openoffice.org/license.html>
 * for a copy of the LGPLv3 License.
 *
 ************************************************************************/

// MARKER(update_precomp.py): autogen include statement, do not remove
#include "precompiled_framework.hxx"

//_________________________________________________________________________________________________________________
//	my own includes
//_________________________________________________________________________________________________________________
#include <threadhelp/resetableguard.hxx>

//_________________________________________________________________________________________________________________
//	interface includes
//_________________________________________________________________________________________________________________

//_________________________________________________________________________________________________________________
//	other includes
//_________________________________________________________________________________________________________________

//_________________________________________________________________________________________________________________
//	const
//_________________________________________________________________________________________________________________

//_________________________________________________________________________________________________________________
//	namespace
//_________________________________________________________________________________________________________________

namespace framework{

using namespace ::osl	;

//_________________________________________________________________________________________________________________
//	non exported const
//_________________________________________________________________________________________________________________

//_________________________________________________________________________________________________________________
//	non exported declarations
//_________________________________________________________________________________________________________________

//_________________________________________________________________________________________________________________
//	definitions
//_________________________________________________________________________________________________________________

//*****************************************************************************************************************
//	constructor
//*****************************************************************************************************************
ResetableGuard::ResetableGuard( Mutex* pMutex )
	:	m_pMutex	( pMutex	)
	,	m_bLocked	( sal_False	)
{
	lock();
}

//*****************************************************************************************************************
//	constructor
//*****************************************************************************************************************
ResetableGuard::ResetableGuard( Mutex& rMutex )
	:	m_pMutex	( &rMutex	)
	,	m_bLocked	( sal_False	)
{
	lock();
}

//*****************************************************************************************************************
//	destructor
//*****************************************************************************************************************
ResetableGuard::~ResetableGuard()
{
	unlock();
}

//*****************************************************************************************************************
//	public method
//*****************************************************************************************************************
void ResetableGuard::lock()
{
	if( m_bLocked == sal_False )
	{
		m_bLocked = m_pMutex->acquire();
	}
}

//*****************************************************************************************************************
//	public method
//*****************************************************************************************************************
void ResetableGuard::unlock()
{
	if( m_bLocked == sal_True )
	{
		m_bLocked = !(m_pMutex->release());
	}
}

//*****************************************************************************************************************
//	public method
//*****************************************************************************************************************
sal_Bool ResetableGuard::tryToLock()
{
	if( m_bLocked == sal_False )
	{
		m_bLocked = m_pMutex->tryToAcquire();
	}
	return m_bLocked;
}

//*****************************************************************************************************************
//	public method
//*****************************************************************************************************************
sal_Bool ResetableGuard::isLocked() const
{
	return m_bLocked;
}

}	//	namespace framework
