/*************************************************************************
 *
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER.
 * 
 * Copyright 2008 by Sun Microsystems, Inc.
 *
 * OpenOffice.org - a multi-platform office productivity suite
 *
 * $RCSfile: DatabaseMetaData.cxx,v $
 * $Revision: 1.29 $
 *
 * This file is part of OpenOffice.org.
 *
 * OpenOffice.org is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License version 3
 * only, as published by the Free Software Foundation.
 *
 * OpenOffice.org is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License version 3 for more details
 * (a copy is included in the LICENSE file that accompanied this code).
 *
 * You should have received a copy of the GNU Lesser General Public License
 * version 3 along with OpenOffice.org.  If not, see
 * <http://www.openoffice.org/license.html>
 * for a copy of the LGPLv3 License.
 *
 ************************************************************************/

// MARKER(update_precomp.py): autogen include statement, do not remove
#include "precompiled_connectivity.hxx"
#include "java/sql/DatabaseMetaData.hxx"
#include "java/sql/Connection.hxx"
#include "java/sql/ResultSet.hxx"
#include "java/tools.hxx"
#include "java/lang/String.hxx"
#include "connectivity/CommonTools.hxx"
#include "FDatabaseMetaDataResultSet.hxx"
#include <comphelper/types.hxx>
#include "TPrivilegesResultSet.hxx"
#include "diagnose_ex.h"
#include "resource/jdbc_log.hrc"

using namespace ::comphelper;

using namespace connectivity;
using namespace ::com::sun::star::uno;
using namespace ::com::sun::star::beans;
using namespace ::com::sun::star::sdbc;
using namespace ::com::sun::star::container;
using namespace ::com::sun::star::lang;

//**************************************************************
//************ Class: java.sql.DatabaseMetaData
//**************************************************************

jclass java_sql_DatabaseMetaData::theClass				= 0;

java_sql_DatabaseMetaData::~java_sql_DatabaseMetaData()
{
	SDBThreadAttach::releaseRef();
}

jclass java_sql_DatabaseMetaData::getMyClass()
{
	// die Klasse muss nur einmal geholt werden, daher statisch
	if( !theClass ){
        SDBThreadAttach t; OSL_ENSURE(t.pEnv,"Java Enviroment geloescht worden!");
		if( !t.pEnv ) return (jclass)0;
		jclass tempClass = t.pEnv->FindClass("java/sql/DatabaseMetaData"); OSL_ENSURE(tempClass,"Java : FindClass nicht erfolgreich!");
		jclass globClass = (jclass)t.pEnv->NewGlobalRef( tempClass );
		t.pEnv->DeleteLocalRef( tempClass );
		saveClassRef( globClass );
	}
	return theClass;
}
// -----------------------------------------------------------------------------
java_sql_DatabaseMetaData::java_sql_DatabaseMetaData( JNIEnv * pEnv, jobject myObj, java_sql_Connection& _rConnection )
    :ODatabaseMetaDataBase( &_rConnection,_rConnection.getConnectionInfo() )
    ,java_lang_Object( pEnv, myObj )
	,m_pConnection( &_rConnection )
    ,m_aLogger( _rConnection.getLogger() )
{
	SDBThreadAttach::addRef();
}

// -------------------------------------------------------------------------
void java_sql_DatabaseMetaData::saveClassRef( jclass pClass )
{
	if( pClass==0  )
		return;
	// der uebergebe Klassen-Handle ist schon global, daher einfach speichern
	theClass = pClass;
}
// -------------------------------------------------------------------------
Reference< XResultSet > java_sql_DatabaseMetaData::impl_getTypeInfo_throw(  )
{
	static jmethodID mID = NULL;
    return impl_callResultSetMethod( "getTypeInfo", mID );
}
// -------------------------------------------------------------------------
Reference< XResultSet > SAL_CALL java_sql_DatabaseMetaData::getCatalogs(  ) throw(SQLException, RuntimeException)
{
	static jmethodID mID = NULL;
    return impl_callResultSetMethod( "getCatalogs", mID );
}
// -------------------------------------------------------------------------
::rtl::OUString java_sql_DatabaseMetaData::impl_getCatalogSeparator_throw(  )
{
	static jmethodID mID = NULL;
    return impl_callStringMethod( "getCatalogSeparator", mID );
}
// -------------------------------------------------------------------------
Reference< XResultSet > SAL_CALL java_sql_DatabaseMetaData::getSchemas(  ) throw(SQLException, RuntimeException)
{
	static jmethodID mID = NULL;
    return impl_callResultSetMethod( "getSchemas", mID );
}
// -------------------------------------------------------------------------
Reference< XResultSet > SAL_CALL java_sql_DatabaseMetaData::getColumnPrivileges(
        const Any& catalog, const ::rtl::OUString& schema, const ::rtl::OUString& table, const ::rtl::OUString& columnNamePattern ) throw(SQLException, RuntimeException)
{
	static jmethodID mID = NULL;
    return impl_callResultSetMethodWithStrings( "getColumnPrivileges", mID, catalog, schema, table, &columnNamePattern );
}
// -------------------------------------------------------------------------
Reference< XResultSet > SAL_CALL java_sql_DatabaseMetaData::getColumns(
        const Any& catalog, const ::rtl::OUString& schemaPattern, const ::rtl::OUString& tableNamePattern, const ::rtl::OUString& columnNamePattern ) throw(SQLException, RuntimeException)
{
	static jmethodID mID = NULL;
    return impl_callResultSetMethodWithStrings( "getColumns", mID, catalog, schemaPattern, tableNamePattern, &columnNamePattern );
}
// -------------------------------------------------------------------------
Reference< XResultSet > SAL_CALL java_sql_DatabaseMetaData::getTables(
        const Any& catalog, const ::rtl::OUString& schemaPattern, const ::rtl::OUString& tableNamePattern, const Sequence< ::rtl::OUString >& types ) throw(SQLException, RuntimeException)
{
	static const char * cSignature = "(Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;[Ljava/lang/String;)Ljava/sql/ResultSet;";
	static const char * cMethodName = "getTables";

    m_aLogger.log( LogLevel::FINEST, STR_LOG_META_DATA_METHOD, cMethodName );

    jobject out(0);
    SDBThreadAttach t; OSL_ENSURE(t.pEnv,"Java Enviroment geloescht worden!");
	if( t.pEnv )
    {
		// Java-Call absetzen
		static jmethodID mID = NULL;
		if ( !mID  )
			mID  = t.pEnv->GetMethodID( getMyClass(), cMethodName, cSignature );OSL_ENSURE(mID,"Unknown method id!");
		OSL_VERIFY_RES( !isExceptionOccured(t.pEnv,sal_True),"Exception occured!");
		if( mID )
		{
			jvalue args[4];
			sal_Int32 len = types.getLength();
			if(len)
			{
				jobjectArray pObjArray = static_cast<jobjectArray>(t.pEnv->NewObjectArray((jsize) len, java_lang_String::getMyClass(), 0));
				OSL_VERIFY_RES( !isExceptionOccured(t.pEnv,sal_True),"Exception occured!");

				const ::rtl::OUString* pBegin = types.getConstArray();
				for(sal_Int32 i=0;i<len;i++,++pBegin)
				{
					jstring aT = convertwchar_tToJavaString(t.pEnv,*pBegin);
					//jstring aT = t.pEnv->NewStringUTF(_par3.GetToken(i));
					t.pEnv->SetObjectArrayElement(pObjArray,(jsize)i,aT);
					OSL_VERIFY_RES( !isExceptionOccured(t.pEnv,sal_True),"Exception occured!");

				}
				args[3].l = pObjArray;
			}else
				args[3].l = 0;
			// temporaere Variable initialisieren
			args[0].l = catalog.hasValue() ? convertwchar_tToJavaString(t.pEnv,comphelper::getString(catalog)) : 0;
			args[1].l = schemaPattern.toChar() == '%' ? NULL : convertwchar_tToJavaString(t.pEnv,schemaPattern);
			args[2].l = convertwchar_tToJavaString(t.pEnv,tableNamePattern);
			out = t.pEnv->CallObjectMethod( object, mID, args[0].l, args[1].l,args[2].l,args[3].l);
			jthrowable jThrow = t.pEnv->ExceptionOccurred();
			if ( jThrow )
				t.pEnv->ExceptionClear();// we have to clear the exception here because we want to handle it itself

			sal_Bool bExcepOccured;

			if(catalog.hasValue())
			{
				t.pEnv->DeleteLocalRef((jstring)args[0].l);
				bExcepOccured = isExceptionOccured(t.pEnv,sal_True); OSL_ENSURE(!bExcepOccured,"Exception occured!");
			}
			if(args[1].l)
			{
				t.pEnv->DeleteLocalRef((jstring)args[1].l);
				bExcepOccured = isExceptionOccured(t.pEnv,sal_True); OSL_ENSURE(!bExcepOccured,"Exception occured!");
			}
			if(tableNamePattern.getLength())
			{
				t.pEnv->DeleteLocalRef((jstring)args[2].l);
				bExcepOccured = isExceptionOccured(t.pEnv,sal_True); OSL_ENSURE(!bExcepOccured,"Exception occured!");
			}
			//for(INT16 i=0;i<len;i++)
			t.pEnv->DeleteLocalRef((jobjectArray)args[3].l);
			bExcepOccured = isExceptionOccured(t.pEnv,sal_True); OSL_ENSURE(!bExcepOccured,"Exception occured!");

			if ( jThrow )
			{
				if(t.pEnv->IsInstanceOf(jThrow,java_sql_SQLException_BASE::getMyClass()))
				{
					java_sql_SQLException_BASE* pException = new java_sql_SQLException_BASE(t.pEnv,jThrow);
					SQLException e(	pException->getMessage(),
										*this,
										pException->getSQLState(),
										pException->getErrorCode(),
										Any()
									);
					delete pException;
					throw  e;
				}
			}

		}
	}

    if ( !out )
        return NULL;

    m_aLogger.log( LogLevel::FINEST, STR_LOG_META_DATA_SUCCESS, cMethodName );
	return new java_sql_ResultSet( t.pEnv, out, m_aLogger,*m_pConnection);
}
// -------------------------------------------------------------------------
Reference< XResultSet > SAL_CALL java_sql_DatabaseMetaData::getProcedureColumns(
        const Any& catalog, const ::rtl::OUString& schemaPattern, const ::rtl::OUString& procedureNamePattern, const ::rtl::OUString& columnNamePattern ) throw(SQLException, RuntimeException)
{
	static jmethodID mID = NULL;
    return impl_callResultSetMethodWithStrings( "getProcedureColumns", mID, catalog, schemaPattern, procedureNamePattern, &columnNamePattern );
}
// -------------------------------------------------------------------------
Reference< XResultSet > SAL_CALL java_sql_DatabaseMetaData::getProcedures( const Any&
                catalog, const ::rtl::OUString& schemaPattern, const ::rtl::OUString& procedureNamePattern ) throw(SQLException, RuntimeException)
{
	static jmethodID mID = NULL;
    return impl_callResultSetMethodWithStrings( "getProcedures", mID, catalog, schemaPattern, procedureNamePattern );
}
// -------------------------------------------------------------------------
Reference< XResultSet > SAL_CALL java_sql_DatabaseMetaData::getVersionColumns(
        const Any& catalog, const ::rtl::OUString& schema, const ::rtl::OUString& table ) throw(SQLException, RuntimeException)
{
	static jmethodID mID = NULL;
    return impl_callResultSetMethodWithStrings( "getVersionColumns", mID, catalog, schema, table );
}
// -------------------------------------------------------------------------
sal_Int32 SAL_CALL java_sql_DatabaseMetaData::getMaxBinaryLiteralLength(  ) throw(SQLException, RuntimeException)
{
	static jmethodID mID = NULL;
    return impl_callIntMethod( "getMaxBinaryLiteralLength", mID );
}
// -------------------------------------------------------------------------
sal_Int32 SAL_CALL java_sql_DatabaseMetaData::getMaxRowSize(  ) throw(SQLException, RuntimeException)
{
	static jmethodID mID = NULL;
    return impl_callIntMethod( "getMaxRowSize", mID );
}
// -------------------------------------------------------------------------
sal_Int32 SAL_CALL java_sql_DatabaseMetaData::getMaxCatalogNameLength(  ) throw(SQLException, RuntimeException)
{
	static jmethodID mID = NULL;
    return impl_callIntMethod( "getMaxCatalogNameLength", mID );
}
// -------------------------------------------------------------------------
sal_Int32 SAL_CALL java_sql_DatabaseMetaData::getMaxCharLiteralLength(  ) throw(SQLException, RuntimeException)
{
	static jmethodID mID = NULL;
    return impl_callIntMethod( "getMaxCharLiteralLength", mID );
}
// -------------------------------------------------------------------------
sal_Int32 SAL_CALL java_sql_DatabaseMetaData::getMaxColumnNameLength(  ) throw(SQLException, RuntimeException)
{
	static jmethodID mID = NULL;
    return impl_callIntMethod( "getMaxColumnNameLength", mID );
}
// -------------------------------------------------------------------------
sal_Int32 SAL_CALL java_sql_DatabaseMetaData::getMaxColumnsInIndex(  ) throw(SQLException, RuntimeException)
{
	static jmethodID mID = NULL;
    return impl_callIntMethod( "getMaxColumnsInIndex", mID );
}
// -------------------------------------------------------------------------
sal_Int32 SAL_CALL java_sql_DatabaseMetaData::getMaxCursorNameLength(  ) throw(SQLException, RuntimeException)
{
	static jmethodID mID = NULL;
    return impl_callIntMethod( "getMaxCursorNameLength", mID );
}
// -------------------------------------------------------------------------
sal_Int32 SAL_CALL java_sql_DatabaseMetaData::getMaxConnections(  ) throw(SQLException, RuntimeException)
{
	static jmethodID mID = NULL;
    return impl_callIntMethod( "getMaxConnections", mID );
}
// -------------------------------------------------------------------------
sal_Int32 SAL_CALL java_sql_DatabaseMetaData::getMaxColumnsInTable(  ) throw(SQLException, RuntimeException)
{
	static jmethodID mID = NULL;
    return impl_callIntMethod( "getMaxColumnsInTable", mID );
}
// -------------------------------------------------------------------------
sal_Int32 SAL_CALL java_sql_DatabaseMetaData::getMaxStatementLength(  ) throw(SQLException, RuntimeException)
{
	static jmethodID mID = NULL;
    return impl_callIntMethod( "getMaxStatementLength", mID );
}
// -------------------------------------------------------------------------
sal_Int32 SAL_CALL java_sql_DatabaseMetaData::getMaxTableNameLength(  ) throw(SQLException, RuntimeException)
{
	static jmethodID mID = NULL;
    return impl_callIntMethod( "getMaxTableNameLength", mID );
}
// -------------------------------------------------------------------------
sal_Int32 java_sql_DatabaseMetaData::impl_getMaxTablesInSelect_throw(  ) 
{
	static jmethodID mID = NULL;
    return impl_callIntMethod( "getMaxTablesInSelect", mID );
}
// -------------------------------------------------------------------------
Reference< XResultSet > SAL_CALL java_sql_DatabaseMetaData::getExportedKeys(
        const Any& catalog, const ::rtl::OUString& schema, const ::rtl::OUString& table ) throw(SQLException, RuntimeException)
{
	static jmethodID mID = NULL;
    return impl_callResultSetMethodWithStrings( "getExportedKeys", mID, catalog, schema, table );
}
// -------------------------------------------------------------------------
Reference< XResultSet > SAL_CALL java_sql_DatabaseMetaData::getImportedKeys(
        const Any& catalog, const ::rtl::OUString& schema, const ::rtl::OUString& table ) throw(SQLException, RuntimeException)
{
	static jmethodID mID = NULL;
    return impl_callResultSetMethodWithStrings( "getImportedKeys", mID, catalog, schema, table );
}
// -------------------------------------------------------------------------
Reference< XResultSet > SAL_CALL java_sql_DatabaseMetaData::getPrimaryKeys(
        const Any& catalog, const ::rtl::OUString& schema, const ::rtl::OUString& table ) throw(SQLException, RuntimeException)
{
	static jmethodID mID = NULL;
    return impl_callResultSetMethodWithStrings( "getPrimaryKeys", mID, catalog, schema, table );
}
// -------------------------------------------------------------------------
Reference< XResultSet > SAL_CALL java_sql_DatabaseMetaData::getIndexInfo(
        const Any& catalog, const ::rtl::OUString& schema, const ::rtl::OUString& table,
        sal_Bool unique, sal_Bool approximate ) throw(SQLException, RuntimeException)
{
	static const char * cSignature = "(Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;ZZ)Ljava/sql/ResultSet;";
	static const char * cMethodName = "getIndexInfo";

    m_aLogger.log( LogLevel::FINEST, STR_LOG_META_DATA_METHOD, cMethodName );

    jobject out(0);
    SDBThreadAttach t; OSL_ENSURE(t.pEnv,"Java Enviroment geloescht worden!");
	if( t.pEnv )
    {
		// Java-Call absetzen
		static jmethodID mID = NULL;
		if ( !mID  )
			mID  = t.pEnv->GetMethodID( getMyClass(), cMethodName, cSignature );OSL_ENSURE(mID,"Unknown method id!");
		if( mID ){
			jvalue args[5];
			// Parameter konvertieren
			args[0].l = catalog.hasValue() ? convertwchar_tToJavaString(t.pEnv,comphelper::getString(catalog)) : 0;
			args[1].l = schema.toChar() == '%' ? NULL : convertwchar_tToJavaString(t.pEnv,schema);
			args[2].l = convertwchar_tToJavaString(t.pEnv,table);
			args[3].z = unique;
			args[4].z = approximate;
			out = t.pEnv->CallObjectMethod( object, mID, args[0].l,args[1].l,args[2].l,args[3].z,args[4].z );

			// und aufraeumen
			if(catalog.hasValue())
				t.pEnv->DeleteLocalRef((jstring)args[0].l);
			if(args[1].l)
				t.pEnv->DeleteLocalRef((jstring)args[1].l);
			if(table.getLength())
				t.pEnv->DeleteLocalRef((jstring)args[2].l);
			ThrowLoggedSQLException( m_aLogger, t.pEnv, *this );
		}
	}
    if ( !out )
        return NULL;

    m_aLogger.log( LogLevel::FINEST, STR_LOG_META_DATA_SUCCESS, cMethodName );
	return new java_sql_ResultSet( t.pEnv, out, m_aLogger,*m_pConnection);
}
// -------------------------------------------------------------------------
Reference< XResultSet > SAL_CALL java_sql_DatabaseMetaData::getBestRowIdentifier(
        const Any& catalog, const ::rtl::OUString& schema, const ::rtl::OUString& table, sal_Int32 scope,
        sal_Bool nullable ) throw(SQLException, RuntimeException)
{
	static const char * cSignature = "(Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;)Ljava/sql/ResultSet;";
	static const char * cMethodName = "getBestRowIdentifier";

    m_aLogger.log( LogLevel::FINEST, STR_LOG_META_DATA_METHOD, cMethodName );

    jobject out(0);
    SDBThreadAttach t; OSL_ENSURE(t.pEnv,"Java Enviroment geloescht worden!");
	if( t.pEnv )
    {
		// Java-Call absetzen
		static jmethodID mID = NULL;
		if ( !mID  )
			mID  = t.pEnv->GetMethodID( getMyClass(), cMethodName, cSignature );OSL_ENSURE(mID,"Unknown method id!");
		if( mID ){
			jvalue args[3];
			// Parameter konvertieren
			args[0].l = catalog.hasValue() ? convertwchar_tToJavaString(t.pEnv,comphelper::getString(catalog)) : 0;
			args[1].l = schema.toChar() == '%' ? NULL : convertwchar_tToJavaString(t.pEnv,schema);
			args[2].l = convertwchar_tToJavaString(t.pEnv,table);
			out = t.pEnv->CallObjectMethod( object, mID, args[0].l,args[1].l,args[2].l,scope,nullable);

			// und aufraeumen
			if(catalog.hasValue())
				t.pEnv->DeleteLocalRef((jstring)args[0].l);
			if(args[1].l)
				t.pEnv->DeleteLocalRef((jstring)args[1].l);
			if(table.getLength())
				t.pEnv->DeleteLocalRef((jstring)args[2].l);
			ThrowLoggedSQLException( m_aLogger, t.pEnv, *this );
		}
	}

    if ( !out )
        return NULL;

    m_aLogger.log( LogLevel::FINEST, STR_LOG_META_DATA_SUCCESS, cMethodName );
	return new java_sql_ResultSet( t.pEnv, out, m_aLogger,*m_pConnection);
}
// -------------------------------------------------------------------------
Reference< XResultSet > SAL_CALL java_sql_DatabaseMetaData::getTablePrivileges(
        const Any& catalog, const ::rtl::OUString& schemaPattern, const ::rtl::OUString& tableNamePattern ) throw(SQLException, RuntimeException)
{
	if ( m_pConnection->isIgnoreDriverPrivilegesEnabled() )
		return new OResultSetPrivileges(this,catalog,schemaPattern,tableNamePattern);

	static jmethodID mID = NULL;
    Reference< XResultSet > xReturn( impl_callResultSetMethodWithStrings( "getTablePrivileges", mID, catalog, schemaPattern, tableNamePattern ) );

	if ( xReturn.is() )
	{
		// we have to check the result columns for the tables privleges
        // #106324#
		Reference< XResultSetMetaDataSupplier > xMetaSup(xReturn,UNO_QUERY);
		if ( xMetaSup.is() )
		{
			Reference< XResultSetMetaData> xMeta = xMetaSup->getMetaData();
			if ( xMeta.is() && xMeta->getColumnCount() != 7 )
			{
				// here we know that the count of column doesn't match
				::std::map<sal_Int32,sal_Int32> aColumnMatching;
				static const ::rtl::OUString sPrivs[] = {
											::rtl::OUString(RTL_CONSTASCII_USTRINGPARAM("TABLE_CAT")),
											::rtl::OUString(RTL_CONSTASCII_USTRINGPARAM("TABLE_SCHEM")),
											::rtl::OUString(RTL_CONSTASCII_USTRINGPARAM("TABLE_NAME")),
											::rtl::OUString(RTL_CONSTASCII_USTRINGPARAM("GRANTOR")),
											::rtl::OUString(RTL_CONSTASCII_USTRINGPARAM("GRANTEE")),
											::rtl::OUString(RTL_CONSTASCII_USTRINGPARAM("PRIVILEGE")),
											::rtl::OUString(RTL_CONSTASCII_USTRINGPARAM("IS_GRANTABLE"))
										};

				::rtl::OUString sColumnName;
				sal_Int32 nCount = xMeta->getColumnCount();
				for (sal_Int32 i = 1 ; i <= nCount ; ++i)
				{
					sColumnName = xMeta->getColumnName(i);
					for (sal_uInt32 j = 0 ; j < sizeof(sPrivs)/sizeof(sPrivs[0]); ++j)
					{
						if ( sPrivs[j] == sColumnName )
						{
							aColumnMatching.insert( ::std::map<sal_Int32,sal_Int32>::value_type(i,j+1) );
							break;
						}
					}

				}
				// fill our own resultset
                ODatabaseMetaDataResultSet* pNewPrivRes = new ODatabaseMetaDataResultSet( ODatabaseMetaDataResultSet::eTablePrivileges );
				Reference< XResultSet > xTemp = xReturn;
				xReturn = pNewPrivRes;
				ODatabaseMetaDataResultSet::ORows aRows;
				Reference< XRow > xRow(xTemp,UNO_QUERY);
				::rtl::OUString sValue;

				ODatabaseMetaDataResultSet::ORow aRow(8);
				while ( xRow.is() && xTemp->next() )
				{
					::std::map<sal_Int32,sal_Int32>::iterator aIter = aColumnMatching.begin();
					::std::map<sal_Int32,sal_Int32>::iterator aEnd  = aColumnMatching.end();
					for (;aIter != aEnd ; ++aIter)
					{
						sValue = xRow->getString(aIter->first);
						if ( xRow->wasNull() )
							aRow[aIter->second] = ODatabaseMetaDataResultSet::getEmptyValue();
						else
							aRow[aIter->second] = new ORowSetValueDecorator(sValue);
					}

					aRows.push_back(aRow);
				}
				pNewPrivRes->setRows(aRows);
			}
		}
	}
	return xReturn;
}
// -------------------------------------------------------------------------
Reference< XResultSet > SAL_CALL java_sql_DatabaseMetaData::getCrossReference(
        const Any& primaryCatalog, const ::rtl::OUString& primarySchema,
        const ::rtl::OUString& primaryTable, const Any& foreignCatalog,
        const ::rtl::OUString& foreignSchema, const ::rtl::OUString& foreignTable ) throw(SQLException, RuntimeException)
{
	static const char * cSignature = "(Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;)Ljava/sql/ResultSet;";
	static const char * cMethodName = "getCrossReference";
    m_aLogger.log( LogLevel::FINEST, STR_LOG_META_DATA_METHOD, cMethodName );

    jobject out(0);
    SDBThreadAttach t; OSL_ENSURE(t.pEnv,"Java Enviroment geloescht worden!");
	if( t.pEnv ){

		// Java-Call absetzen
		static jmethodID mID = NULL;
		if ( !mID  )
			mID  = t.pEnv->GetMethodID( getMyClass(), cMethodName, cSignature );OSL_ENSURE(mID,"Unknown method id!");
		if( mID ){
			jvalue args[6];
			// Parameter konvertieren
			args[0].l = primaryCatalog.hasValue() ? convertwchar_tToJavaString(t.pEnv,comphelper::getString(primaryCatalog)) : 0;
			args[1].l = primarySchema.toChar() == '%' ? NULL : convertwchar_tToJavaString(t.pEnv,primarySchema);
			args[2].l = convertwchar_tToJavaString(t.pEnv,primaryTable);
			args[3].l = foreignCatalog.hasValue() ? convertwchar_tToJavaString(t.pEnv,comphelper::getString(foreignCatalog)) : 0;
			args[4].l = foreignSchema.toChar() == '%' ? NULL : convertwchar_tToJavaString(t.pEnv,foreignSchema);
			args[5].l = convertwchar_tToJavaString(t.pEnv,foreignTable);
			out = t.pEnv->CallObjectMethod( object, mID, args[0].l,args[2].l,args[2].l,args[3].l,args[4].l,args[5].l );

			// und aufraeumen
			if(primaryCatalog.hasValue())
				t.pEnv->DeleteLocalRef((jstring)args[0].l);
			if(args[1].l)
				t.pEnv->DeleteLocalRef((jstring)args[1].l);
			if(primaryTable.getLength())
				t.pEnv->DeleteLocalRef((jstring)args[2].l);
			if(foreignCatalog.hasValue())
				t.pEnv->DeleteLocalRef((jstring)args[3].l);
			if(args[4].l)
				t.pEnv->DeleteLocalRef((jstring)args[4].l);
			if(foreignTable.getLength())
				t.pEnv->DeleteLocalRef((jstring)args[5].l);
			ThrowLoggedSQLException( m_aLogger, t.pEnv, *this );
		}
	}

    if ( !out )
        return NULL;

    m_aLogger.log( LogLevel::FINEST, STR_LOG_META_DATA_SUCCESS, cMethodName );
	return new java_sql_ResultSet( t.pEnv, out, m_aLogger,*m_pConnection);
}

// -------------------------------------------------------------------------
sal_Bool java_sql_DatabaseMetaData::impl_callBooleanMethod( const char* _pMethodName, jmethodID& _inout_MethodID )
{
    m_aLogger.log( LogLevel::FINEST, STR_LOG_META_DATA_METHOD, _pMethodName );

	jboolean out( sal_False );

    SDBThreadAttach t;
    OSL_ENSURE( t.pEnv, "java_sql_DatabaseMetaData::impl_callBooleanMethod: no Java enviroment anymore!" );
	if ( t.pEnv )
    {
        // obtain method ID
		if  ( !_inout_MethodID )
            _inout_MethodID  = t.pEnv->GetMethodID( getMyClass(), _pMethodName, "()Z" );
        OSL_ENSURE( _inout_MethodID, "java_sql_DatabaseMetaData::impl_callBooleanMethod:: unknown method id!" );

        // call method
        if ( _inout_MethodID )
        {
			out = t.pEnv->CallBooleanMethod( object, _inout_MethodID );
			ThrowLoggedSQLException( m_aLogger, t.pEnv, *this );
		}
	}

    m_aLogger.log< const sal_Char*, sal_Int16>( LogLevel::FINEST, STR_LOG_META_DATA_RESULT, _pMethodName, out );
	return out;
}

// -------------------------------------------------------------------------
::rtl::OUString java_sql_DatabaseMetaData::impl_callStringMethod( const char* _pMethodName, jmethodID& _inout_MethodID )
{
    m_aLogger.log( LogLevel::FINEST, STR_LOG_META_DATA_METHOD, _pMethodName );

	::rtl::OUString sReturn;

    SDBThreadAttach t;
    OSL_ENSURE( t.pEnv, "java_sql_DatabaseMetaData::impl_callStringMethod: no Java enviroment anymore!" );
	if( t.pEnv )
    {
        // obtain method ID
		if ( !_inout_MethodID  )
			_inout_MethodID  = t.pEnv->GetMethodID( getMyClass(), _pMethodName, "()Ljava/lang/String;" );
        OSL_ENSURE( _inout_MethodID, "java_sql_DatabaseMetaData::impl_callStringMethod: unknown method id!" );

        // call method
        if ( _inout_MethodID )
        {
			jstring out = (jstring)t.pEnv->CallObjectMethod( object, _inout_MethodID );
			ThrowLoggedSQLException( m_aLogger, t.pEnv, *this );
			sReturn = JavaString2String( t.pEnv, out );
		}
	}

    if ( m_aLogger.isLoggable( LogLevel::FINEST ) )
    {
        ::rtl::OUString sLoggedResult( sReturn );
        if ( !sLoggedResult.getLength() )
            sLoggedResult = ::rtl::OUString( RTL_CONSTASCII_USTRINGPARAM( "<empty string>" ) );
        m_aLogger.log( LogLevel::FINEST, STR_LOG_META_DATA_RESULT, _pMethodName, sLoggedResult );
    }

    return sReturn;
}

// -------------------------------------------------------------------------
sal_Int32 java_sql_DatabaseMetaData::impl_callIntMethod( const char* _pMethodName, jmethodID& _inout_MethodID )
{
    m_aLogger.log( LogLevel::FINEST, STR_LOG_META_DATA_METHOD, _pMethodName );

    jint out( 0 );

    SDBThreadAttach t;
    OSL_ENSURE( t.pEnv, "java_sql_DatabaseMetaData::impl_callIntMethod: no Java enviroment anymore!" );
	if( t.pEnv )
    {
        // obtain method ID
		if ( !_inout_MethodID  )
			_inout_MethodID  = t.pEnv->GetMethodID( getMyClass(), _pMethodName, "()I" );
        OSL_ENSURE( _inout_MethodID, "java_sql_DatabaseMetaData::impl_callIntMethod: unknown method id!" );

        // call method
        if ( _inout_MethodID )
        {
			out = t.pEnv->CallIntMethod( object, _inout_MethodID );
			ThrowLoggedSQLException( m_aLogger, t.pEnv, *this );
		}
	}

    m_aLogger.log( LogLevel::FINEST, STR_LOG_META_DATA_RESULT, _pMethodName, (sal_Int32)out );
	return (sal_Int32)out;
}

// -------------------------------------------------------------------------
sal_Bool java_sql_DatabaseMetaData::impl_callBooleanMethodWithIntArg( const char* _pMethodName, jmethodID& _inout_MethodID, sal_Int32 _nArgument )
{
    m_aLogger.log( LogLevel::FINEST, STR_LOG_META_DATA_METHOD_ARG1, _pMethodName, _nArgument );

	jboolean out( sal_False );
    SDBThreadAttach t;
    OSL_ENSURE( t.pEnv, "java_sql_DatabaseMetaData::impl_callBooleanMethodWithIntArg: no Java enviroment anymore!" );
	if ( t.pEnv )
    {
        // obtain method ID
		if ( !_inout_MethodID  )
			_inout_MethodID  = t.pEnv->GetMethodID( getMyClass(), _pMethodName, "(I)Z" );
        OSL_ENSURE( _inout_MethodID, "java_sql_DatabaseMetaData::impl_callBooleanMethodWithIntArg: unknown method id!" );

        // call method
        if ( _inout_MethodID )
        {
			out = t.pEnv->CallBooleanMethod( object, _inout_MethodID, _nArgument );
			ThrowLoggedSQLException( m_aLogger, t.pEnv, *this );
		}
	}

    m_aLogger.log< const sal_Char*, sal_Int16 >( LogLevel::FINEST, STR_LOG_META_DATA_RESULT, _pMethodName, out );
	return out;
}

// -------------------------------------------------------------------------
Reference< XResultSet > java_sql_DatabaseMetaData::impl_callResultSetMethod( const char* _pMethodName, jmethodID& _inout_MethodID )
{
    m_aLogger.log( LogLevel::FINEST, STR_LOG_META_DATA_METHOD, _pMethodName );

    jobject out(0);

    SDBThreadAttach t;
    OSL_ENSURE( t.pEnv, "java_sql_DatabaseMetaData::impl_callResultSetMethod: no Java enviroment anymore!" );
	if ( t.pEnv )
    {
        // obtain method ID
		if ( !_inout_MethodID  )
			_inout_MethodID  = t.pEnv->GetMethodID( getMyClass(), _pMethodName, "()Ljava/sql/ResultSet;" );
        OSL_ENSURE( _inout_MethodID, "java_sql_DatabaseMetaData::impl_callResultSetMethod: unknown method id!" );

        // call method
        if ( _inout_MethodID )
        {
			out = t.pEnv->CallObjectMethod( object, _inout_MethodID );
			ThrowLoggedSQLException( m_aLogger, t.pEnv, *this );
        }
	}

    if ( !out )
        return NULL;

    m_aLogger.log( LogLevel::FINEST, STR_LOG_META_DATA_SUCCESS, _pMethodName );
    return new java_sql_ResultSet( t.pEnv, out, m_aLogger,*m_pConnection);
}

// -------------------------------------------------------------------------
Reference< XResultSet > java_sql_DatabaseMetaData::impl_callResultSetMethodWithStrings( const char* _pMethodName, jmethodID& _inout_MethodID,
    const Any& _rCatalog, const ::rtl::OUString& _rSchemaPattern, const ::rtl::OUString& _rLeastPattern,
    const ::rtl::OUString* _pOptionalAdditionalString )
{
    bool bCatalog = _rCatalog.hasValue();
    ::rtl::OUString sCatalog( ::comphelper::getString( _rCatalog ) );

    bool bSchema = _rSchemaPattern.toChar() != '%';

    // log the call
    if ( m_aLogger.isLoggable( LogLevel::FINEST ) )
    {
        ::rtl::OUString sCatalogLog = bCatalog ? sCatalog : ::rtl::OUString( RTL_CONSTASCII_USTRINGPARAM( "null" ) );
        ::rtl::OUString sSchemaLog = bSchema ? _rSchemaPattern : ::rtl::OUString( RTL_CONSTASCII_USTRINGPARAM( "null" ) );
        if ( _pOptionalAdditionalString )
            m_aLogger.log( LogLevel::FINEST, STR_LOG_META_DATA_METHOD_ARG4, _pMethodName, sCatalogLog, sSchemaLog, _rLeastPattern, *_pOptionalAdditionalString );
        else
            m_aLogger.log( LogLevel::FINEST, STR_LOG_META_DATA_METHOD_ARG3, _pMethodName, sCatalogLog, sSchemaLog, _rLeastPattern );
    }

    jobject out(0);

    SDBThreadAttach t;
    OSL_ENSURE( t.pEnv, "java_sql_DatabaseMetaData::impl_callResultSetMethodWithStrings: no Java enviroment anymore!" );
	if ( t.pEnv )
    {
        const  char* pSignature = _pOptionalAdditionalString
            ?   "(Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;)Ljava/sql/ResultSet;"
            :   "(Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;)Ljava/sql/ResultSet;";
        // obtain method ID
		if ( !_inout_MethodID  )
			_inout_MethodID  = t.pEnv->GetMethodID( getMyClass(), _pMethodName, pSignature );
        OSL_ENSURE( _inout_MethodID, "java_sql_DatabaseMetaData::impl_callResultSetMethodWithStrings: unknown method id!" );

        // call method
        if ( _inout_MethodID )
        {
            jvalue args[4];
            // convert parameters
            args[0].l = bCatalog ? convertwchar_tToJavaString( t.pEnv, sCatalog ) : NULL;
            args[1].l = bSchema ? convertwchar_tToJavaString( t.pEnv, _rSchemaPattern ) : NULL;
			args[2].l = convertwchar_tToJavaString( t.pEnv, _rLeastPattern );
            args[3].l = _pOptionalAdditionalString ? convertwchar_tToJavaString( t.pEnv, *_pOptionalAdditionalString ) : NULL;

            // actually do the call
            if ( _pOptionalAdditionalString )
			    out = t.pEnv->CallObjectMethod( object, _inout_MethodID, args[0].l, args[1].l, args[2].l, args[3].l );
            else
			    out = t.pEnv->CallObjectMethod( object, _inout_MethodID, args[0].l, args[1].l, args[2].l );

			// clean up
			if ( args[0].l )
				t.pEnv->DeleteLocalRef( (jstring)args[0].l );
			if ( args[1].l )
				t.pEnv->DeleteLocalRef( (jstring)args[1].l );
			if ( args[2].l )
				t.pEnv->DeleteLocalRef( (jstring)args[2].l );
            if ( args[3].l )
				t.pEnv->DeleteLocalRef( (jstring)args[3].l );

			ThrowLoggedSQLException( m_aLogger, t.pEnv, *this );
		}
    }

    if ( !out )
        return NULL;

    m_aLogger.log( LogLevel::FINEST, STR_LOG_META_DATA_SUCCESS, _pMethodName );
    return new java_sql_ResultSet( t.pEnv, out, m_aLogger,*m_pConnection);
}

// -------------------------------------------------------------------------
sal_Bool SAL_CALL java_sql_DatabaseMetaData::doesMaxRowSizeIncludeBlobs(  ) throw(SQLException, RuntimeException)
{
	static jmethodID mID = NULL;
    return impl_callBooleanMethod( "doesMaxRowSizeIncludeBlobs", mID );
}
// -------------------------------------------------------------------------
sal_Bool SAL_CALL java_sql_DatabaseMetaData::storesLowerCaseQuotedIdentifiers(  ) throw(SQLException, RuntimeException)
{
	static jmethodID mID = NULL;
    return impl_callBooleanMethod( "storesLowerCaseQuotedIdentifiers", mID );
}
// -------------------------------------------------------------------------
sal_Bool SAL_CALL java_sql_DatabaseMetaData::storesLowerCaseIdentifiers(  ) throw(SQLException, RuntimeException)
{
	static jmethodID mID = NULL;
    return impl_callBooleanMethod( "storesLowerCaseIdentifiers", mID );
}
// -------------------------------------------------------------------------
sal_Bool java_sql_DatabaseMetaData::impl_storesMixedCaseQuotedIdentifiers_throw(  ) 
{
	static jmethodID mID = NULL;
    return impl_callBooleanMethod( "storesMixedCaseQuotedIdentifiers", mID );
}
// -------------------------------------------------------------------------
sal_Bool SAL_CALL java_sql_DatabaseMetaData::storesMixedCaseIdentifiers(  ) throw(SQLException, RuntimeException)
{
	static jmethodID mID = NULL;
    return impl_callBooleanMethod( "storesMixedCaseIdentifiers", mID );
}
// -------------------------------------------------------------------------
sal_Bool SAL_CALL java_sql_DatabaseMetaData::storesUpperCaseQuotedIdentifiers(  ) throw(SQLException, RuntimeException)
{
	static jmethodID mID = NULL;
    return impl_callBooleanMethod( "storesUpperCaseQuotedIdentifiers", mID );
}
// -------------------------------------------------------------------------
sal_Bool SAL_CALL java_sql_DatabaseMetaData::storesUpperCaseIdentifiers(  ) throw(SQLException, RuntimeException)
{
	static jmethodID mID = NULL;
    return impl_callBooleanMethod( "storesUpperCaseIdentifiers", mID );
}
// -------------------------------------------------------------------------
sal_Bool java_sql_DatabaseMetaData::impl_supportsAlterTableWithAddColumn_throw(  )
{
	static jmethodID mID = NULL;
    return impl_callBooleanMethod( "supportsAlterTableWithAddColumn", mID );
}
// -------------------------------------------------------------------------
sal_Bool java_sql_DatabaseMetaData::impl_supportsAlterTableWithDropColumn_throw(  )
{
	static jmethodID mID = NULL;
    return impl_callBooleanMethod( "supportsAlterTableWithDropColumn", mID );
}
// -------------------------------------------------------------------------
sal_Int32 SAL_CALL java_sql_DatabaseMetaData::getMaxIndexLength(  ) throw(SQLException, RuntimeException)
{
	static jmethodID mID = NULL;
    return impl_callIntMethod( "getMaxIndexLength", mID );
}
// -------------------------------------------------------------------------
sal_Bool SAL_CALL java_sql_DatabaseMetaData::supportsNonNullableColumns(  ) throw(SQLException, RuntimeException)
{
	static jmethodID mID = NULL;
    return impl_callBooleanMethod( "supportsNonNullableColumns", mID );
}
// -------------------------------------------------------------------------
::rtl::OUString SAL_CALL java_sql_DatabaseMetaData::getCatalogTerm(  ) throw(SQLException, RuntimeException)
{
	static jmethodID mID = NULL;
    return impl_callStringMethod( "getCatalogTerm", mID );
}
// -------------------------------------------------------------------------
::rtl::OUString java_sql_DatabaseMetaData::impl_getIdentifierQuoteString_throw(  )
{
	static jmethodID mID = NULL;
    return impl_callStringMethod( "getIdentifierQuoteString", mID );
}
// -------------------------------------------------------------------------
::rtl::OUString SAL_CALL java_sql_DatabaseMetaData::getExtraNameCharacters(  ) throw(SQLException, RuntimeException)
{
	static jmethodID mID = NULL;
    return impl_callStringMethod( "getExtraNameCharacters", mID );
}
// -------------------------------------------------------------------------
sal_Bool SAL_CALL java_sql_DatabaseMetaData::supportsDifferentTableCorrelationNames(  ) throw(SQLException, RuntimeException)
{
	static jmethodID mID = NULL;
    return impl_callBooleanMethod( "supportsDifferentTableCorrelationNames", mID );
}
// -------------------------------------------------------------------------
sal_Bool java_sql_DatabaseMetaData::impl_isCatalogAtStart_throw(  )
{
	static jmethodID mID = NULL;
    return impl_callBooleanMethod( "isCatalogAtStart", mID );
}
// -------------------------------------------------------------------------
sal_Bool SAL_CALL java_sql_DatabaseMetaData::dataDefinitionIgnoredInTransactions(  ) throw(SQLException, RuntimeException)
{
	static jmethodID mID = NULL;
    return impl_callBooleanMethod( "dataDefinitionIgnoredInTransactions", mID );
}
// -------------------------------------------------------------------------
sal_Bool SAL_CALL java_sql_DatabaseMetaData::dataDefinitionCausesTransactionCommit(  ) throw(SQLException, RuntimeException)
{
	static jmethodID mID = NULL;
    return impl_callBooleanMethod( "dataDefinitionCausesTransactionCommit", mID );
}
// -------------------------------------------------------------------------
sal_Bool SAL_CALL java_sql_DatabaseMetaData::supportsDataManipulationTransactionsOnly(  ) throw(SQLException, RuntimeException)
{
	static jmethodID mID = NULL;
    return impl_callBooleanMethod( "supportsDataManipulationTransactionsOnly", mID );
}
// -------------------------------------------------------------------------
sal_Bool SAL_CALL java_sql_DatabaseMetaData::supportsDataDefinitionAndDataManipulationTransactions(  ) throw(SQLException, RuntimeException)
{
	static jmethodID mID = NULL;
    return impl_callBooleanMethod( "supportsDataDefinitionAndDataManipulationTransactions", mID );
}
// -------------------------------------------------------------------------
sal_Bool SAL_CALL java_sql_DatabaseMetaData::supportsPositionedDelete(  ) throw(SQLException, RuntimeException)
{
	static jmethodID mID = NULL;
    return impl_callBooleanMethod( "supportsPositionedDelete", mID );
}
// -------------------------------------------------------------------------
sal_Bool SAL_CALL java_sql_DatabaseMetaData::supportsPositionedUpdate(  ) throw(SQLException, RuntimeException)
{
	static jmethodID mID = NULL;
    return impl_callBooleanMethod( "supportsPositionedUpdate", mID );
}
// -------------------------------------------------------------------------
sal_Bool SAL_CALL java_sql_DatabaseMetaData::supportsOpenStatementsAcrossRollback(  ) throw(SQLException, RuntimeException)
{
	static jmethodID mID = NULL;
    return impl_callBooleanMethod( "supportsOpenStatementsAcrossRollback", mID );
}
// -------------------------------------------------------------------------
sal_Bool SAL_CALL java_sql_DatabaseMetaData::supportsOpenStatementsAcrossCommit(  ) throw(SQLException, RuntimeException)
{
	static jmethodID mID = NULL;
    return impl_callBooleanMethod( "supportsOpenStatementsAcrossCommit", mID );
}
// -------------------------------------------------------------------------
sal_Bool SAL_CALL java_sql_DatabaseMetaData::supportsOpenCursorsAcrossCommit(  ) throw(SQLException, RuntimeException)
{
	static jmethodID mID = NULL;
    return impl_callBooleanMethod( "supportsOpenCursorsAcrossCommit", mID );
}
// -------------------------------------------------------------------------
sal_Bool SAL_CALL java_sql_DatabaseMetaData::supportsOpenCursorsAcrossRollback(  ) throw(SQLException, RuntimeException)
{
	static jmethodID mID = NULL;
    return impl_callBooleanMethod( "supportsOpenCursorsAcrossRollback", mID );
}
// -------------------------------------------------------------------------
sal_Bool SAL_CALL java_sql_DatabaseMetaData::supportsTransactionIsolationLevel( sal_Int32 level ) throw(SQLException, RuntimeException)
{
	static jmethodID mID = NULL;
    return impl_callBooleanMethodWithIntArg( "supportsTransactionIsolationLevel", mID, level );
}
// -------------------------------------------------------------------------
sal_Bool java_sql_DatabaseMetaData::impl_supportsSchemasInDataManipulation_throw(  )
{
	static jmethodID mID = NULL;
    return impl_callBooleanMethod( "supportsSchemasInDataManipulation", mID );
}
// -------------------------------------------------------------------------
sal_Bool SAL_CALL java_sql_DatabaseMetaData::supportsANSI92FullSQL(  ) throw(SQLException, RuntimeException)
{
	static jmethodID mID = NULL;
    return impl_callBooleanMethod( "supportsANSI92FullSQL", mID );
}
// -------------------------------------------------------------------------
sal_Bool SAL_CALL java_sql_DatabaseMetaData::supportsANSI92EntryLevelSQL(  ) throw(SQLException, RuntimeException)
{
	static jmethodID mID = NULL;
    return impl_callBooleanMethod( "supportsANSI92EntryLevelSQL", mID );
}
// -------------------------------------------------------------------------
sal_Bool SAL_CALL java_sql_DatabaseMetaData::supportsIntegrityEnhancementFacility(  ) throw(SQLException, RuntimeException)
{
	static jmethodID mID = NULL;
    return impl_callBooleanMethod( "supportsIntegrityEnhancementFacility", mID );
}
// -------------------------------------------------------------------------
sal_Bool SAL_CALL java_sql_DatabaseMetaData::supportsSchemasInIndexDefinitions(  ) throw(SQLException, RuntimeException)
{
	static jmethodID mID = NULL;
    return impl_callBooleanMethod( "supportsSchemasInIndexDefinitions", mID );
}
// -------------------------------------------------------------------------
sal_Bool java_sql_DatabaseMetaData::impl_supportsSchemasInTableDefinitions_throw(  ) 
{
	static jmethodID mID = NULL;
    return impl_callBooleanMethod( "supportsSchemasInTableDefinitions", mID );
}
// -------------------------------------------------------------------------
sal_Bool java_sql_DatabaseMetaData::impl_supportsCatalogsInTableDefinitions_throw(  )
{
	static jmethodID mID = NULL;
    return impl_callBooleanMethod( "supportsCatalogsInTableDefinitions", mID );
}
// -------------------------------------------------------------------------
sal_Bool SAL_CALL java_sql_DatabaseMetaData::supportsCatalogsInIndexDefinitions(  ) throw(SQLException, RuntimeException)
{
	static jmethodID mID = NULL;
    return impl_callBooleanMethod( "supportsCatalogsInIndexDefinitions", mID );
}
// -------------------------------------------------------------------------
sal_Bool java_sql_DatabaseMetaData::impl_supportsCatalogsInDataManipulation_throw(  ) 
{
	static jmethodID mID = NULL;
    return impl_callBooleanMethod( "supportsCatalogsInDataManipulation", mID );
}
// -------------------------------------------------------------------------
sal_Bool SAL_CALL java_sql_DatabaseMetaData::supportsOuterJoins(  ) throw(SQLException, RuntimeException)
{
	static jmethodID mID = NULL;
    return impl_callBooleanMethod( "supportsOuterJoins", mID );
}
// -------------------------------------------------------------------------
Reference< XResultSet > SAL_CALL java_sql_DatabaseMetaData::getTableTypes(  ) throw(SQLException, RuntimeException)
{
	static jmethodID mID = NULL;
    return impl_callResultSetMethod( "getTableTypes", mID );
}
// -------------------------------------------------------------------------
sal_Int32 java_sql_DatabaseMetaData::impl_getMaxStatements_throw(  ) 
{
	static jmethodID mID = NULL;
    return impl_callIntMethod( "getMaxStatements", mID );
}
// -------------------------------------------------------------------------
sal_Int32 SAL_CALL java_sql_DatabaseMetaData::getMaxProcedureNameLength(  ) throw(SQLException, RuntimeException)
{
	static jmethodID mID = NULL;
    return impl_callIntMethod( "getMaxProcedureNameLength", mID );
}
// -------------------------------------------------------------------------
sal_Int32 SAL_CALL java_sql_DatabaseMetaData::getMaxSchemaNameLength(  ) throw(SQLException, RuntimeException)
{
	static jmethodID mID = NULL;
    return impl_callIntMethod( "getMaxSchemaNameLength", mID );
}
// -------------------------------------------------------------------------
sal_Bool SAL_CALL java_sql_DatabaseMetaData::supportsTransactions(  ) throw(SQLException, RuntimeException)
{
	static jmethodID mID = NULL;
    return impl_callBooleanMethod( "supportsTransactions", mID );
}

// -------------------------------------------------------------------------
sal_Bool SAL_CALL java_sql_DatabaseMetaData::allProceduresAreCallable(  ) throw(SQLException, RuntimeException)
{
	static jmethodID mID = NULL;
    return impl_callBooleanMethod( "allProceduresAreCallable", mID );
}
// -------------------------------------------------------------------------
sal_Bool SAL_CALL java_sql_DatabaseMetaData::supportsStoredProcedures(  ) throw(SQLException, RuntimeException)
{
	static jmethodID mID = NULL;
    return impl_callBooleanMethod( "supportsStoredProcedures", mID );
}
// -------------------------------------------------------------------------
sal_Bool SAL_CALL java_sql_DatabaseMetaData::supportsSelectForUpdate(  ) throw(SQLException, RuntimeException)
{
	static jmethodID mID = NULL;
    return impl_callBooleanMethod( "supportsSelectForUpdate", mID );
}
// -------------------------------------------------------------------------
sal_Bool SAL_CALL java_sql_DatabaseMetaData::allTablesAreSelectable(  ) throw(SQLException, RuntimeException)
{
	static jmethodID mID = NULL;
    return impl_callBooleanMethod( "allTablesAreSelectable", mID );
}
// -------------------------------------------------------------------------
sal_Bool SAL_CALL java_sql_DatabaseMetaData::isReadOnly(  ) throw(SQLException, RuntimeException)
{
	static jmethodID mID = NULL;
    return impl_callBooleanMethod( "isReadOnly", mID );
}
// -------------------------------------------------------------------------
sal_Bool SAL_CALL java_sql_DatabaseMetaData::usesLocalFiles(  ) throw(SQLException, RuntimeException)
{
	static jmethodID mID = NULL;
    return impl_callBooleanMethod( "usesLocalFiles", mID );
}
// -------------------------------------------------------------------------
sal_Bool SAL_CALL java_sql_DatabaseMetaData::usesLocalFilePerTable(  ) throw(SQLException, RuntimeException)
{
	static jmethodID mID = NULL;
    return impl_callBooleanMethod( "usesLocalFilePerTable", mID );
}
// -------------------------------------------------------------------------
sal_Bool SAL_CALL java_sql_DatabaseMetaData::supportsTypeConversion(  ) throw(SQLException, RuntimeException)
{
	static jmethodID mID = NULL;
    return impl_callBooleanMethod( "supportsTypeConversion", mID );
}
// -------------------------------------------------------------------------
sal_Bool SAL_CALL java_sql_DatabaseMetaData::nullPlusNonNullIsNull(  ) throw(SQLException, RuntimeException)
{
	static jmethodID mID = NULL;
    return impl_callBooleanMethod( "nullPlusNonNullIsNull", mID );
}
// -------------------------------------------------------------------------
sal_Bool SAL_CALL java_sql_DatabaseMetaData::supportsColumnAliasing(  ) throw(SQLException, RuntimeException)
{
	static jmethodID mID = NULL;
    return impl_callBooleanMethod( "supportsColumnAliasing", mID );
}
// -------------------------------------------------------------------------
sal_Bool SAL_CALL java_sql_DatabaseMetaData::supportsTableCorrelationNames(  ) throw(SQLException, RuntimeException)
{
	static jmethodID mID = NULL;
    return impl_callBooleanMethod( "supportsTableCorrelationNames", mID );
}
// -------------------------------------------------------------------------
sal_Bool SAL_CALL java_sql_DatabaseMetaData::supportsConvert( sal_Int32 fromType, sal_Int32 toType ) throw(SQLException, RuntimeException)
{
    static const char* pMethodName = "supportsConvert";
    m_aLogger.log( LogLevel::FINEST, STR_LOG_META_DATA_METHOD_ARG2, pMethodName, fromType, toType );

    jboolean out( sal_False );
	SDBThreadAttach t;
	if ( t.pEnv )
    {
        static jmethodID mID = NULL;
		if ( !mID  )
			mID  = t.pEnv->GetMethodID( getMyClass(), pMethodName, "(II)Z" );
        OSL_ENSURE( mID, "java_sql_DatabaseMetaData::supportsConvert: unknown method id!" );

        if ( mID )
        {
			out = t.pEnv->CallBooleanMethod( object, mID, fromType, toType );
			ThrowLoggedSQLException( m_aLogger, t.pEnv, *this );
		}
	}

    m_aLogger.log< const sal_Char*, sal_Int16 >( LogLevel::FINEST, STR_LOG_META_DATA_RESULT, pMethodName, out );
    return out;
}
// -------------------------------------------------------------------------
sal_Bool SAL_CALL java_sql_DatabaseMetaData::supportsExpressionsInOrderBy(  ) throw(SQLException, RuntimeException)
{
	static jmethodID mID = NULL;
    return impl_callBooleanMethod( "supportsExpressionsInOrderBy", mID );
}
// -------------------------------------------------------------------------
sal_Bool SAL_CALL java_sql_DatabaseMetaData::supportsGroupBy(  ) throw(SQLException, RuntimeException)
{
	static jmethodID mID = NULL;
    return impl_callBooleanMethod( "supportsGroupBy", mID );
}
// -------------------------------------------------------------------------
sal_Bool SAL_CALL java_sql_DatabaseMetaData::supportsGroupByBeyondSelect(  ) throw(SQLException, RuntimeException)
{
	static jmethodID mID = NULL;
    return impl_callBooleanMethod( "supportsGroupByBeyondSelect", mID );
}
// -------------------------------------------------------------------------
sal_Bool SAL_CALL java_sql_DatabaseMetaData::supportsGroupByUnrelated(  ) throw(SQLException, RuntimeException)
{
	static jmethodID mID = NULL;
    return impl_callBooleanMethod( "supportsGroupByUnrelated", mID );
}
// -------------------------------------------------------------------------
sal_Bool SAL_CALL java_sql_DatabaseMetaData::supportsMultipleTransactions(  ) throw(SQLException, RuntimeException)
{
	static jmethodID mID = NULL;
    return impl_callBooleanMethod( "supportsMultipleTransactions", mID );
}
// -------------------------------------------------------------------------
sal_Bool SAL_CALL java_sql_DatabaseMetaData::supportsMultipleResultSets(  ) throw(SQLException, RuntimeException)
{
	static jmethodID mID = NULL;
    return impl_callBooleanMethod( "supportsMultipleResultSets", mID );
}
// -------------------------------------------------------------------------
sal_Bool SAL_CALL java_sql_DatabaseMetaData::supportsLikeEscapeClause(  ) throw(SQLException, RuntimeException)
{
	static jmethodID mID = NULL;
    return impl_callBooleanMethod( "supportsLikeEscapeClause", mID );
}
// -------------------------------------------------------------------------
sal_Bool SAL_CALL java_sql_DatabaseMetaData::supportsOrderByUnrelated(  ) throw(SQLException, RuntimeException)
{
	static jmethodID mID = NULL;
    return impl_callBooleanMethod( "supportsOrderByUnrelated", mID );
}
// -------------------------------------------------------------------------
sal_Bool SAL_CALL java_sql_DatabaseMetaData::supportsUnion(  ) throw(SQLException, RuntimeException)
{
	static jmethodID mID = NULL;
    return impl_callBooleanMethod( "supportsUnion", mID );
}
// -------------------------------------------------------------------------
sal_Bool SAL_CALL java_sql_DatabaseMetaData::supportsUnionAll(  ) throw(SQLException, RuntimeException)
{
	static jmethodID mID = NULL;
    return impl_callBooleanMethod( "supportsUnionAll", mID );
}
// -------------------------------------------------------------------------
sal_Bool SAL_CALL java_sql_DatabaseMetaData::supportsMixedCaseIdentifiers(  ) throw(SQLException, RuntimeException)
{
	static jmethodID mID = NULL;
    return impl_callBooleanMethod( "supportsMixedCaseIdentifiers", mID );
}
// -------------------------------------------------------------------------
sal_Bool java_sql_DatabaseMetaData::impl_supportsMixedCaseQuotedIdentifiers_throw(  )
{
	static jmethodID mID = NULL;
    return impl_callBooleanMethod( "supportsMixedCaseQuotedIdentifiers", mID );
}
// -------------------------------------------------------------------------
sal_Bool SAL_CALL java_sql_DatabaseMetaData::nullsAreSortedAtEnd(  ) throw(SQLException, RuntimeException)
{
	static jmethodID mID = NULL;
    return impl_callBooleanMethod( "nullsAreSortedAtEnd", mID );
}
// -------------------------------------------------------------------------
sal_Bool SAL_CALL java_sql_DatabaseMetaData::nullsAreSortedAtStart(  ) throw(SQLException, RuntimeException)
{
	static jmethodID mID = NULL;
    return impl_callBooleanMethod( "nullsAreSortedAtStart", mID );
}
// -------------------------------------------------------------------------
sal_Bool SAL_CALL java_sql_DatabaseMetaData::nullsAreSortedHigh(  ) throw(SQLException, RuntimeException)
{
	static jmethodID mID = NULL;
    return impl_callBooleanMethod( "nullsAreSortedHigh", mID );
}
// -------------------------------------------------------------------------
sal_Bool SAL_CALL java_sql_DatabaseMetaData::nullsAreSortedLow(  ) throw(SQLException, RuntimeException)
{
	static jmethodID mID = NULL;
    return impl_callBooleanMethod( "nullsAreSortedLow", mID );
}
// -------------------------------------------------------------------------
sal_Bool SAL_CALL java_sql_DatabaseMetaData::supportsSchemasInProcedureCalls(  ) throw(SQLException, RuntimeException)
{
	static jmethodID mID = NULL;
    return impl_callBooleanMethod( "supportsSchemasInProcedureCalls", mID );
}
// -------------------------------------------------------------------------
sal_Bool SAL_CALL java_sql_DatabaseMetaData::supportsSchemasInPrivilegeDefinitions(  ) throw(SQLException, RuntimeException)
{
	static jmethodID mID = NULL;
    return impl_callBooleanMethod( "supportsSchemasInPrivilegeDefinitions", mID );
}
// -------------------------------------------------------------------------
sal_Bool SAL_CALL java_sql_DatabaseMetaData::supportsCatalogsInProcedureCalls(  ) throw(SQLException, RuntimeException)
{
	static jmethodID mID = NULL;
    return impl_callBooleanMethod( "supportsCatalogsInProcedureCalls", mID );
}
// -------------------------------------------------------------------------
sal_Bool SAL_CALL java_sql_DatabaseMetaData::supportsCatalogsInPrivilegeDefinitions(  ) throw(SQLException, RuntimeException)
{
	static jmethodID mID = NULL;
    return impl_callBooleanMethod( "supportsCatalogsInPrivilegeDefinitions", mID );
}
// -------------------------------------------------------------------------
sal_Bool SAL_CALL java_sql_DatabaseMetaData::supportsCorrelatedSubqueries(  ) throw(SQLException, RuntimeException)
{
	static jmethodID mID = NULL;
    return impl_callBooleanMethod( "supportsCorrelatedSubqueries", mID );
}
// -------------------------------------------------------------------------
sal_Bool SAL_CALL java_sql_DatabaseMetaData::supportsSubqueriesInComparisons(  ) throw(SQLException, RuntimeException)
{
	static jmethodID mID = NULL;
    return impl_callBooleanMethod( "supportsSubqueriesInComparisons", mID );
}
// -------------------------------------------------------------------------
sal_Bool SAL_CALL java_sql_DatabaseMetaData::supportsSubqueriesInExists(  ) throw(SQLException, RuntimeException)
{
	static jmethodID mID = NULL;
    return impl_callBooleanMethod( "supportsSubqueriesInExists", mID );
}
// -------------------------------------------------------------------------
sal_Bool SAL_CALL java_sql_DatabaseMetaData::supportsSubqueriesInIns(  ) throw(SQLException, RuntimeException)
{
	static jmethodID mID = NULL;
    return impl_callBooleanMethod( "supportsSubqueriesInIns", mID );
}
// -------------------------------------------------------------------------
sal_Bool SAL_CALL java_sql_DatabaseMetaData::supportsSubqueriesInQuantifieds(  ) throw(SQLException, RuntimeException)
{
	static jmethodID mID = NULL;
    return impl_callBooleanMethod( "supportsSubqueriesInQuantifieds", mID );
}
// -------------------------------------------------------------------------
sal_Bool SAL_CALL java_sql_DatabaseMetaData::supportsANSI92IntermediateSQL(  ) throw(SQLException, RuntimeException)
{
	static jmethodID mID = NULL;
    return impl_callBooleanMethod( "supportsANSI92IntermediateSQL", mID );
}
// -------------------------------------------------------------------------
::rtl::OUString SAL_CALL java_sql_DatabaseMetaData::getURL(  ) throw(SQLException, RuntimeException)
{
	::rtl::OUString sURL = m_pConnection->getURL();
	if ( !sURL.getLength() )
	{
	    static jmethodID mID = NULL;
        sURL = impl_callStringMethod( "getURL", mID );
	}
	return sURL;
}
// -------------------------------------------------------------------------
::rtl::OUString SAL_CALL java_sql_DatabaseMetaData::getUserName(  ) throw(SQLException, RuntimeException)
{
	static jmethodID mID = NULL;
    return impl_callStringMethod( "getUserName", mID );
}
// -------------------------------------------------------------------------
::rtl::OUString SAL_CALL java_sql_DatabaseMetaData::getDriverName(  ) throw(SQLException, RuntimeException)
{
	static jmethodID mID = NULL;
    return impl_callStringMethod( "getDriverName", mID );
}
// -------------------------------------------------------------------------
::rtl::OUString SAL_CALL java_sql_DatabaseMetaData::getDriverVersion(  ) throw(SQLException, RuntimeException)
{
	static jmethodID mID = NULL;
    return impl_callStringMethod( "getDriverVersion", mID );
}
// -------------------------------------------------------------------------
::rtl::OUString SAL_CALL java_sql_DatabaseMetaData::getDatabaseProductVersion(  ) throw(SQLException, RuntimeException)
{
	static jmethodID mID = NULL;
    return impl_callStringMethod( "getDatabaseProductVersion", mID );
}
// -------------------------------------------------------------------------
::rtl::OUString SAL_CALL java_sql_DatabaseMetaData::getDatabaseProductName(  ) throw(SQLException, RuntimeException)
{
	static jmethodID mID = NULL;
    return impl_callStringMethod( "getDatabaseProductName", mID );
}
// -------------------------------------------------------------------------
::rtl::OUString SAL_CALL java_sql_DatabaseMetaData::getProcedureTerm(  ) throw(SQLException, RuntimeException)
{
	static jmethodID mID = NULL;
    return impl_callStringMethod( "getProcedureTerm", mID );
}
// -------------------------------------------------------------------------
::rtl::OUString SAL_CALL java_sql_DatabaseMetaData::getSchemaTerm(  ) throw(SQLException, RuntimeException)
{
	static jmethodID mID = NULL;
    return impl_callStringMethod( "getSchemaTerm", mID );
}
// -------------------------------------------------------------------------
sal_Int32 SAL_CALL java_sql_DatabaseMetaData::getDriverMajorVersion(  ) throw(RuntimeException)
{
	static jmethodID mID = NULL;
    return impl_callIntMethod( "getDriverMajorVersion", mID );
}
// -------------------------------------------------------------------------
sal_Int32 SAL_CALL java_sql_DatabaseMetaData::getDefaultTransactionIsolation(  ) throw(SQLException, RuntimeException)
{
	static jmethodID mID = NULL;
    return impl_callIntMethod( "getDefaultTransactionIsolation", mID );
}
// -------------------------------------------------------------------------
sal_Int32 SAL_CALL java_sql_DatabaseMetaData::getDriverMinorVersion(  ) throw(RuntimeException)
{
	static jmethodID mID = NULL;
    return impl_callIntMethod( "getDriverMinorVersion", mID );
}
// -------------------------------------------------------------------------
::rtl::OUString SAL_CALL java_sql_DatabaseMetaData::getSQLKeywords(  ) throw(SQLException, RuntimeException)
{
	static jmethodID mID = NULL;
    return impl_callStringMethod( "getSQLKeywords", mID );
}
// -------------------------------------------------------------------------
::rtl::OUString SAL_CALL java_sql_DatabaseMetaData::getSearchStringEscape(  ) throw(SQLException, RuntimeException)
{
	static jmethodID mID = NULL;
    return impl_callStringMethod( "getSearchStringEscape", mID );
}
// -------------------------------------------------------------------------
::rtl::OUString SAL_CALL java_sql_DatabaseMetaData::getStringFunctions(  ) throw(SQLException, RuntimeException)
{
	static jmethodID mID = NULL;
    return impl_callStringMethod( "getStringFunctions", mID );
}
// -------------------------------------------------------------------------
::rtl::OUString SAL_CALL java_sql_DatabaseMetaData::getTimeDateFunctions(  ) throw(SQLException, RuntimeException)
{
	static jmethodID mID = NULL;
    return impl_callStringMethod( "getTimeDateFunctions", mID );
}
// -------------------------------------------------------------------------
::rtl::OUString SAL_CALL java_sql_DatabaseMetaData::getSystemFunctions(  ) throw(SQLException, RuntimeException)
{
	static jmethodID mID = NULL;
    return impl_callStringMethod( "getSystemFunctions", mID );
}
// -------------------------------------------------------------------------
::rtl::OUString SAL_CALL java_sql_DatabaseMetaData::getNumericFunctions(  ) throw(SQLException, RuntimeException)
{
	static jmethodID mID = NULL;
    return impl_callStringMethod( "getNumericFunctions", mID );
}
// -------------------------------------------------------------------------
sal_Bool SAL_CALL java_sql_DatabaseMetaData::supportsExtendedSQLGrammar(  ) throw(SQLException, RuntimeException)
{
	static jmethodID mID = NULL;
    return impl_callBooleanMethod( "supportsExtendedSQLGrammar", mID );
}
// -------------------------------------------------------------------------
sal_Bool SAL_CALL java_sql_DatabaseMetaData::supportsCoreSQLGrammar(  ) throw(SQLException, RuntimeException)
{
	static jmethodID mID = NULL;
    return impl_callBooleanMethod( "supportsCoreSQLGrammar", mID );
}
// -------------------------------------------------------------------------
sal_Bool SAL_CALL java_sql_DatabaseMetaData::supportsMinimumSQLGrammar(  ) throw(SQLException, RuntimeException)
{
	static jmethodID mID = NULL;
    return impl_callBooleanMethod( "supportsMinimumSQLGrammar", mID );
}
// -------------------------------------------------------------------------
sal_Bool SAL_CALL java_sql_DatabaseMetaData::supportsFullOuterJoins(  ) throw(SQLException, RuntimeException)
{
	static jmethodID mID = NULL;
    return impl_callBooleanMethod( "supportsFullOuterJoins", mID );
}
// -------------------------------------------------------------------------
sal_Bool SAL_CALL java_sql_DatabaseMetaData::supportsLimitedOuterJoins(  ) throw(SQLException, RuntimeException)
{
	static jmethodID mID = NULL;
    return impl_callBooleanMethod( "supportsLimitedOuterJoins", mID );
}
// -------------------------------------------------------------------------
sal_Int32 SAL_CALL java_sql_DatabaseMetaData::getMaxColumnsInGroupBy(  ) throw(SQLException, RuntimeException)
{
	static jmethodID mID = NULL;
    return impl_callIntMethod( "getMaxColumnsInGroupBy", mID );
}
// -------------------------------------------------------------------------
sal_Int32 SAL_CALL java_sql_DatabaseMetaData::getMaxColumnsInOrderBy(  ) throw(SQLException, RuntimeException)
{
	static jmethodID mID = NULL;
    return impl_callIntMethod( "getMaxColumnsInOrderBy", mID );
}
// -------------------------------------------------------------------------
sal_Int32 SAL_CALL java_sql_DatabaseMetaData::getMaxColumnsInSelect(  ) throw(SQLException, RuntimeException)
{
	static jmethodID mID = NULL;
    return impl_callIntMethod( "getMaxColumnsInSelect", mID );
}
// -------------------------------------------------------------------------
sal_Int32 SAL_CALL java_sql_DatabaseMetaData::getMaxUserNameLength(  ) throw(SQLException, RuntimeException)
{
	static jmethodID mID = NULL;
    return impl_callIntMethod( "getMaxUserNameLength", mID );
}
// -------------------------------------------------------------------------
sal_Bool SAL_CALL java_sql_DatabaseMetaData::supportsResultSetType( sal_Int32 setType ) throw(SQLException, RuntimeException)
{
	static jmethodID mID = NULL;
    return impl_callBooleanMethodWithIntArg( "supportsResultSetType", mID, setType );
}
// -------------------------------------------------------------------------
sal_Bool SAL_CALL java_sql_DatabaseMetaData::supportsResultSetConcurrency( sal_Int32 setType, sal_Int32 concurrency ) throw(SQLException, RuntimeException)
{
    static const char* pMethodName = "supportsResultSetConcurrency";
    m_aLogger.log( LogLevel::FINEST, STR_LOG_META_DATA_METHOD_ARG2, pMethodName, setType, concurrency );

	jboolean out( sal_False );
    SDBThreadAttach t;
	if ( t.pEnv )
	{
		static jmethodID mID = NULL;
		if ( !mID  )
			mID  = t.pEnv->GetMethodID( getMyClass(), pMethodName, "(II)Z" );
        OSL_ENSURE( mID, "java_sql_DatabaseMetaData::supportsResultSetConcurrency: unknown method id!" );

        if ( mID )
        {
			out = 	t.pEnv->CallBooleanMethod( object, mID, setType, concurrency);
			ThrowLoggedSQLException( m_aLogger, t.pEnv, *this );
		}
	}

    m_aLogger.log< const sal_Char*, sal_Int16 >( LogLevel::FINEST, STR_LOG_META_DATA_RESULT, pMethodName, out );
	return out;
}
// -------------------------------------------------------------------------
sal_Bool SAL_CALL java_sql_DatabaseMetaData::ownUpdatesAreVisible( sal_Int32 setType ) throw(SQLException, RuntimeException)
{
	static jmethodID mID = NULL;
    return impl_callBooleanMethodWithIntArg( "ownUpdatesAreVisible", mID, setType );
}
// -------------------------------------------------------------------------
sal_Bool SAL_CALL java_sql_DatabaseMetaData::ownDeletesAreVisible( sal_Int32 setType ) throw(SQLException, RuntimeException)
{
	static jmethodID mID = NULL;
    return impl_callBooleanMethodWithIntArg( "ownDeletesAreVisible", mID, setType );
}
// -------------------------------------------------------------------------
sal_Bool SAL_CALL java_sql_DatabaseMetaData::ownInsertsAreVisible( sal_Int32 setType ) throw(SQLException, RuntimeException)
{
	static jmethodID mID = NULL;
    return impl_callBooleanMethodWithIntArg( "ownInsertsAreVisible", mID, setType );
}
// -------------------------------------------------------------------------
sal_Bool SAL_CALL java_sql_DatabaseMetaData::othersUpdatesAreVisible( sal_Int32 setType ) throw(SQLException, RuntimeException)
{
	static jmethodID mID = NULL;
    return impl_callBooleanMethodWithIntArg( "othersUpdatesAreVisible", mID, setType );
}
// -------------------------------------------------------------------------
sal_Bool SAL_CALL java_sql_DatabaseMetaData::othersDeletesAreVisible( sal_Int32 setType ) throw(SQLException, RuntimeException)
{
	static jmethodID mID = NULL;
    return impl_callBooleanMethodWithIntArg( "othersDeletesAreVisible", mID, setType );
}
// -------------------------------------------------------------------------
sal_Bool SAL_CALL java_sql_DatabaseMetaData::othersInsertsAreVisible( sal_Int32 setType ) throw(SQLException, RuntimeException)
{
	static jmethodID mID = NULL;
    return impl_callBooleanMethodWithIntArg( "othersInsertsAreVisible", mID, setType );
}
// -------------------------------------------------------------------------
sal_Bool SAL_CALL java_sql_DatabaseMetaData::updatesAreDetected( sal_Int32 setType ) throw(SQLException, RuntimeException)
{
	static jmethodID mID = NULL;
    return impl_callBooleanMethodWithIntArg( "updatesAreDetected", mID, setType );
}
// -------------------------------------------------------------------------
sal_Bool SAL_CALL java_sql_DatabaseMetaData::deletesAreDetected( sal_Int32 setType ) throw(SQLException, RuntimeException)
{
	static jmethodID mID = NULL;
    return impl_callBooleanMethodWithIntArg( "deletesAreDetected", mID, setType );
}
// -------------------------------------------------------------------------
sal_Bool SAL_CALL java_sql_DatabaseMetaData::insertsAreDetected( sal_Int32 setType ) throw(SQLException, RuntimeException)
{
	static jmethodID mID = NULL;
    return impl_callBooleanMethodWithIntArg( "insertsAreDetected", mID, setType );
}
// -------------------------------------------------------------------------
sal_Bool SAL_CALL java_sql_DatabaseMetaData::supportsBatchUpdates(  ) throw(SQLException, RuntimeException)
{
	static jmethodID mID = NULL;
    return impl_callBooleanMethod( "supportsBatchUpdates", mID );
}
// -------------------------------------------------------------------------
Reference< XResultSet > SAL_CALL java_sql_DatabaseMetaData::getUDTs(
        const Any& catalog, const ::rtl::OUString& schemaPattern, const ::rtl::OUString& typeNamePattern,
        const Sequence< sal_Int32 >& types ) throw(SQLException, RuntimeException)
{
	jobject out(0);
    SDBThreadAttach t; OSL_ENSURE(t.pEnv,"Java Enviroment geloescht worden!");
	if( t.pEnv ){


		static const char * cSignature = "(Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;[I;)Ljava/sql/ResultSet;";
		static const char * cMethodName = "getUDTs";
		// Java-Call absetzen
		static jmethodID mID = NULL;
		if ( !mID  )
			mID  = t.pEnv->GetMethodID( getMyClass(), cMethodName, cSignature );OSL_ENSURE(mID,"Unknown method id!");
		if( mID )
		{
			jvalue args[4];
			// temporaere Variable initialisieren
			args[0].l = catalog.hasValue() ? convertwchar_tToJavaString(t.pEnv,comphelper::getString(catalog)) : 0;
			args[1].l = schemaPattern.toChar() == '%' ? NULL : convertwchar_tToJavaString(t.pEnv,schemaPattern);
			args[2].l = convertwchar_tToJavaString(t.pEnv,typeNamePattern);
			jintArray pArray = t.pEnv->NewIntArray(types.getLength());
			t.pEnv->SetIntArrayRegion(pArray,0,types.getLength(),(jint*)types.getConstArray());
			args[3].l = pArray;

			out = t.pEnv->CallObjectMethod( object, mID, args[0].l, args[1].l,args[2].l,args[3].l);

			if(catalog.hasValue())
				t.pEnv->DeleteLocalRef((jstring)args[0].l);
			if(schemaPattern.getLength())
				t.pEnv->DeleteLocalRef((jstring)args[1].l);
			if(typeNamePattern.getLength())
				t.pEnv->DeleteLocalRef((jstring)args[2].l);
			if(args[3].l)
				t.pEnv->DeleteLocalRef((jintArray)args[3].l);
			ThrowLoggedSQLException( m_aLogger, t.pEnv, *this );
		}
	}

	return out ? new java_sql_ResultSet( t.pEnv, out, m_aLogger,*m_pConnection ) : 0;
}
// -------------------------------------------------------------------------
