/*************************************************************************
 *
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER.
 * 
 * Copyright 2008 by Sun Microsystems, Inc.
 *
 * OpenOffice.org - a multi-platform office productivity suite
 *
 * $RCSfile: SlsPageNotificationObjectContact.hxx,v $
 * $Revision: 1.5 $
 *
 * This file is part of OpenOffice.org.
 *
 * OpenOffice.org is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License version 3
 * only, as published by the Free Software Foundation.
 *
 * OpenOffice.org is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License version 3 for more details
 * (a copy is included in the LICENSE file that accompanied this code).
 *
 * You should have received a copy of the GNU Lesser General Public License
 * version 3 along with OpenOffice.org.  If not, see
 * <http://www.openoffice.org/license.html>
 * for a copy of the LGPLv3 License.
 *
 ************************************************************************/

#ifndef SD_SLIDESORTER_PAGE_NOTIFICATION_OBJECT_CONTACT_HXX
#define SD_SLIDESORTER_PAGE_NOTIFICATION_OBJECT_CONTACT_HXX

#include <svx/sdr/contact/objectcontactofobjlistpainter.hxx>

namespace sd { namespace slidesorter { namespace view {


/** We use this object contact to establish a link between the contact
    objects of an SdrPage object and an SdrPageObj object: a call to
    SdrPage::ActionChanged() eventually calls our InvalidatePartOfView().
    From there we can forward it to the PageObjectViewObjectContact object
    which in effect can update its preview.
*/
class PageNotificationObjectContact
    : public ::sdr::contact::ObjectContactPainter
{
public:
    /** Create a new object contact that forwards notifications from the
        given SdrPage to the given ViewObjectContact.
    */
	PageNotificationObjectContact (
        SdrPage& rBroadcaster,
        ::sdr::contact::ViewObjectContact& rListener);
    virtual ~PageNotificationObjectContact (void);

    /** Call this method in the first PaintObject() call after creation of a
        new object of this class.  This will lead to the creation of the
        tree of contact objects that link the broadcasting SdrPage with the
        listening ViewObjectContact.
    */
    virtual void EnsureValidDrawHierarchy (::sdr::contact::DisplayInfo& rDisplayInfo);

protected:
    /** There is only one object: the ViewContact of the broadcasting
        SdrPage.
    */
    virtual sal_uInt32 GetPaintObjectCount (void) const;

    /** There is only one object: the ViewContact of the broadcasting
        SdrPage.
        @throws RuntimeException
            When an invalid index is given then a RuntimeException is
            thrown.
        @param nIndex
            Only 0 is a valid index.
    */
    virtual ::sdr::contact::ViewContact& GetPaintObjectViewContact (sal_uInt32 nIndex) const;

    /** This call is translated into a ActionChanged() at the listening
        ViewObjectContact object.
        @param rRectangle
            Ignored.  ActionChanged() is always called.
    */
    virtual void InvalidatePartOfView (const Rectangle& rRectangle) const;

private:
	SdrPage& mrBroadcaster;
    ::sdr::contact::ViewObjectContact& mrListener;
};



} } } // end of namespace ::sd::slidesorter::view

#endif
