/*
 * Decompiled with CFR 0.152.
 */
package sun.security.x509;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import sun.security.util.DerOutputStream;
import sun.security.util.DerValue;
import sun.security.x509.GeneralName;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GeneralNames {
    private final List<GeneralName> names = new ArrayList<GeneralName>();

    public GeneralNames(DerValue derValue) throws IOException {
        this();
        if (derValue.tag != 48) {
            throw new IOException("Invalid encoding for GeneralNames.");
        }
        if (derValue.data.available() == 0) {
            throw new IOException("No data available in passed DER encoded value.");
        }
        while (derValue.data.available() != 0) {
            DerValue derValue2 = derValue.data.getDerValue();
            GeneralName generalName = new GeneralName(derValue2);
            this.add(generalName);
        }
    }

    public GeneralNames() {
    }

    public GeneralNames add(GeneralName generalName) {
        if (generalName == null) {
            throw new NullPointerException();
        }
        this.names.add(generalName);
        return this;
    }

    public GeneralName get(int n) {
        return this.names.get(n);
    }

    public boolean isEmpty() {
        return this.names.isEmpty();
    }

    public int size() {
        return this.names.size();
    }

    public Iterator<GeneralName> iterator() {
        return this.names.iterator();
    }

    public List<GeneralName> names() {
        return this.names;
    }

    public void encode(DerOutputStream derOutputStream) throws IOException {
        if (this.isEmpty()) {
            return;
        }
        DerOutputStream derOutputStream2 = new DerOutputStream();
        for (GeneralName generalName : this.names) {
            generalName.encode(derOutputStream2);
        }
        derOutputStream.write((byte)48, derOutputStream2);
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof GeneralNames)) {
            return false;
        }
        GeneralNames generalNames = (GeneralNames)object;
        return ((Object)this.names).equals(generalNames.names);
    }

    public int hashCode() {
        return ((Object)this.names).hashCode();
    }

    public String toString() {
        return this.names.toString();
    }
}

