/*
 * Decompiled with CFR 0.152.
 */
package sun.security.pkcs11;

import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidParameterException;
import java.security.ProviderException;
import java.security.SecureRandom;
import java.security.spec.AlgorithmParameterSpec;
import javax.crypto.KeyGeneratorSpi;
import javax.crypto.SecretKey;
import sun.security.pkcs11.P11Key;
import sun.security.pkcs11.Session;
import sun.security.pkcs11.Token;
import sun.security.pkcs11.wrapper.CK_ATTRIBUTE;
import sun.security.pkcs11.wrapper.CK_MECHANISM;
import sun.security.pkcs11.wrapper.PKCS11Exception;

final class P11KeyGenerator
extends KeyGeneratorSpi {
    private final Token token;
    private final String algorithm;
    private long mechanism;
    private int keySize;
    private int significantKeySize;
    private long keyType;

    P11KeyGenerator(Token token, String string, long l) throws PKCS11Exception {
        this.token = token;
        this.algorithm = string;
        this.mechanism = l;
        this.setDefaultKeySize();
    }

    private void setDefaultKeySize() {
        switch ((int)this.mechanism) {
            case 288: {
                this.keySize = 64;
                this.significantKeySize = 56;
                this.keyType = 19L;
                break;
            }
            case 304: {
                this.keySize = 128;
                this.significantKeySize = 112;
                this.keyType = 20L;
                break;
            }
            case 305: {
                this.keySize = 192;
                this.significantKeySize = 168;
                this.keyType = 21L;
                break;
            }
            case 4224: {
                this.keyType = 31L;
                this.keySize = 128;
                this.significantKeySize = 128;
                break;
            }
            case 272: {
                this.keyType = 18L;
                this.keySize = 128;
                this.significantKeySize = 128;
                break;
            }
            case 4240: {
                this.keyType = 32L;
                this.keySize = 128;
                this.significantKeySize = 128;
                break;
            }
            default: {
                throw new ProviderException("Unknown mechanism " + this.mechanism);
            }
        }
    }

    protected void engineInit(SecureRandom secureRandom) {
        this.token.ensureValid();
        this.setDefaultKeySize();
    }

    protected void engineInit(AlgorithmParameterSpec algorithmParameterSpec, SecureRandom secureRandom) throws InvalidAlgorithmParameterException {
        throw new InvalidAlgorithmParameterException("AlgorithmParameterSpec not supported");
    }

    protected void engineInit(int n, SecureRandom secureRandom) {
        this.token.ensureValid();
        switch ((int)this.mechanism) {
            case 288: {
                if (n != 64) {
                    throw new InvalidParameterException("DES key length must be 64 bits");
                }
                this.keySize = 64;
                this.significantKeySize = 56;
                break;
            }
            case 304: 
            case 305: {
                if (n == 128) {
                    this.mechanism = 304L;
                    this.keySize = 128;
                    this.significantKeySize = 112;
                    break;
                }
                if (n == 192) {
                    this.mechanism = 305L;
                    this.keySize = 192;
                    this.significantKeySize = 168;
                    break;
                }
                throw new InvalidParameterException("DESede key length must be 128 or 192 bits");
            }
            case 4224: {
                if (n != 128 && n != 192 && n != 256) {
                    throw new InvalidParameterException("AES key length must be 128, 192, or 256 bits");
                }
                this.keySize = n;
                this.significantKeySize = n;
                break;
            }
            case 272: {
                if (n < 40 || n > 1024) {
                    throw new InvalidParameterException("ARCFOUR key length must be between 40 and 1024 bits");
                }
                this.keySize = n;
                this.significantKeySize = n;
                break;
            }
            case 4240: {
                if (n < 40 || n > 448) {
                    throw new InvalidParameterException("Blowfish key length must be between 40 and 448 bits");
                }
                this.keySize = n;
                this.significantKeySize = n;
                break;
            }
            default: {
                throw new ProviderException("Unknown mechanism " + this.mechanism);
            }
        }
    }

    protected SecretKey engineGenerateKey() {
        Session session = null;
        try {
            CK_ATTRIBUTE[] cK_ATTRIBUTEArray;
            session = this.token.getObjSession();
            switch ((int)this.keyType) {
                case 19: 
                case 20: 
                case 21: {
                    cK_ATTRIBUTEArray = new CK_ATTRIBUTE[]{new CK_ATTRIBUTE(0L, 4L)};
                    break;
                }
                default: {
                    cK_ATTRIBUTEArray = new CK_ATTRIBUTE[]{new CK_ATTRIBUTE(0L, 4L), new CK_ATTRIBUTE(353L, this.keySize >> 3)};
                }
            }
            cK_ATTRIBUTEArray = this.token.getAttributes("generate", 4L, this.keyType, cK_ATTRIBUTEArray);
            long l = this.token.p11.C_GenerateKey(session.id(), new CK_MECHANISM(this.mechanism), cK_ATTRIBUTEArray);
            SecretKey secretKey = P11Key.secretKey(session, l, this.algorithm, this.significantKeySize, cK_ATTRIBUTEArray);
            return secretKey;
        }
        catch (PKCS11Exception pKCS11Exception) {
            throw new ProviderException("Could not generate key", pKCS11Exception);
        }
        finally {
            this.token.releaseSession(session);
        }
    }
}

