/*************************************************************************
 *
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER.
 * 
 * Copyright 2008 by Sun Microsystems, Inc.
 *
 * OpenOffice.org - a multi-platform office productivity suite
 *
 * $RCSfile: XMLFontAutoStylePool.hxx,v $
 * $Revision: 1.3 $
 *
 * This file is part of OpenOffice.org.
 *
 * OpenOffice.org is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License version 3
 * only, as published by the Free Software Foundation.
 *
 * OpenOffice.org is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License version 3 for more details
 * (a copy is included in the LICENSE file that accompanied this code).
 *
 * You should have received a copy of the GNU Lesser General Public License
 * version 3 along with OpenOffice.org.  If not, see
 * <http://www.openoffice.org/license.html>
 * for a copy of the LGPLv3 License.
 *
 ************************************************************************/

#ifndef _XMLOFF_XMLFONTAUTOSTYLEPOOL_HXX
#define _XMLOFF_XMLFONTAUTOSTYLEPOOL_HXX

#include "sal/config.h"
#include "xmloff/dllapi.h"
#include <rtl/ustring.hxx>
#include <xmloff/uniref.hxx>

class XMLFontAutoStylePool_Impl;
class XMLFontAutoStylePoolNames_Impl;
class SvXMLExport;

class XMLOFF_DLLPUBLIC XMLFontAutoStylePool : public UniRefBase
{
	SvXMLExport& rExport;

	XMLFontAutoStylePool_Impl *pPool;
	XMLFontAutoStylePoolNames_Impl *pNames;
	sal_uInt32 nName;

protected:

	SvXMLExport& GetExport() { return rExport; }

public:

	XMLFontAutoStylePool( SvXMLExport& rExport );
	~XMLFontAutoStylePool();

	::rtl::OUString Add(
			const ::rtl::OUString& rFamilyName,
			const ::rtl::OUString& rStyleName,
			sal_Int16 nFamily,
			sal_Int16 nPitch,
			rtl_TextEncoding eEnc );

	::rtl::OUString Find(
			const ::rtl::OUString& rFamilyName,
			const ::rtl::OUString& rStyleName,
			sal_Int16 nFamily,
			sal_Int16 nPitch,
			rtl_TextEncoding eEnc )const;
	::rtl::OUString Find( const ::rtl::OUString& rInternalName ) const;

	void exportXML(); 
};

#endif	//  _XMLOFF_XMLFONTAUTOSTYLEPOOL_HXX
