(defun insert-uml-class-begin (name)
  (insert "<UML:Class xmi.id=\"" name "\" name=\"" name "\">\n"))

(defun insert-uml-class-end ()
  (insert "</UML:Class>\n"))

(defun insert-uml-stereotype (stereotype)
  (insert "<UML:ModelElement.stereotype>\n")
  (insert "  <UML:Stereotype xmi.idref=\"" stereotype "\"/>\n")
  (insert "</UML:ModelElement.stereotype>\n"))


(defun insert-uml-taggedvalue (value type)
  (insert "    <UML:ModelElement.taggedValue>\n")
  (insert "      <UML:TaggedValue>\n")
  (insert "        <UML:TaggedValue.dataValue>" value "</UML:TaggedValue.dataValue>\n")
  (insert "        <UML:TaggedValue.type>\n")
  (insert "          <UML:TagDefinition xmi.idref=\"" type "\"/>\n")
  (insert "        </UML:TaggedValue.type>\n")
  (insert "      </UML:TaggedValue>\n")
  (insert "    </UML:ModelElement.taggedValue>\n"))
  
(defun insert-uml-attribute (type name offset bits mask shift comment attrid)
  (insert "<UML:Classifier.feature>\n")
  (insert "  <UML:Attribute name=\"" name "\">\n")
  (insert-uml-taggedvalue comment "comment")
  (insert-uml-taggedvalue offset "offset")
  (insert-uml-taggedvalue bits "bits")
  (insert-uml-taggedvalue mask "mask")
  (insert-uml-taggedvalue shift "shift")
  (insert-uml-taggedvalue attrid "attrid")
  (insert "    <UML:StructuralFeature.type>\n")
  (insert "      <UML:DataType xmi.idref=\"" type "\"/>\n")
  (insert "    </UML:StructuralFeature.type>\n")
  (insert "    <UML:ModelElement.stereotype>\n")
  (insert "      <UML:Stereotype xmi.idref=\"attribute\"/>\n")
  (insert "    </UML:ModelElement.stereotype>\n")
  (insert "  </UML:Attribute>\n")
  (insert "</UML:Classifier.feature>\n"))

(defun insert-uml-attribute-array (type arraycount name offset bits mask shift comment attrid)
  (insert "<UML:Classifier.feature>\n")
  (insert "  <UML:Attribute name=\"" name "\">\n")
  (insert-uml-taggedvalue comment "comment")
  (insert-uml-taggedvalue offset "offset")
  (insert-uml-taggedvalue bits "bits")
  (insert-uml-taggedvalue mask "mask")
  (insert-uml-taggedvalue shift "shift")
  (insert-uml-taggedvalue attrid "attrid")
  (insert-uml-taggedvalue arraycount "arraycount")
  (insert "    <UML:StructuralFeature.type>\n")
  (insert "      <UML:DataType xmi.idref=\"" type "\"/>\n")
  (insert "    </UML:StructuralFeature.type>\n")
  (insert "    <UML:ModelElement.stereotype>\n")
  (insert "      <UML:Stereotype xmi.idref=\"array\"/>\n")
  (insert "    </UML:ModelElement.stereotype>\n")
  (insert "  </UML:Attribute>\n")
  (insert "</UML:Classifier.feature>\n"))

(defun insert-uml-operation (type name comment opid)
  (insert "<UML:Classifier.feature>\n")
  (insert "  <UML:Operation name=\"" name "\" >\n")
  (insert-uml-taggedvalue opid "opid")
  (insert "    <UML:BehavioralFeature.parameter>\n")
  (insert "      <UML:Parameter kind=\"return\" name=\"return\">\n")
  (insert "        <UML:Parameter.type>\n")
  (insert "          <UML:Class xmi.idref=\"" type "\" />\n")
  (insert "        </UML:Parameter.type>\n")
  (insert "      </UML:Parameter>\n")
  (insert "    </UML:BehavioralFeature.parameter>\n")
  (insert "    <UML:ModelElement.stereotype>\n")
  (insert "      <UML:Stereotype xmi.idref=\"attribute\" />\n")
  (insert "    </UML:ModelElement.stereotype>\n")
  (insert "  </UML:Operation>\n")
  (insert "</UML:Classifier.feature>\n"))

(defun insert-uml-binary (name comment opid)
  (insert "<UML:Classifier.feature>\n")
  (insert "  <UML:Operation name=\"" name "\" >\n")
  (insert-uml-taggedvalue opid "opid")
  (insert "    <UML:BehavioralFeature.parameter>\n")
  (insert "      <UML:Parameter kind=\"return\" name=\"return\">\n")
  (insert "        <UML:Parameter.type>\n")
  (insert "          <UML:Class xmi.idref=\"Binary\" />\n")
  (insert "        </UML:Parameter.type>\n")
  (insert "      </UML:Parameter>\n")
  (insert "    </UML:BehavioralFeature.parameter>\n")
  (insert "    <UML:ModelElement.stereotype>\n")
  (insert "      <UML:Stereotype xmi.idref=\"binary\" />\n")
  (insert "    </UML:ModelElement.stereotype>\n")
  (insert "  </UML:Operation>\n")
  (insert "</UML:Classifier.feature>\n"))

(defun insert-uml-operation-array (type name comment opid)
  (insert "<UML:Classifier.feature>\n")
  (insert "  <UML:Operation name=\"" name "\" >\n")
  (insert-uml-taggedvalue opid "opid")
  (insert "    <UML:BehavioralFeature.parameter>\n")
  (insert "      <UML:Parameter kind=\"return\" name=\"return\">\n")
  (insert "        <UML:Parameter.type>\n")
  (insert "          <UML:Class xmi.idref=\"" type "\" />\n")
  (insert "        </UML:Parameter.type>\n")
  (insert "      </UML:Parameter>\n")
  (insert "    </UML:BehavioralFeature.parameter>\n")
  (insert "    <UML:ModelElement.stereotype>\n")
  (insert "      <UML:Stereotype xmi.idref=\"array\" />\n")
  (insert "    </UML:ModelElement.stereotype>\n")
  (insert "  </UML:Operation>\n")
  (insert "</UML:Classifier.feature>\n"))

(defun insert-uml-generalization (parent child)
  (insert "<UML:Generalization isSpecification=\"false\" xmi.id=\"" child "-" parent "\" >\n")
  (insert "  <UML:Generalization.child>\n")
  (insert "    <UML:Class xmi.idref=\"" child "\" />\n")
  (insert "  </UML:Generalization.child>\n")
  (insert "  <UML:Generalization.parent>\n")
  (insert "    <UML:Class xmi.idref=\"" parent "\" />\n")
  (insert "  </UML:Generalization.parent>\n")
  (insert "</UML:Generalization>\n"))

(defun insert-uml-sprm (name sprmcode kind)
  (insert-uml-class-begin name) 
  (insert-uml-stereotype "ww8sprm")
  (insert-uml-taggedvalue sprmcode "sprmcode")
  (insert-uml-taggedvalue (concat "rtf:" name) "sprmid")
  (insert-uml-taggedvalue kind "kind")
  (insert-uml-class-end))
