/*************************************************************************
 *
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER.
 * 
 * Copyright 2008 by Sun Microsystems, Inc.
 *
 * OpenOffice.org - a multi-platform office productivity suite
 *
 * $RCSfile: xout1.cxx,v $
 * $Revision: 1.6 $
 *
 * This file is part of OpenOffice.org.
 *
 * OpenOffice.org is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License version 3
 * only, as published by the Free Software Foundation.
 *
 * OpenOffice.org is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License version 3 for more details
 * (a copy is included in the LICENSE file that accompanied this code).
 *
 * You should have received a copy of the GNU Lesser General Public License
 * version 3 along with OpenOffice.org.  If not, see
 * <http://www.openoffice.org/license.html>
 * for a copy of the LGPLv3 License.
 *
 ************************************************************************/

// MARKER(update_precomp.py): autogen include statement, do not remove
#include "precompiled_svx.hxx"

#include <svx/xoutx.hxx>

#ifdef JOEDEBUG
#include "Q:\joedebug.hxx"
#endif

#define GLOBALOVERFLOW

/*************************************************************************
|*
|*    XOutputDevice::SetOffset()
|*
|*    Beschreibung
|*    Ersterstellung    08.11.94
|*    Letzte Aenderung  08.11.94
|*
*************************************************************************/

void XOutputDevice::SetOffset( const Point& rOfs )
{
	if (rOfs!=aOfs)
	{
		Point aDelta(rOfs);
		Fraction aFact1(1,1);
		aDelta-=aOfs;
#ifdef neeJOEDEBUG
		DebWrite("XOutputDevice::SetOffset(");
		DebOut(rOfs);
		DebWrite("Alter Offset: ");
		DebOut(aOfs);
		DebWrite("Alter Origin: ");
		DebOut(pOut->GetMapMode().GetOrigin());
		DebWrite("Delta: ");
		DebOut(aDelta);
#endif
//#ifdef JOEDEBUG
////        pOut->SetMapMode(MapMode(MAP_RELATIVE,Point(-aOfs.X(),-aOfs.Y()),aFact1,aFact1));
////        pOut->SetMapMode(MapMode(MAP_RELATIVE,rOfs,aFact1,aFact1));
		pOut->SetMapMode(MapMode(MAP_RELATIVE,aDelta,aFact1,aFact1));
//#else
//        MapMode aMap(pOut->GetMapMode());
//        Point   aOrg(aMap.GetOrigin());
//        aOrg.X()+=aDelta.X();
//        aOrg.Y()+=aDelta.Y();
//        aMap.SetOrigin(aOrg);
//        pOut->SetMapMode(aMap);
//#endif
		aOfs=rOfs;
#ifdef neeJOEDEBUG
		DebWrite("Neuer Offset: ");
		DebOut(aOfs);
		DebWrite("Neuer Origin: ");
		DebOut(pOut->GetMapMode().GetOrigin());
#endif
	}
}

/*************************************************************************
|*
|*    XOutputDevice::GetMapMode()
|*
|*    Beschreibung
|*    Ersterstellung    08.11.94
|*    Letzte Aenderung  08.11.94
|*
*************************************************************************/

MapMode XOutputDevice::GetMapMode() const
{
	MapMode aMap = pOut->GetMapMode();
	Point   aPos = aMap.GetOrigin();

	aPos.X() -= aOfs.X();
	aPos.Y() -= aOfs.Y();

	aMap.SetOrigin( aPos );

	return aMap;
}


/*************************************************************************
|*
|*    XOutputDevice::SetMapMode()
|*
|*    Beschreibung
|*    Ersterstellung    08.11.94
|*    Letzte Aenderung  08.11.94
|*
*************************************************************************/

void XOutputDevice::SetMapMode( const MapMode& rMap )
{
	Point aPos = rMap.GetOrigin();
	aPos.X() += aOfs.X();
	aPos.Y() += aOfs.Y();

	MapMode aMap( rMap );
	aMap.SetOrigin( aPos );

	pOut->SetMapMode( aMap );
}



