/*************************************************************************
 *
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER.
 * 
 * Copyright 2008 by Sun Microsystems, Inc.
 *
 * OpenOffice.org - a multi-platform office productivity suite
 *
 * $RCSfile: viewobjectcontactlist.cxx,v $
 * $Revision: 1.8 $
 *
 * This file is part of OpenOffice.org.
 *
 * OpenOffice.org is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License version 3
 * only, as published by the Free Software Foundation.
 *
 * OpenOffice.org is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License version 3 for more details
 * (a copy is included in the LICENSE file that accompanied this code).
 *
 * You should have received a copy of the GNU Lesser General Public License
 * version 3 along with OpenOffice.org.  If not, see
 * <http://www.openoffice.org/license.html>
 * for a copy of the LGPLv3 License.
 *
 ************************************************************************/

// MARKER(update_precomp.py): autogen include statement, do not remove
#include "precompiled_svx.hxx"
#include <svx/sdr/contact/viewobjectcontactlist.hxx>
#include <svx/sdr/contact/viewobjectcontact.hxx>
#include <svx/svdpage.hxx>
#include <svx/svdobj.hxx>
#include <svx/sdr/contact/viewcontact.hxx>
#include <svx/sdr/contact/displayinfo.hxx>

// for SOLARIS compiler include of algorithm part of _STL is necesary to
// get access to basic algos like ::std::find
#include <algorithm>

//////////////////////////////////////////////////////////////////////////////

namespace sdr
{
	namespace contact
	{
		ViewObjectContactList::ViewObjectContactList()
		:	mnCount(0L)
		{
		}

        void ViewObjectContactList::FlatCopyFrom( const ViewObjectContactList& rSource )
        {
            mnCount = rSource.mnCount;
            if(1L < mnCount)
            {
                maUnion.mpVOCVector = rSource.maUnion.mpVOCVector;
            }
            else
            {
                maUnion.mpVOContact = rSource.maUnion.mpVOContact;
            }
        }

		ViewObjectContactList::~ViewObjectContactList()
		{
			DBG_ASSERT(mnCount == 0L, "ViewObjectContactList::~ViewObjectContactList is not empty (!)");
		}

		ViewObjectContact* ViewObjectContactList::GetObject(sal_uInt32 nIndex) const
		{
			DBG_ASSERT(nIndex < mnCount, "ViewObjectContactList::GetObject() out of range (!)");

			if(1L < mnCount)
			{
				return (*maUnion.mpVOCVector)[nIndex];
			}
			else if(1L == mnCount)
			{
				return maUnion.mpVOContact;
			}
			else
			{
				return 0L;
			}
		}

		ViewObjectContact* ViewObjectContactList::GetLastObjectAndRemove()
		{
			if(1L < mnCount)
			{
				ViewObjectContact* pLastObject = maUnion.mpVOCVector->back();
				maUnion.mpVOCVector->pop_back();

				if(1L == --mnCount)
				{
					// simplify vector to simple pointer again
					ViewObjectContact* pObject = (*maUnion.mpVOCVector)[0];
					delete maUnion.mpVOCVector;
					maUnion.mpVOContact = pObject;
				}

				return pLastObject;
			}
			else if(1L == mnCount)
			{
				mnCount = 0L;
				return maUnion.mpVOContact;
			}

			DBG_ASSERT(sal_False, "ViewObjectContactList::GetLastObjectAndRemove() at empty list (!)");
			return 0L;
		}

		void ViewObjectContactList::Clear()
		{
			if(1L < mnCount)
			{
				delete maUnion.mpVOCVector;
			}

			mnCount = 0L;
		}

		void ViewObjectContactList::Append(ViewObjectContact* pNew)
		{
			DBG_ASSERT(pNew, "ViewObjectContactList::Insert() with empty poiter (!)");

			if(0L == mnCount)
			{
				maUnion.mpVOContact = pNew;
			}
			else if(1L == mnCount)
			{
				ViewObjectContactVector* pNewVector = new ViewObjectContactVector;
				pNewVector->push_back(maUnion.mpVOContact);
				pNewVector->push_back(pNew);
				maUnion.mpVOCVector = pNewVector;
			}
			else
			{
				maUnion.mpVOCVector->push_back(pNew);
			}

			mnCount++;
		}

		sal_Bool ViewObjectContactList::Remove(ViewObjectContact* pOld)
		{
			sal_Bool bRetval(sal_False);
			DBG_ASSERT(pOld, "ViewObjectContactList::Remove() with empty poiter (!)");

			if(1L < mnCount)
			{
				const ViewObjectContactVector::iterator aFindResult = ::std::find(maUnion.mpVOCVector->begin(), maUnion.mpVOCVector->end(), pOld);
				
				if(aFindResult != maUnion.mpVOCVector->end())
				{
					maUnion.mpVOCVector->erase(aFindResult);
					bRetval = sal_True;

					if(1L == --mnCount)
					{
						// simplify vector to simple pointer again
						ViewObjectContact* pObject = (*maUnion.mpVOCVector)[0];
						delete maUnion.mpVOCVector;
						maUnion.mpVOContact = pObject;
					}
				}
			}
			else if(1L == mnCount)
			{
				if(maUnion.mpVOContact == pOld)
				{
					bRetval = sal_True;
					mnCount = 0L;
				}
			}

			return bRetval;
		}

		sal_Bool ViewObjectContactList::Contains(ViewObjectContact* pOld)
		{
			DBG_ASSERT(pOld, "ViewObjectContactList::Contains() with empty poiter (!)");

			if(1L < mnCount)
			{
				const ViewObjectContactVector::iterator aFindResult = ::std::find(maUnion.mpVOCVector->begin(), maUnion.mpVOCVector->end(), pOld);
				return (aFindResult != maUnion.mpVOCVector->end());
			}
			else if(1L == mnCount)
			{
				return (maUnion.mpVOContact == pOld);
			}

			return sal_False;
		}

		// This method only recursively clears the draw hierarchy structure between the
		// DrawObjectContacts, it does not delete any to make them reusable.
		void ViewObjectContactList::ClearDrawHierarchy()
		{
			for(sal_uInt32 a(0); a < Count(); a++)
			{
				ViewObjectContact* pCandidate = GetObject(a);
				DBG_ASSERT(pCandidate, "Corrupt ViewObjectContactList (!)");

				// reset parent-pointer of VOContact
				pCandidate->SetParent(0L);

				// clear and reset sub-list
				pCandidate->ClearDrawHierarchy();
			}

			// clear this list
			Clear();
		}

		// This method recursively rebuilds the draw hierarchy structure in parallel
		// to the SdrObject structure.
		void ViewObjectContactList::BuildDrawHierarchy(
			ObjectContact& rObjectContact, ViewContact& rSourceNode, ViewObjectContact* pParent)
		{
			DBG_ASSERT(Count() == 0L, "BuildDrawHierarchy with not-empty ViewObjectContactList (!)");
			const sal_uInt32 nObjectCount(rSourceNode.GetObjectCount());

			for(sal_uInt32 a(0); a < nObjectCount; a++)
			{
				ViewContact& rViewContact = rSourceNode.GetViewContact(a);

				// Get the ViewObjectContact for this ViewContact and this DrawContact. This creates such an object
				// on demand and adds it to the ViewObjectContactList of the ViewContact.
				ViewObjectContact& rViewObjectContact = rViewContact.GetViewObjectContact(rObjectContact);

				// Now add it to the local list
				Append(&rViewObjectContact);

				// set parent at ViewObjectContact. Do this before calling
				// BuildDrawHierarchy below to evtl. use the valid parent.
				if(pParent)
				{
					rViewObjectContact.SetParent(pParent);
				}

				// is there a sub hierarchy?
				if(rViewContact.GetObjectCount())
				{
					rViewObjectContact.BuildDrawHierarchy(rObjectContact, rViewContact);
				}
			}
		}

		// This method recursively checks the draw hierarchy structure in parallel
		// to the SdrObject structure and rebuilds the invalid parts.
		void ViewObjectContactList::CheckDrawHierarchy(ObjectContact& rObjectContact)
		{
			for(sal_uInt32 a(0); a < Count(); a++)
			{
				ViewObjectContact* pCandidate = GetObject(a);
				DBG_ASSERT(pCandidate, "Corrupt ViewObjectContactList (!)");

				// recursively check the draw hierarchy.
				pCandidate->CheckDrawHierarchy(rObjectContact);
			}
		}

		// If DrawHierarchy is handled by a object itself, the sub-objects are set 
		// to be equally painted to that object
		void ViewObjectContactList::CopyPaintFlagsFromParent(const ViewObjectContact& rParent)
		{
			for(sal_uInt32 a(0); a < Count(); a++)
			{
				ViewObjectContact* pCandidate = GetObject(a);
				DBG_ASSERT(pCandidate, "Corrupt ViewObjectContactList (!)");

				// recursively set DrawHierarchy to use parent
				pCandidate->CopyPaintFlagsFromParent(rParent);
			}
		}
	} // end of namespace contact
} // end of namespace sdr

//////////////////////////////////////////////////////////////////////////////
// eof
