/*************************************************************************
 *
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER.
 * 
 * Copyright 2008 by Sun Microsystems, Inc.
 *
 * OpenOffice.org - a multi-platform office productivity suite
 *
 * $RCSfile: SectionsWindow.hxx,v $
 * $Revision: 1.3 $
 *
 * This file is part of OpenOffice.org.
 *
 * OpenOffice.org is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License version 3
 * only, as published by the Free Software Foundation.
 *
 * OpenOffice.org is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License version 3 for more details
 * (a copy is included in the LICENSE file that accompanied this code).
 *
 * You should have received a copy of the GNU Lesser General Public License
 * version 3 along with OpenOffice.org.  If not, see
 * <http://www.openoffice.org/license.html>
 * for a copy of the LGPLv3 License.
 *
 ************************************************************************/
#ifndef RPTUI_SECTIONSWINDOW_HXX
#define RPTUI_SECTIONSWINDOW_HXX

#include <com/sun/star/report/XSection.hpp>
#include <vcl/window.hxx>
#include <svtools/colorcfg.hxx>
#include <comphelper/propmultiplex.hxx>
#include "cppuhelper/basemutex.hxx"
#include "UITools.hxx"
#include "UndoActions.hxx"

#include <list>
#include <map>
#include <boost/shared_ptr.hpp>

class Splitter;
namespace comphelper
{
	class OPropertyChangeMultiplexer;
}
namespace rptui
{
	class OReportWindow;
	class ODesignView;
	class OStartMarker;
	class OSectionsWindow :		public Window
							,	public ::cppu::BaseMutex
							,	public ::comphelper::OPropertyChangeListener
	{
	public:
		typedef ::std::pair< ::rtl::Reference< comphelper::OPropertyChangeMultiplexer>, ::com::sun::star::uno::Reference< ::com::sun::star::report::XSection > > TSectionMutilPair;
		typedef ::std::pair< ::boost::shared_ptr<OStartMarker>,TSectionMutilPair> TSectionPair;
		typedef ::std::list< TSectionPair > TSectionsMap;
        typedef ::std::map< com::sun::star::uno::Reference< com::sun::star::report::XGroup>,::rtl::Reference< comphelper::OPropertyChangeMultiplexer> > TGroupChangeMultiplexer;
	private:
		TSectionsMap		    m_aSections;
        TGroupChangeMultiplexer m_aGroupChangeMultiplexer; /// a collection of all groups with the property change multiplexer
		OReportWindow*		    m_pParent;
		void ImplInitSettings();

        /** set the title of the group header or footer
        *
        * \param _xGroup 
        * \param _nResId 
        * \param _pGetSection 
        * \param _pIsSectionOn 
        */
        void setGroupSectionTitle(const ::com::sun::star::uno::Reference< ::com::sun::star::report::XGroup>& _xGroup,USHORT _nResId,::std::mem_fun_t< ::com::sun::star::uno::Reference< ::com::sun::star::report::XSection> , OGroupHelper> _pGetSection,::std::mem_fun_t<sal_Bool, OGroupHelper> _pIsSectionOn);

        OSectionsWindow(OSectionsWindow&);
        void operator =(OSectionsWindow&);
	protected:
		virtual void DataChanged( const DataChangedEvent& rDCEvt );
		virtual void MouseButtonDown( const MouseEvent& rMEvt );
        // OPropertyChangeListener
		virtual void	_propertyChanged(const ::com::sun::star::beans::PropertyChangeEvent& _rEvent) throw( ::com::sun::star::uno::RuntimeException);
	public:
		OSectionsWindow( Window* _pParent,OReportWindow* _pReportWindow);
		virtual ~OSectionsWindow();

        // windows overload
		virtual void Resize();

        OReportWindow*	getReportWindow() const { return m_pParent; }

		/** gives the position of the section 
		*	If the section is <NULL/> nothing happens.
		* \param _xSection 
		*/
		USHORT			getPosition(const ::com::sun::star::uno::Reference< ::com::sun::star::report::XSection >& _xSection) const;

		/** removes the section at the given position.
		*
		* \param _nPosition Zero based.
		*/
		void			removeSection(USHORT _nPosition);

		/** adds a new section at position _nPosition.
			If the section is <NULL/> nothing happens.
			If the position is grater than the current elements, the section will be appended.
		*/
		void			addSection(const ::com::sun::star::uno::Reference< ::com::sun::star::report::XSection >& _xSection
									,const ::rtl::OUString& _sColorEntry
									,USHORT _nPosition = USHRT_MAX);

		USHORT			find(const OStartMarker* _pMarker) const;

		sal_Int32		getRulerWidth() const;

		/** returns the minimum height of the section
		*
		* \param _nPos
		* \return the height in pixel
		*/
		sal_Int32		getMinHeight(USHORT _nPos) const;

		/** shows or hides the ruler.
		*/
		void			showRuler(sal_Bool _bShow);

		/** triggers the property browser with the section
			@param	_pStartMarker
		*/
		void			showProperties( const OStartMarker* _pStartMarker);

		/** the the section as marked or not marked
			@param	_xSection	the section where to set the marked flag
			@param	_bMark		the marked flag
		*/
		void			setMarked(const ::com::sun::star::uno::Reference< ::com::sun::star::report::XSection >& _xSection,sal_Bool _bMark);

        /** fills the positions of all collapsed sections.
        *
        * \param _rCollapsedPositions Out parameter which holds afterwards all positions of the collapsed sections.
        */
        void fillCollapsedSections(::std::vector<sal_uInt16>& _rCollapsedPositions) const;

        /** collpase all sections given by their position
        *
        * \param _aCollpasedSections The position of the sections which should be collapsed.
        */
        void collapseSections(const com::sun::star::uno::Sequence< ::com::sun::star::beans::PropertyValue>& _aCollpasedSections);
	};
//==============================================================================
} // rptui
//==============================================================================
#endif // RPTUI_SECTIONSWINDOW_HXX

