/*************************************************************************
 *
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER.
 * 
 * Copyright 2008 by Sun Microsystems, Inc.
 *
 * OpenOffice.org - a multi-platform office productivity suite
 *
 * $RCSfile: acceptor.hxx,v $
 * $Revision: 1.9 $
 *
 * This file is part of OpenOffice.org.
 *
 * OpenOffice.org is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License version 3
 * only, as published by the Free Software Foundation.
 *
 * OpenOffice.org is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License version 3 for more details
 * (a copy is included in the LICENSE file that accompanied this code).
 *
 * You should have received a copy of the GNU Lesser General Public License
 * version 3 along with OpenOffice.org.  If not, see
 * <http://www.openoffice.org/license.html>
 * for a copy of the LGPLv3 License.
 *
 ************************************************************************/

#include <osl/pipe.hxx>
#include <osl/socket.hxx>
#include <rtl/unload.h>

#include <com/sun/star/connection/XConnection.hpp>

namespace io_acceptor {

	extern rtl_StandardModuleCount g_moduleCount;

	class PipeAcceptor
	{
	public:
		PipeAcceptor( const ::rtl::OUString &sPipeName , const ::rtl::OUString &sConnectionDescription );
		
		void init();
		::com::sun::star::uno::Reference < ::com::sun::star::connection::XConnection >  accept(  );
		
		void stopAccepting();
		
        ::osl::Mutex m_mutex;
		::osl::Pipe m_pipe;
		::rtl::OUString m_sPipeName;
		::rtl::OUString m_sConnectionDescription;
		sal_Bool m_bClosed;
	};
	
	class SocketAcceptor
	{
	public:
		SocketAcceptor( const ::rtl::OUString & sSocketName ,
						sal_uInt16 nPort,
						sal_Bool bTcpNoDelay,
						const ::rtl::OUString &sConnectionDescription );

		void init();
		::com::sun::star::uno::Reference < ::com::sun::star::connection::XConnection > accept();

		void stopAccepting();
		
		::osl::SocketAddr m_addr;
		::osl::AcceptorSocket m_socket;
		::rtl::OUString m_sSocketName;
		::rtl::OUString m_sConnectionDescription;
		sal_uInt16 m_nPort;
		sal_Bool m_bTcpNoDelay;
		sal_Bool m_bClosed;
	};
	
}

