#include "vclxproxy.hxx"

namespace css = com::sun::star;

// This is a generic proxy class - override it to wrap &
// extend these interfaces
// Warning: this is of course not complete ...

VCLXProxy::VCLXProxy( css::uno::Reference< css::uno::XInterface > xObject )
    : mxDevice( xObject, css::uno::UNO_QUERY )
    , mxTypeProvider( xObject, css::uno::UNO_QUERY )
    , mxUnoTunnel( xObject, css::uno::UNO_QUERY )
    , mxComponent( xObject, css::uno::UNO_QUERY )
    , mxWindow( xObject, css::uno::UNO_QUERY )
    , mxWindow2( xObject, css::uno::UNO_QUERY )
    , mxWindowPeer( xObject, css::uno::UNO_QUERY )
    , mxVclWindowPeer( xObject, css::uno::UNO_QUERY )
    , mxLayoutConstrains( xObject, css::uno::UNO_QUERY )
    , mxView( xObject, css::uno::UNO_QUERY )
    , mxDockableWindow( xObject, css::uno::UNO_QUERY )
    , mxAccessible( xObject, css::uno::UNO_QUERY )
    , mxEventListener( xObject, css::uno::UNO_QUERY )
    , mxPropertySetInfo( xObject, css::uno::UNO_QUERY )
    , mxItemEventBroadcaster( xObject, css::uno::UNO_QUERY )
    , mxImageConsumer( xObject, css::uno::UNO_QUERY )
    , mxButton( xObject, css::uno::UNO_QUERY )
    , mxToggleButton( xObject, css::uno::UNO_QUERY )
{
}

css::uno::Any SAL_CALL
VCLXProxy::queryInterface( const css::uno::Type & rType ) throw (css::uno::RuntimeException)
{
    css::uno::Any aRet;

#define QI(t,memb) \
    if (!aRet.hasValue() && memb.is() && rType == t::static_type()) \
        aRet = css::uno::Any( css::uno::Reference< t >( static_cast<t *>(this) ) )

    // VCLXDevice
    QI( css::awt::XDevice, mxDevice );
    QI( css::lang::XTypeProvider, mxTypeProvider );
    QI( css::lang::XUnoTunnel, mxUnoTunnel );

    // VCLXWindow
    if (!aRet.hasValue() && mxComponent.is() &&
        rType == css::lang::XComponent::static_type())
        aRet = css::uno::Any( css::uno::Reference< css::lang::XComponent >( static_cast<css::awt::XWindow *>(this) ) );

    QI( css::awt::XWindow, mxWindow );
    QI( css::awt::XWindow2, mxWindow2 );
    QI( css::awt::XWindowPeer, mxWindowPeer );
    QI( css::awt::XVclWindowPeer, mxVclWindowPeer );
    QI( css::awt::XLayoutConstrains, mxLayoutConstrains );
    QI( css::awt::XView, mxView );
    QI( css::awt::XDockableWindow, mxDockableWindow );
    QI( css::accessibility::XAccessible, mxAccessible );
    QI( css::lang::XEventListener, mxEventListener );

    QI( css::beans::XPropertySetInfo, mxPropertySetInfo );
    QI( css::awt::XItemEventBroadcaster, mxItemEventBroadcaster );
    // VCLXImageConsumer
    QI( css::awt::XImageConsumer, mxImageConsumer );
    // VCLXButton
    QI( css::awt::XButton, mxButton );
    QI( css::awt::XToggleButton, mxToggleButton );
#undef QI

    if ( !aRet.hasValue() )
        aRet = OWeakObject::queryInterface( rType );
    return aRet;
}


// Tons of boilerplate ... urgh [!]

// lang::XComponent
void VCLXProxy::dispose() throw (css::uno::RuntimeException)
{
    mxComponent->dispose();
}
void VCLXProxy::addEventListener( const css::uno::Reference< css::lang::XEventListener >& xListener ) throw (css::uno::RuntimeException)
{
    mxComponent->addEventListener( xListener );
}
void VCLXProxy::removeEventListener( const css::uno::Reference< css::lang::XEventListener >& aListener ) throw (css::uno::RuntimeException)
{
    mxComponent->removeEventListener( aListener );
}

// awt::XWindowPeer
css::uno::Reference< css::awt::XToolkit > VCLXProxy::getToolkit() throw (css::uno::RuntimeException)
{
    return mxWindowPeer->getToolkit();
}
void VCLXProxy::setPointer( const css::uno::Reference< css::awt::XPointer >& Pointer ) throw (css::uno::RuntimeException)
{
    mxWindowPeer->setPointer( Pointer );
}
void VCLXProxy::setBackground( ::sal_Int32 Color ) throw (css::uno::RuntimeException)
{
    mxWindowPeer->setBackground( Color );
}
void VCLXProxy::invalidate( ::sal_Int16 Flags ) throw (css::uno::RuntimeException)
{
    mxWindowPeer->invalidate( Flags );
}
void VCLXProxy::invalidateRect( const css::awt::Rectangle& Rect, ::sal_Int16 Flags ) throw (css::uno::RuntimeException)
{
    mxWindowPeer->invalidateRect( Rect, Flags );
}

// awt::XDevice
css::uno::Reference< css::awt::XGraphics > VCLXProxy::createGraphics() throw (css::uno::RuntimeException)
{
    return mxDevice->createGraphics();
}
css::uno::Reference< css::awt::XDevice > VCLXProxy::createDevice( ::sal_Int32 nWidth, ::sal_Int32 nHeight ) throw (css::uno::RuntimeException)
{
    return mxDevice->createDevice( nWidth, nHeight );
}
css::awt::DeviceInfo VCLXProxy::getInfo() throw (css::uno::RuntimeException)
{
    return mxDevice->getInfo();
}
css::uno::Sequence< css::awt::FontDescriptor > VCLXProxy::getFontDescriptors() throw (css::uno::RuntimeException)
{
    return mxDevice->getFontDescriptors();
}
css::uno::Reference< css::awt::XFont > VCLXProxy::getFont( const css::awt::FontDescriptor& aDescriptor ) throw (css::uno::RuntimeException)
{
    return mxDevice->getFont( aDescriptor );
}
css::uno::Reference< css::awt::XBitmap > VCLXProxy::createBitmap( ::sal_Int32 nX, ::sal_Int32 nY, ::sal_Int32 nWidth, ::sal_Int32 nHeight ) throw (css::uno::RuntimeException)
{
    return mxDevice->createBitmap( nX, nY, nWidth, nHeight );
}
css::uno::Reference< css::awt::XDisplayBitmap > VCLXProxy::createDisplayBitmap( const css::uno::Reference< css::awt::XBitmap >& Bitmap ) throw (css::uno::RuntimeException)
{
    return mxDevice->createDisplayBitmap( Bitmap );
}

// lang::XTypeProvider
css::uno::Sequence< css::uno::Type > VCLXProxy::getTypes() throw (css::uno::RuntimeException)
{
    return mxTypeProvider->getTypes();
}
css::uno::Sequence< ::sal_Int8 > VCLXProxy::getImplementationId() throw (css::uno::RuntimeException)
{
    return mxTypeProvider->getImplementationId();
}

// lang::XUnoTunnel
::sal_Int64 VCLXProxy::getSomething( const css::uno::Sequence< ::sal_Int8 >& aIdentifier ) throw (css::uno::RuntimeException)
{
    return mxUnoTunnel->getSomething( aIdentifier );
}

// awt::XWindow2
void VCLXProxy::setOutputSize( const css::awt::Size& aSize ) throw (css::uno::RuntimeException)
{
    mxWindow2->setOutputSize( aSize );
}
css::awt::Size VCLXProxy::getOutputSize() throw (css::uno::RuntimeException)
{
    return mxWindow2->getOutputSize();
}
::sal_Bool VCLXProxy::isVisible() throw (css::uno::RuntimeException)
{
    return mxWindow2->isVisible();
}
::sal_Bool VCLXProxy::isActive() throw (css::uno::RuntimeException)
{
    return mxWindow2->isActive();
}
::sal_Bool VCLXProxy::isEnabled() throw (css::uno::RuntimeException)
{
    return mxWindow2->isEnabled();
}
::sal_Bool VCLXProxy::hasFocus() throw (css::uno::RuntimeException)
{
    return mxWindow2->hasFocus();
}

// awt::XWindow
void VCLXProxy::setPosSize( ::sal_Int32 X, ::sal_Int32 Y, ::sal_Int32 Width, ::sal_Int32 Height, ::sal_Int16 Flags ) throw (css::uno::RuntimeException)
{
    mxWindow->setPosSize( X, Y, Width, Height, Flags );
}
css::awt::Rectangle VCLXProxy::getPosSize() throw (css::uno::RuntimeException)
{
    return mxWindow->getPosSize();
}
void VCLXProxy::setVisible( ::sal_Bool Visible ) throw (css::uno::RuntimeException)
{
    mxWindow->setVisible( Visible );
}
void VCLXProxy::setEnable( ::sal_Bool Enable ) throw (css::uno::RuntimeException)
{
    mxWindow->setEnable( Enable );
}
void VCLXProxy::setFocus() throw (css::uno::RuntimeException)
{
    mxWindow->setFocus();
}
void VCLXProxy::addWindowListener( const css::uno::Reference< css::awt::XWindowListener >& xListener ) throw (css::uno::RuntimeException)
{
    mxWindow->addWindowListener( xListener );
}
void VCLXProxy::removeWindowListener( const css::uno::Reference< css::awt::XWindowListener >& xListener ) throw (css::uno::RuntimeException)
{
    mxWindow->removeWindowListener( xListener );
}
void VCLXProxy::addFocusListener( const css::uno::Reference< css::awt::XFocusListener >& xListener ) throw (css::uno::RuntimeException)
{
    mxWindow->addFocusListener( xListener );
}
void VCLXProxy::removeFocusListener( const css::uno::Reference< css::awt::XFocusListener >& xListener ) throw (css::uno::RuntimeException)
{
    mxWindow->removeFocusListener( xListener );
}
void VCLXProxy::addKeyListener( const css::uno::Reference< css::awt::XKeyListener >& xListener ) throw (css::uno::RuntimeException)
{
    mxWindow->addKeyListener( xListener );
}
void VCLXProxy::removeKeyListener( const css::uno::Reference< css::awt::XKeyListener >& xListener ) throw (css::uno::RuntimeException)
{
    mxWindow->removeKeyListener( xListener );
}
void VCLXProxy::addMouseListener( const css::uno::Reference< css::awt::XMouseListener >& xListener ) throw (css::uno::RuntimeException)
{
    mxWindow->addMouseListener( xListener );
}
void VCLXProxy::removeMouseListener( const css::uno::Reference< css::awt::XMouseListener >& xListener ) throw (css::uno::RuntimeException)
{
    mxWindow->removeMouseListener( xListener );
}
void VCLXProxy::addMouseMotionListener( const css::uno::Reference< css::awt::XMouseMotionListener >& xListener ) throw (css::uno::RuntimeException)
{
    mxWindow->addMouseMotionListener( xListener );
}
void VCLXProxy::removeMouseMotionListener( const css::uno::Reference< css::awt::XMouseMotionListener >& xListener ) throw (css::uno::RuntimeException)
{
    mxWindow->removeMouseMotionListener( xListener );
}
void VCLXProxy::addPaintListener( const css::uno::Reference< css::awt::XPaintListener >& xListener ) throw (css::uno::RuntimeException)
{
    mxWindow->addPaintListener( xListener );
}
void VCLXProxy::removePaintListener( const css::uno::Reference< css::awt::XPaintListener >& xListener ) throw (css::uno::RuntimeException)
{
    mxWindow->removePaintListener( xListener );
}

// awt::XVclWindowPeer
::sal_Bool VCLXProxy::isChild( const css::uno::Reference< css::awt::XWindowPeer >& Peer ) throw (css::uno::RuntimeException)
{
    return mxVclWindowPeer->isChild( Peer );
}
void VCLXProxy::setDesignMode( ::sal_Bool bOn ) throw (css::uno::RuntimeException)
{
    mxVclWindowPeer->setDesignMode( bOn );
}
::sal_Bool VCLXProxy::isDesignMode() throw (css::uno::RuntimeException)
{
    return mxVclWindowPeer->isDesignMode();
}
void VCLXProxy::enableClipSiblings( ::sal_Bool bClip ) throw (css::uno::RuntimeException)
{
    mxVclWindowPeer->enableClipSiblings( bClip );
}
void VCLXProxy::setForeground( ::sal_Int32 Color ) throw (css::uno::RuntimeException)
{
    mxVclWindowPeer->setForeground( Color );
}
void VCLXProxy::setControlFont( const css::awt::FontDescriptor& aFont ) throw (css::uno::RuntimeException)
{
    mxVclWindowPeer->setControlFont( aFont );
}
void VCLXProxy::getStyles( ::sal_Int16 nType, css::awt::FontDescriptor& Font, ::sal_Int32& ForegroundColor, ::sal_Int32& BackgroundColor ) throw (css::uno::RuntimeException)
{
    mxVclWindowPeer->getStyles( nType, Font, ForegroundColor, BackgroundColor );
}
void VCLXProxy::setProperty( const ::rtl::OUString& PropertyName, const css::uno::Any& Value ) throw (css::uno::RuntimeException)
{
    mxVclWindowPeer->setProperty( PropertyName, Value );
}
css::uno::Any VCLXProxy::getProperty( const ::rtl::OUString& PropertyName ) throw (css::uno::RuntimeException)
{
    return mxVclWindowPeer->getProperty( PropertyName );
}

// awt::XLayoutConstrains
css::awt::Size VCLXProxy::getMinimumSize() throw (css::uno::RuntimeException)
{
    return mxLayoutConstrains->getMinimumSize();
}
css::awt::Size VCLXProxy::getPreferredSize() throw (css::uno::RuntimeException)
{
    return mxLayoutConstrains->getPreferredSize();
}
css::awt::Size VCLXProxy::calcAdjustedSize( const css::awt::Size& aNewSize ) throw (css::uno::RuntimeException)
{
    return mxLayoutConstrains->calcAdjustedSize( aNewSize );
}

// awt::XView
::sal_Bool VCLXProxy::setGraphics( const css::uno::Reference< css::awt::XGraphics >& aDevice ) throw (css::uno::RuntimeException)
{
    return mxView->setGraphics( aDevice );
}
css::uno::Reference< css::awt::XGraphics > VCLXProxy::getGraphics() throw (css::uno::RuntimeException)
{
    return mxView->getGraphics();
}
css::awt::Size VCLXProxy::getSize() throw (css::uno::RuntimeException)
{
    return mxView->getSize();
}
void VCLXProxy::draw( ::sal_Int32 nX, ::sal_Int32 nY ) throw (css::uno::RuntimeException)
{
    mxView->draw( nX, nY );
}
void VCLXProxy::setZoom( float fZoomX, float fZoomY ) throw (css::uno::RuntimeException)
{
    mxView->setZoom( fZoomX, fZoomY );
}

// awt::XDockableWindow
void VCLXProxy::addDockableWindowListener( const css::uno::Reference< css::awt::XDockableWindowListener >& xListener ) throw (css::uno::RuntimeException)
{
    mxDockableWindow->addDockableWindowListener( xListener );
}
void VCLXProxy::removeDockableWindowListener( const css::uno::Reference< css::awt::XDockableWindowListener >& xListener ) throw (css::uno::RuntimeException)
{
    mxDockableWindow->removeDockableWindowListener( xListener );
}
void VCLXProxy::enableDocking( ::sal_Bool bEnable ) throw (css::uno::RuntimeException)
{
    mxDockableWindow->enableDocking( bEnable );
}
::sal_Bool VCLXProxy::isFloating() throw (css::uno::RuntimeException)
{
    return mxDockableWindow->isFloating();
}
void VCLXProxy::setFloatingMode( ::sal_Bool bFloating ) throw (css::uno::RuntimeException)
{
    mxDockableWindow->setFloatingMode( bFloating );
}
void VCLXProxy::lock() throw (css::uno::RuntimeException)
{
    mxDockableWindow->lock();
}
void VCLXProxy::unlock() throw (css::uno::RuntimeException)
{
    mxDockableWindow->unlock();
}
::sal_Bool VCLXProxy::isLocked() throw (css::uno::RuntimeException)
{
    return mxDockableWindow->isLocked();
}
void VCLXProxy::startPopupMode( const css::awt::Rectangle& WindowRect ) throw (css::uno::RuntimeException)
{
    mxDockableWindow->startPopupMode( WindowRect );
}
::sal_Bool VCLXProxy::isInPopupMode() throw (css::uno::RuntimeException)
{
    return mxDockableWindow->isInPopupMode();
}

// accessibility::XAccessible
css::uno::Reference< css::accessibility::XAccessibleContext > VCLXProxy::getAccessibleContext() throw (css::uno::RuntimeException)
{
    return mxAccessible->getAccessibleContext();
}

// lang::XEventListener
void VCLXProxy::disposing( const css::lang::EventObject& Source ) throw (css::uno::RuntimeException)
{
    mxEventListener->disposing( Source );
}

// beans::XPropertySetInfo
css::uno::Sequence< css::beans::Property > VCLXProxy::getProperties() throw (css::uno::RuntimeException)
{
    return mxPropertySetInfo->getProperties();
}
css::beans::Property VCLXProxy::getPropertyByName( const ::rtl::OUString& aName ) throw (css::beans::UnknownPropertyException, css::uno::RuntimeException)
{
    return mxPropertySetInfo->getPropertyByName( aName );
}
::sal_Bool VCLXProxy::hasPropertyByName( const ::rtl::OUString& Name ) throw (css::uno::RuntimeException)
{
    return mxPropertySetInfo->hasPropertyByName( Name );
}

// awt::XImageConsumer
void VCLXProxy::init( ::sal_Int32 Width, ::sal_Int32 Height ) throw (css::uno::RuntimeException)
{
    mxImageConsumer->init( Width, Height );
}
void VCLXProxy::setColorModel( ::sal_Int16 BitCount, const css::uno::Sequence< ::sal_Int32 >& RGBAPal, ::sal_Int32 RedMask, ::sal_Int32 GreenMask, ::sal_Int32 BlueMask, ::sal_Int32 AlphaMask ) throw (css::uno::RuntimeException)
{
    mxImageConsumer->setColorModel( BitCount, RGBAPal, RedMask, GreenMask, BlueMask, AlphaMask );
}
void VCLXProxy::setPixelsByBytes( ::sal_Int32 nX, ::sal_Int32 nY, ::sal_Int32 nWidth, ::sal_Int32 nHeight, const css::uno::Sequence< ::sal_Int8 >& aProducerData, ::sal_Int32 nOffset, ::sal_Int32 nScanSize ) throw (css::uno::RuntimeException)
{
    mxImageConsumer->setPixelsByBytes( nX, nY, nWidth, nHeight, aProducerData, nOffset, nScanSize );
}
void VCLXProxy::setPixelsByLongs( ::sal_Int32 nX, ::sal_Int32 nY, ::sal_Int32 nWidth, ::sal_Int32 nHeight, const css::uno::Sequence< ::sal_Int32 >& aProducerData, ::sal_Int32 nOffset, ::sal_Int32 nScanSize ) throw (css::uno::RuntimeException)
{
    mxImageConsumer->setPixelsByLongs( nX, nY, nWidth, nHeight, aProducerData, nOffset, nScanSize );
}
void VCLXProxy::complete( ::sal_Int32 Status, const css::uno::Reference< css::awt::XImageProducer >& xProducer ) throw (css::uno::RuntimeException)
{
    mxImageConsumer->complete( Status, xProducer );
}

// awt::XButton
void VCLXProxy::addActionListener( const css::uno::Reference< css::awt::XActionListener >& l ) throw (css::uno::RuntimeException)
{
    mxButton->addActionListener( l );
}
void VCLXProxy::removeActionListener( const css::uno::Reference< css::awt::XActionListener >& l ) throw (css::uno::RuntimeException)
{
    mxButton->removeActionListener( l );
}
void VCLXProxy::setLabel( const ::rtl::OUString& Label ) throw (css::uno::RuntimeException)
{
    if ( mxButton.is() )
        mxButton->setLabel( Label );
}
void VCLXProxy::setActionCommand( const ::rtl::OUString& Command ) throw (css::uno::RuntimeException)
{
    mxButton->setActionCommand( Command );
}

// awt::XItemEventBroadcaster
void VCLXProxy::addItemListener( const css::uno::Reference< css::awt::XItemListener >& l ) throw (css::uno::RuntimeException)
{
    if ( mxItemEventBroadcaster.is() )
        mxItemEventBroadcaster->addItemListener( l );
}
void VCLXProxy::removeItemListener( const css::uno::Reference< css::awt::XItemListener >& l ) throw (css::uno::RuntimeException)
{
    if ( mxItemEventBroadcaster.is() )
        mxItemEventBroadcaster->removeItemListener( l );
}
