/*************************************************************************
 *
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER.
 * 
 * Copyright 2008 by Sun Microsystems, Inc.
 *
 * OpenOffice.org - a multi-platform office productivity suite
 *
 * $RCSfile: xcpoly.hxx,v $
 * $Revision: 1.3 $
 *
 * This file is part of OpenOffice.org.
 *
 * OpenOffice.org is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License version 3
 * only, as published by the Free Software Foundation.
 *
 * OpenOffice.org is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License version 3 for more details
 * (a copy is included in the LICENSE file that accompanied this code).
 *
 * You should have received a copy of the GNU Lesser General Public License
 * version 3 along with OpenOffice.org.  If not, see
 * <http://www.openoffice.org/license.html>
 * for a copy of the LGPLv3 License.
 *
 ************************************************************************/

#ifndef _XCPOLY_HXX
#define _XCPOLY_HXX


enum XCPolyEdge { EDGE_LEFT, EDGE_TOP, EDGE_RIGHT, EDGE_BOTTOM };


/*************************************************************************
|*
|* Klasse XClipPolygon; Clippt ein Polygon an einem Rechteck
|*
\************************************************************************/

class XClipPolygon
{
	private:
	Polygon		aInPoly;
	PolyPolygon	aInPolyPoly;
	Rectangle	aRect;


	protected:
	BOOL	Inside(const Point& rPoint, XCPolyEdge eEdge);
	Point	Intersect(const Point& rPoint1, const Point& rPoint2, XCPolyEdge eEdge);
	Polygon	ClipEdge(const Polygon& rPoly, XCPolyEdge eEdge);


	public:
	XClipPolygon(const Polygon& rPoly, const Rectangle& rRect)
		: 	aInPoly(rPoly),
			aRect(rRect) {};
	XClipPolygon(const PolyPolygon& rPolyPoly, const Rectangle& rRect)
		: 	aInPolyPoly(rPolyPoly),
			aRect(rRect) {};
	~XClipPolygon() {};

	Polygon 		GetClippedPolygon();
};


/*************************************************************************
|*
|* Klasse XClipPolyPolygon; Clippt ein PolyPolygon an einem Rechteck
|*
\************************************************************************/

class XClipPolyPolygon
{
	private:
	PolyPolygon	aInPolyPoly;
	Rectangle	aRect;


	public:
	XClipPolyPolygon(const PolyPolygon& rPolyPoly, const Rectangle& rRect)
		: 	aInPolyPoly(rPolyPoly),
			aRect(rRect) {};
	~XClipPolyPolygon() {};

	PolyPolygon	GetClippedPolyPolygon();
};




#endif		// _XCPOLY_HXX
