/*************************************************************************
 *
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER.
 * 
 * Copyright 2008 by Sun Microsystems, Inc.
 *
 * OpenOffice.org - a multi-platform office productivity suite
 *
 * $RCSfile: viewobjectcontactofsdrmediaobj.hxx,v $
 * $Revision: 1.8 $
 *
 * This file is part of OpenOffice.org.
 *
 * OpenOffice.org is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License version 3
 * only, as published by the Free Software Foundation.
 *
 * OpenOffice.org is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License version 3 for more details
 * (a copy is included in the LICENSE file that accompanied this code).
 *
 * You should have received a copy of the GNU Lesser General Public License
 * version 3 along with OpenOffice.org.  If not, see
 * <http://www.openoffice.org/license.html>
 * for a copy of the LGPLv3 License.
 *
 ************************************************************************/

#ifndef _SDR_CONTACT_VIEWOBJECTCONTACTOFSDRMEDIAOBJ_HXX
#define _SDR_CONTACT_VIEWOBJECTCONTACTOFSDRMEDIAOBJ_HXX

#include <svx/sdr/contact/viewobjectcontact.hxx>

namespace avmedia { class MediaItem; }
class Window;

namespace sdr
{
	namespace contact
	{
		class SdrMediaWindow;
	
		class ViewObjectContactOfSdrMediaObj : public ViewObjectContact
		{
		public:
			
			ViewObjectContactOfSdrMediaObj( ObjectContact& rObjectContact, 
											ViewContact& rViewContact,
											const ::avmedia::MediaItem& rMediaItem );

			// The destructor. When PrepareDelete() was not called before (see there)
			// warnings will be generated in debug version if there are still contacts
			// existing.
			virtual ~ViewObjectContactOfSdrMediaObj();
		
		public:
		
			Window*	getWindow() const;

			bool	hasPreferredSize() const;
			Size	getPreferredSize() const;

			void	updateMediaItem( ::avmedia::MediaItem& rItem ) const;
			void	executeMediaItem( const ::avmedia::MediaItem& rItem );

			// #i72701#
			void checkMediaWindowPosition(DisplayInfo& rDisplayInfo) const;

		protected:

			// Prepare deletion of this object. This needs to be called always
			// before really deleting this objects. This is necessary since in a c++
			// destructor no virtual function calls are allowed. To avoid this problem,
			// it is required to first call PrepareDelete().
			virtual void PrepareDelete();

			// Paint this object. This is before evtl. SubObjects get painted. This method
			// needs to set the flag mbIsPainted and to set the
			// maPaintedRectangle member. This information is later used for invalidates
			// and repaints.
			virtual void PaintObject(DisplayInfo& rDisplayInfo);
		
		private:
		
			::sdr::contact::SdrMediaWindow*	mpMediaWindow;
		};
	} // end of namespace contact
} // end of namespace sdr

//////////////////////////////////////////////////////////////////////////////

#endif // _SDR_CONTACT_VIEWOBJECTCONTACTOFSDRMEDIAOBJ_HXX
