#ifdef __MINGW32__
#define _GDI32_
#include "macros.h"
#include <multimon.h>
extern "C" {
extern HMODULE hModuleUnicowsDLL;
}

EXTERN_C void WINAPI ResolveThunk_UNICOWS( FARPROC *lppfn, LPCSTR lpLibFileName, LPCSTR lpFuncName, FARPROC lpfnFailure )
{
	FARPROC	lpfnResult = (((LONG)GetVersion()&0x800000ff) == 0x80000004) ? GetProcAddress( hModuleUnicowsDLL, lpFuncName ) : GetProcAddress( LoadLibraryA( lpLibFileName ), lpFuncName );

	if ( !lpfnResult )
		lpfnResult = lpfnFailure;

	*lppfn = lpfnResult;
}

static void GetProcAddress_Thunk();
EXTERN_C { _declspec( dllexport ) FARPROC kernel32_GetProcAddress_Ptr = (FARPROC)GetProcAddress_Thunk; }
static FARPROC WINAPI GetProcAddress_Failure (HINSTANCE,LPCSTR);
static void GetProcAddress_Thunk()
{
	ResolveThunk_UNICOWS( &kernel32_GetProcAddress_Ptr, "kernel32.dll", "GetProcAddress", (FARPROC)GetProcAddress_Failure );
	asm("	movl	%ebp, %esp");
	asm("	popl	%ebp");
	asm("	jmp	*(%0)"::"m"(kernel32_GetProcAddress_Ptr));
}
EXTERN_C FARPROC WINAPI Internal_GetProcAddress (HINSTANCE,LPCSTR)
{
	asm("	popl	%ebp");
	asm("	jmp	*(%0)"::"m"(kernel32_GetProcAddress_Ptr));
}
static FARPROC WINAPI GetProcAddress_Failure (HINSTANCE,LPCSTR)
{
	SetLastError( ERROR_CALL_NOT_IMPLEMENTED );
	return (FARPROC)0;
}

#define DEFINE_UNICOWS_THUNK( module, rettype, calltype, func, params ) \
static void func##_Thunk(); \
EXTERN_C { _declspec( dllexport ) FARPROC module##_##func##_Ptr = (FARPROC)func##_Thunk; } \
static rettype calltype func##_##Failure params; \
static void func##_Thunk() \
{ \
	ResolveThunk_UNICOWS( &module##_##func##_Ptr, #module ".dll", #func, (FARPROC)func##_##Failure ); \
	asm("	movl	%ebp, %esp"); \
	asm("	popl	%ebp"); \
	asm("	jmp	*(%0)"::"m"(module##_##func##_Ptr)); \
} \
EXTERN_C rettype calltype func params \
{ \
	asm("	popl	%ebp"); \
	asm("	jmp	*(%0)"::"m"(module##_##func##_Ptr)); \
} \
static rettype calltype func##_##Failure params \
{ \
	SetLastError( ERROR_CALL_NOT_IMPLEMENTED ); \
	return (rettype)0; \
}

DEFINE_UNICOWS_THUNK( kernel32, ATOM, WINAPI, AddAtomW, (LPCWSTR) )
DEFINE_UNICOWS_THUNK( gdi32, int, WINAPI, AddFontResourceW, (LPCWSTR) )
DEFINE_UNICOWS_THUNK( winspool, BOOL, WINAPI, AddJobW, (HANDLE,DWORD,PBYTE,DWORD,PDWORD) )
DEFINE_UNICOWS_THUNK( winspool, BOOL, WINAPI, AddPortW, (LPWSTR,HWND,LPWSTR) )
DEFINE_UNICOWS_THUNK( winspool, BOOL, WINAPI, AddPrintProcessorW, (LPWSTR,LPWSTR,LPWSTR,LPWSTR) )
DEFINE_UNICOWS_THUNK( winspool, BOOL, WINAPI, AddPrintProvidorW, (LPWSTR,DWORD,PBYTE) )
DEFINE_UNICOWS_THUNK( winspool, BOOL, WINAPI, AddPrinterDriverW, (LPWSTR,DWORD,PBYTE) )
DEFINE_UNICOWS_THUNK( winspool, HANDLE, WINAPI, AddPrinterW, (LPWSTR,DWORD,PBYTE) )
DEFINE_UNICOWS_THUNK( winspool, LONG, WINAPI, AdvancedDocumentPropertiesW, (HWND,HANDLE,LPWSTR,PDEVMODE,PDEVMODEW) )
DEFINE_UNICOWS_THUNK( user32, BOOL, WINAPI, AppendMenuW, (HMENU,UINT,UINT_PTR,LPCWSTR) )
DEFINE_UNICOWS_THUNK( kernel32, HANDLE, WINAPI, BeginUpdateResourceW, (LPCWSTR,BOOL) )
DEFINE_UNICOWS_THUNK( user32, long, WINAPI, BroadcastSystemMessageW, (DWORD,LPDWORD,UINT,WPARAM,LPARAM) )
DEFINE_UNICOWS_THUNK( kernel32, BOOL, WINAPI, BuildCommDCBAndTimeoutsW, (LPCWSTR,LPDCB,LPCOMMTIMEOUTS) )
DEFINE_UNICOWS_THUNK( kernel32, BOOL, WINAPI, BuildCommDCBW, (LPCWSTR,LPDCB) )
DEFINE_UNICOWS_THUNK( user32, BOOL, WINAPI, CallMsgFilterW, (LPMSG,int) )
DEFINE_UNICOWS_THUNK( kernel32, BOOL, WINAPI, CallNamedPipeW, (LPCWSTR,PVOID,DWORD,PVOID,DWORD,PDWORD,DWORD) )
DEFINE_UNICOWS_THUNK( user32, LRESULT, WINAPI, CallWindowProcA, (WNDPROC,HWND,UINT,WPARAM,LPARAM) )
DEFINE_UNICOWS_THUNK( user32, LRESULT, WINAPI, CallWindowProcW, (WNDPROC,HWND,UINT,WPARAM,LPARAM) )
DEFINE_UNICOWS_THUNK( user32, LONG, WINAPI, ChangeDisplaySettingsExW, (LPCWSTR,LPDEVMODEW,HWND,DWORD,LPVOID) )
DEFINE_UNICOWS_THUNK( user32, LONG, WINAPI, ChangeDisplaySettingsW, (PDEVMODEW,DWORD) )
DEFINE_UNICOWS_THUNK( user32, BOOL, WINAPI, ChangeMenuW, (HMENU,UINT,LPCWSTR,UINT,UINT) )
DEFINE_UNICOWS_THUNK( user32, DWORD, WINAPI, CharLowerBuffW, (LPWSTR,DWORD) )
DEFINE_UNICOWS_THUNK( user32, LPWSTR, WINAPI, CharLowerW, (LPWSTR) )
DEFINE_UNICOWS_THUNK( user32, LPWSTR, WINAPI, CharNextW, (LPCWSTR) )
DEFINE_UNICOWS_THUNK( user32, LPWSTR, WINAPI, CharPrevW, (LPCWSTR,LPCWSTR) )
DEFINE_UNICOWS_THUNK( user32, BOOL, WINAPI, CharToOemBuffW, (LPCWSTR,LPSTR,DWORD) )
DEFINE_UNICOWS_THUNK( user32, BOOL, WINAPI, CharToOemW, (LPCWSTR,LPSTR) )
DEFINE_UNICOWS_THUNK( user32, DWORD, WINAPI, CharUpperBuffW, (LPWSTR,DWORD) )
DEFINE_UNICOWS_THUNK( user32, LPWSTR, WINAPI, CharUpperW, (LPWSTR) )
DEFINE_UNICOWS_THUNK( comdlg32, BOOL, WINAPI, ChooseColorW, (LPCHOOSECOLORW) )
DEFINE_UNICOWS_THUNK( comdlg32, BOOL, WINAPI, ChooseFontW, (LPCHOOSEFONTW) )
DEFINE_UNICOWS_THUNK( kernel32, BOOL, WINAPI, CommConfigDialogW, (LPCWSTR,HWND,LPCOMMCONFIG) )
DEFINE_UNICOWS_THUNK( kernel32, int, WINAPI, CompareStringW, (LCID,DWORD,LPCWSTR,int,LPCWSTR,int) )
DEFINE_UNICOWS_THUNK( winspool, BOOL, WINAPI, ConfigurePortW, (LPWSTR,HWND,LPWSTR) )
DEFINE_UNICOWS_THUNK( user32, int, WINAPI, CopyAcceleratorTableW, (HACCEL,LPACCEL,int) )
DEFINE_UNICOWS_THUNK( gdi32, HENHMETAFILE, WINAPI, CopyEnhMetaFileW, (HENHMETAFILE,LPCWSTR) )
//DEFINE_UNICOWS_THUNK( kernel32, BOOL, WINAPI, CopyFileExW, (LPCWSTR,LPCWSTR,LPPROGRESS_ROUTINE,LPVOID,LPBOOL,DWORD) )
DEFINE_UNICOWS_THUNK( kernel32, BOOL, WINAPI, CopyFileW, (LPCWSTR,LPCWSTR,BOOL) )
DEFINE_UNICOWS_THUNK( gdi32, HMETAFILE, WINAPI, CopyMetaFileW, (HMETAFILE,LPCWSTR) )
DEFINE_UNICOWS_THUNK( user32, HACCEL, WINAPI, CreateAcceleratorTableW, (LPACCEL,int) )
DEFINE_UNICOWS_THUNK( gdi32, HCOLORSPACE, WINAPI, CreateColorSpaceW, (LPLOGCOLORSPACEW) )
DEFINE_UNICOWS_THUNK( gdi32, HDC, WINAPI, CreateDCW, (LPCWSTR,LPCWSTR,LPCWSTR,const DEVMODEW*) )
DEFINE_UNICOWS_THUNK( user32, HWND, WINAPI, CreateDialogIndirectParamW, (HINSTANCE,LPCDLGTEMPLATE,HWND,DLGPROC,LPARAM) )
DEFINE_UNICOWS_THUNK( user32, HWND, WINAPI, CreateDialogParamW, (HINSTANCE,LPCWSTR,HWND,DLGPROC,LPARAM) )
DEFINE_UNICOWS_THUNK( kernel32, BOOL, WINAPI, CreateDirectoryExW, (LPCWSTR,LPCWSTR,LPSECURITY_ATTRIBUTES) )
DEFINE_UNICOWS_THUNK( kernel32, BOOL, WINAPI, CreateDirectoryW, (LPCWSTR,LPSECURITY_ATTRIBUTES) )
DEFINE_UNICOWS_THUNK( gdi32, HDC, WINAPI, CreateEnhMetaFileW, (HDC,LPCWSTR,LPCRECT,LPCWSTR) )
DEFINE_UNICOWS_THUNK( kernel32, HANDLE, WINAPI, CreateEventW, (LPSECURITY_ATTRIBUTES,BOOL,BOOL,LPCWSTR) )
DEFINE_UNICOWS_THUNK( kernel32, HANDLE, WINAPI, CreateFileMappingW, (HANDLE,LPSECURITY_ATTRIBUTES,DWORD,DWORD,DWORD,LPCWSTR) )
DEFINE_UNICOWS_THUNK( kernel32, HANDLE, WINAPI, CreateFileW, (LPCWSTR,DWORD,DWORD,LPSECURITY_ATTRIBUTES,DWORD,DWORD,HANDLE) )
DEFINE_UNICOWS_THUNK( gdi32, HFONT, WINAPI, CreateFontIndirectW, (const LOGFONTW*) )
DEFINE_UNICOWS_THUNK( gdi32, HFONT, WINAPI, CreateFontW, (int,int,int,int,int,DWORD,DWORD,DWORD,DWORD,DWORD,DWORD,DWORD,DWORD,LPCWSTR) )
DEFINE_UNICOWS_THUNK( gdi32, HDC, WINAPI, CreateICW, (LPCWSTR,LPCWSTR,LPCWSTR,const DEVMODEW*) )
DEFINE_UNICOWS_THUNK( user32, HWND, WINAPI, CreateMDIWindowW, (LPCWSTR,LPCWSTR,DWORD,int,int,int,int,HWND,HINSTANCE,LPARAM) )
DEFINE_UNICOWS_THUNK( kernel32, HANDLE, WINAPI, CreateMailslotW, (LPCWSTR,DWORD,DWORD,LPSECURITY_ATTRIBUTES) )
DEFINE_UNICOWS_THUNK( gdi32, HDC, WINAPI, CreateMetaFileW, (LPCWSTR) )
DEFINE_UNICOWS_THUNK( kernel32, HANDLE, WINAPI, CreateMutexW, (LPSECURITY_ATTRIBUTES,BOOL,LPCWSTR) )
DEFINE_UNICOWS_THUNK( kernel32, BOOL, WINAPI, CreateProcessW, (LPCWSTR,LPWSTR,LPSECURITY_ATTRIBUTES,LPSECURITY_ATTRIBUTES,BOOL,DWORD,PVOID,LPCWSTR,LPSTARTUPINFOW,LPPROCESS_INFORMATION) )
DEFINE_UNICOWS_THUNK( gdi32, BOOL, WINAPI, CreateScalableFontResourceW, (DWORD,LPCWSTR,LPCWSTR,LPCWSTR) )
DEFINE_UNICOWS_THUNK( kernel32, HANDLE, WINAPI, CreateSemaphoreW, (LPSECURITY_ATTRIBUTES,LONG,LONG,LPCWSTR) )
DEFINE_UNICOWS_THUNK( oeacc, HRESULT, STDAPICALLTYPE, CreateStdAccessibleProxyW, (HWND, LPCWSTR, LONG, REFIID, void**) )
DEFINE_UNICOWS_THUNK( kernel32, HANDLE, WINAPI, CreateWaitableTimerW, (LPSECURITY_ATTRIBUTES,BOOL,LPCWSTR) )
DEFINE_UNICOWS_THUNK( user32, HWND, WINAPI, CreateWindowExW, (DWORD,LPCWSTR,LPCWSTR,DWORD,int,int,int,int,HWND,HMENU,HINSTANCE,LPVOID) )
DEFINE_UNICOWS_THUNK( user32, HCONV, WINAPI, DdeConnect, (DWORD,HSZ,HSZ,PCONVCONTEXT) )
DEFINE_UNICOWS_THUNK( user32, HCONVLIST, WINAPI, DdeConnectList, (DWORD,HSZ,HSZ,HCONVLIST,PCONVCONTEXT) )
DEFINE_UNICOWS_THUNK( user32, HSZ, WINAPI, DdeCreateStringHandleW, (DWORD,LPCWSTR,int) )
DEFINE_UNICOWS_THUNK( user32, UINT, WINAPI, DdeInitializeW, (PDWORD,PFNCALLBACK,DWORD,DWORD) )
DEFINE_UNICOWS_THUNK( user32, UINT, WINAPI, DdeQueryConvInfo, (HCONV,DWORD,PCONVINFO) )
DEFINE_UNICOWS_THUNK( user32, DWORD, WINAPI, DdeQueryStringW, (DWORD,HSZ,LPWSTR,DWORD,int) )
DEFINE_UNICOWS_THUNK( user32, LRESULT, WINAPI, DefDlgProcW, (HWND,UINT,WPARAM,LPARAM) )
DEFINE_UNICOWS_THUNK( user32, LRESULT, WINAPI, DefFrameProcW, (HWND,HWND,UINT,WPARAM,LPARAM) )
DEFINE_UNICOWS_THUNK( user32, LRESULT, WINAPI, DefMDIChildProcW, (HWND,UINT,WPARAM,LPARAM) )
DEFINE_UNICOWS_THUNK( user32, LRESULT, WINAPI, DefWindowProcW, (HWND,UINT,WPARAM,LPARAM) )
DEFINE_UNICOWS_THUNK( kernel32, BOOL, WINAPI, DeleteFileW, (LPCWSTR) )
DEFINE_UNICOWS_THUNK( winspool, BOOL, WINAPI, DeleteMonitorW, (LPWSTR,LPWSTR,LPWSTR) )
DEFINE_UNICOWS_THUNK( winspool, BOOL, WINAPI, DeletePortW, (LPWSTR,HWND,LPWSTR) )
DEFINE_UNICOWS_THUNK( winspool, BOOL, WINAPI, DeletePrintProcessorW, (LPWSTR,LPWSTR,LPWSTR) )
DEFINE_UNICOWS_THUNK( winspool, BOOL, WINAPI, DeletePrintProvidorW, (LPWSTR,LPWSTR,LPWSTR) )
DEFINE_UNICOWS_THUNK( winspool, BOOL, WINAPI, DeletePrinterDriverW, (LPWSTR,LPWSTR,LPWSTR) )
DEFINE_UNICOWS_THUNK( user32, int, WINAPI, DialogBoxIndirectParamW, (HINSTANCE,LPCDLGTEMPLATE,HWND,DLGPROC,LPARAM) )
DEFINE_UNICOWS_THUNK( user32, int, WINAPI, DialogBoxParamW, (HINSTANCE,LPCWSTR,HWND,DLGPROC,LPARAM) )
DEFINE_UNICOWS_THUNK( user32, LONG, WINAPI, DispatchMessageW, (const MSG*) )
DEFINE_UNICOWS_THUNK( user32, int, WINAPI, DlgDirListComboBoxW, (HWND,LPWSTR,int,int,UINT) )
DEFINE_UNICOWS_THUNK( user32, int, WINAPI, DlgDirListW, (HWND,LPWSTR,int,int,UINT) )
DEFINE_UNICOWS_THUNK( user32, BOOL, WINAPI, DlgDirSelectComboBoxExW, (HWND,LPWSTR,int,int) )
DEFINE_UNICOWS_THUNK( user32, BOOL, WINAPI, DlgDirSelectExW, (HWND,LPWSTR,int,int) )
DEFINE_UNICOWS_THUNK( shell32, UINT, WINAPI, DragQueryFileW, (HDROP,UINT,LPWSTR,UINT) )
//DEFINE_UNICOWS_THUNK( user32, BOOL, WINAPI, DrawStateW, (HDC,HBRUSH,DRAWSTATEPROC,LPARAM,WPARAM,int,int,int,int,UINT) )
DEFINE_UNICOWS_THUNK( user32, int, WINAPI, DrawTextExW, (HDC,LPWSTR,int,LPRECT,UINT,LPDRAWTEXTPARAMS) )
DEFINE_UNICOWS_THUNK( user32, int, WINAPI, DrawTextW, (HDC,LPCWSTR,int,LPRECT,UINT) )
DEFINE_UNICOWS_THUNK( user32, BOOL, WINAPI, EnableWindow, (HWND,BOOL) )
DEFINE_UNICOWS_THUNK( kernel32, BOOL, WINAPI, EndUpdateResourceW, (HANDLE,BOOL) )
DEFINE_UNICOWS_THUNK( kernel32, BOOL, WINAPI, EnumCalendarInfoExW, (CALINFO_ENUMPROCEXW,LCID,CALID,CALTYPE) )
DEFINE_UNICOWS_THUNK( kernel32, BOOL, WINAPI, EnumCalendarInfoW, (CALINFO_ENUMPROCW,LCID,CALID,CALTYPE) )
DEFINE_UNICOWS_THUNK( user32, UINT, WINAPI, EnumClipboardFormats, (UINT) )
DEFINE_UNICOWS_THUNK( kernel32, BOOL, WINAPI, EnumDateFormatsExW, (DATEFMT_ENUMPROCEXW,LCID,DWORD) )
DEFINE_UNICOWS_THUNK( kernel32, BOOL, WINAPI, EnumDateFormatsW, (DATEFMT_ENUMPROCW,LCID,DWORD) )
DEFINE_UNICOWS_THUNK( user32, BOOL, WINAPI, EnumDisplayDevicesW, (LPCWSTR,DWORD,PDISPLAY_DEVICEW,DWORD) )
DEFINE_UNICOWS_THUNK( user32, BOOL, WINAPI, EnumDisplaySettingsExW, (LPCWSTR,DWORD,LPDEVMODEW,DWORD) )
DEFINE_UNICOWS_THUNK( user32, BOOL, WINAPI, EnumDisplaySettingsW, (LPCWSTR,DWORD,PDEVMODEW) )
DEFINE_UNICOWS_THUNK( gdi32, int, WINAPI, EnumFontFamiliesExW, (HDC,PLOGFONTW,FONTENUMPROCW,LPARAM,DWORD) )
DEFINE_UNICOWS_THUNK( gdi32, int, WINAPI, EnumFontFamiliesW, (HDC,LPCWSTR,FONTENUMPROCW,LPARAM) )
DEFINE_UNICOWS_THUNK( gdi32, int, WINAPI, EnumFontsW, (HDC,LPCWSTR,FONTENUMPROCW,LPARAM) )
DEFINE_UNICOWS_THUNK( gdi32, int, WINAPI, EnumICMProfilesW, (HDC,ICMENUMPROCW,LPARAM) )
DEFINE_UNICOWS_THUNK( user32, int, WINAPI, EnumPropsA, (HWND,PROPENUMPROCA) )
DEFINE_UNICOWS_THUNK( user32, int, WINAPI, EnumPropsExA, (HWND,PROPENUMPROCEXA,LPARAM) )
DEFINE_UNICOWS_THUNK( user32, int, WINAPI, EnumPropsExW, (HWND,PROPENUMPROCEXW,LPARAM) )
DEFINE_UNICOWS_THUNK( user32, int, WINAPI, EnumPropsW, (HWND,PROPENUMPROCW) )
DEFINE_UNICOWS_THUNK( kernel32, BOOL, WINAPI, EnumSystemCodePagesW, (CODEPAGE_ENUMPROCW,DWORD) )
DEFINE_UNICOWS_THUNK( kernel32, BOOL, WINAPI, EnumSystemLocalesW, (LOCALE_ENUMPROCW,DWORD) )
DEFINE_UNICOWS_THUNK( kernel32, BOOL, WINAPI, EnumTimeFormatsW, (TIMEFMT_ENUMPROCW,LCID,DWORD) )
DEFINE_UNICOWS_THUNK( kernel32, DWORD, WINAPI, ExpandEnvironmentStringsW, (LPCWSTR,LPWSTR,DWORD) )
DEFINE_UNICOWS_THUNK( gdi32, BOOL, WINAPI, ExtTextOutW, (HDC,int,int,UINT,LPCRECT,LPCWSTR,UINT,const INT*) )
DEFINE_UNICOWS_THUNK( shell32, UINT, WINAPI, ExtractIconExW, (LPCWSTR,int,HICON*,HICON*,UINT) )
DEFINE_UNICOWS_THUNK( shell32, HICON, WINAPI, ExtractIconW, (HINSTANCE,LPCWSTR,UINT) )
DEFINE_UNICOWS_THUNK( kernel32, void, WINAPI, FatalAppExitW, (UINT,LPCWSTR) )
DEFINE_UNICOWS_THUNK( kernel32, BOOL, WINAPI, FillConsoleOutputCharacterW, (HANDLE,WCHAR,DWORD,COORD,PDWORD) )
DEFINE_UNICOWS_THUNK( kernel32, ATOM, WINAPI, FindAtomW, (LPCWSTR) )
DEFINE_UNICOWS_THUNK( kernel32, HANDLE, WINAPI, FindFirstChangeNotificationW, (LPCWSTR,BOOL,DWORD) )
DEFINE_UNICOWS_THUNK( kernel32, HANDLE, WINAPI, FindFirstFileW, (LPCWSTR,LPWIN32_FIND_DATAW) )
DEFINE_UNICOWS_THUNK( kernel32, BOOL, WINAPI, FindNextFileW, (HANDLE,LPWIN32_FIND_DATAW) )
DEFINE_UNICOWS_THUNK( kernel32, HRSRC, WINAPI, FindResourceExW, (HINSTANCE,LPCWSTR,LPCWSTR,WORD) )
DEFINE_UNICOWS_THUNK( kernel32, HRSRC, WINAPI, FindResourceW, (HINSTANCE,LPCWSTR,LPCWSTR) )
DEFINE_UNICOWS_THUNK( comdlg32, HWND, WINAPI, FindTextW, (LPFINDREPLACEW) )
DEFINE_UNICOWS_THUNK( user32, HWND, WINAPI, FindWindowExW, (HWND,HWND,LPCWSTR,LPCWSTR) )
DEFINE_UNICOWS_THUNK( user32, HWND, WINAPI, FindWindowW, (LPCWSTR,LPCWSTR) )
DEFINE_UNICOWS_THUNK( kernel32, DWORD, WINAPI, FormatMessageW, (DWORD,PCVOID,DWORD,DWORD,LPWSTR,DWORD,va_list*) )
DEFINE_UNICOWS_THUNK( kernel32, BOOL, WINAPI, FreeEnvironmentStringsW, (LPWSTR) )
DEFINE_UNICOWS_THUNK( kernel32, BOOL, WINAPI, FtpCreateDirectoryW, (HANDLE,LPCWSTR) )
DEFINE_UNICOWS_THUNK( kernel32, BOOL, WINAPI, FtpDeleteFileW, (HANDLE,LPCWSTR) )
DEFINE_UNICOWS_THUNK( kernel32, HANDLE, WINAPI, FtpFindFirstFileW, (HANDLE,LPCWSTR,LPWIN32_FIND_DATA,DWORD,DWORD) )
DEFINE_UNICOWS_THUNK( kernel32, BOOL, WINAPI, FtpGetCurrentDirectoryW, (HANDLE,LPWSTR,PDWORD) )
DEFINE_UNICOWS_THUNK( kernel32, BOOL, WINAPI, FtpRemoveDirectoryW, (HANDLE,LPCWSTR) )
DEFINE_UNICOWS_THUNK( kernel32, BOOL, WINAPI, FtpSetCurrentDirectoryW, (HANDLE,LPCWSTR) )
DEFINE_UNICOWS_THUNK( user32, BOOL, WINAPI, GetAltTabInfoW, (HWND,int,PALTTABINFO,LPWSTR,UINT) )
DEFINE_UNICOWS_THUNK( kernel32, UINT, WINAPI, GetAtomNameW, (ATOM,LPWSTR,int) )
DEFINE_UNICOWS_THUNK( kernel32, BOOL, WINAPI, GetCPInfo, (UINT,LPCPINFO) )
DEFINE_UNICOWS_THUNK( kernel32, BOOL, WINAPI, GetCPInfoExA, (UINT,DWORD,LPCPINFOEXA) )
DEFINE_UNICOWS_THUNK( kernel32, BOOL, WINAPI, GetCPInfoExW, (UINT,DWORD,LPCPINFOEXW) )
DEFINE_UNICOWS_THUNK( kernel32, int, WINAPI, GetCalendarInfoW, (LCID,CALID,CALTYPE,LPWSTR,int,LPDWORD) )
DEFINE_UNICOWS_THUNK( gdi32, BOOL, WINAPI, GetCharABCWidthsW, (HDC,UINT,UINT,LPABC) )
DEFINE_UNICOWS_THUNK( gdi32, BOOL, WINAPI, GetCharWidthFloatW, (HDC,UINT,UINT,PFLOAT) )
DEFINE_UNICOWS_THUNK( gdi32, BOOL, WINAPI, GetCharWidthW, (HDC,UINT,UINT,LPINT) )
DEFINE_UNICOWS_THUNK( gdi32, DWORD, WINAPI, GetCharacterPlacementW, (HDC,LPCWSTR,int,int,LPGCP_RESULTSW,DWORD) )
DEFINE_UNICOWS_THUNK( user32, BOOL, WINAPI, GetClassInfoExW, (HINSTANCE,LPCWSTR,LPWNDCLASSEXW) )
DEFINE_UNICOWS_THUNK( user32, BOOL, WINAPI, GetClassInfoW, (HINSTANCE,LPCWSTR,LPWNDCLASSW) )
DEFINE_UNICOWS_THUNK( user32, DWORD, WINAPI, GetClassLongW, (HWND,int) )
DEFINE_UNICOWS_THUNK( user32, int, WINAPI, GetClassNameW, (HWND,LPWSTR,int) )
DEFINE_UNICOWS_THUNK( user32, HANDLE, WINAPI, GetClipboardData, (UINT) )
DEFINE_UNICOWS_THUNK( user32, int, WINAPI, GetClipboardFormatNameW, (UINT,LPWSTR,int) )
DEFINE_UNICOWS_THUNK( kernel32, BOOL, WINAPI, GetComputerNameW, (LPWSTR,PDWORD) )
DEFINE_UNICOWS_THUNK( kernel32, DWORD, WINAPI, GetConsoleTitleW, (LPWSTR,DWORD) )
DEFINE_UNICOWS_THUNK( kernel32, int, WINAPI, GetCurrencyFormatW, (LCID,DWORD,LPCWSTR,const CURRENCYFMTW*,LPWSTR,int) )
DEFINE_UNICOWS_THUNK( kernel32, DWORD, WINAPI, GetCurrentDirectoryW, (DWORD,LPWSTR) )
DEFINE_UNICOWS_THUNK( advapi32, BOOL, WINAPI, GetCurrentHwProfileW, (LPHW_PROFILE_INFOW) )
DEFINE_UNICOWS_THUNK( kernel32, int, WINAPI, GetDateFormatW, (LCID,DWORD,const SYSTEMTIME*,LPCWSTR,LPWSTR,int) )
DEFINE_UNICOWS_THUNK( kernel32, BOOL, WINAPI, GetDefaultCommConfigW, (LPCWSTR,LPCOMMCONFIG,PDWORD) )
//DEFINE_UNICOWS_THUNK( kernel32, BOOL, WINAPI, GetDiskFreeSpaceExW, (LPCWSTR,PULARGE_INTEGER,PULARGE_INTEGER,PULARGE_INTEGER) )
DEFINE_UNICOWS_THUNK( kernel32, BOOL, WINAPI, GetDiskFreeSpaceW, (LPCWSTR,PDWORD,PDWORD,PDWORD,PDWORD) )
DEFINE_UNICOWS_THUNK( user32, UINT, WINAPI, GetDlgItemTextW, (HWND,int,LPWSTR,int) )
DEFINE_UNICOWS_THUNK( kernel32, UINT, WINAPI, GetDriveTypeW, (LPCWSTR) )
DEFINE_UNICOWS_THUNK( gdi32, UINT, WINAPI, GetEnhMetaFileDescriptionW, (HENHMETAFILE,UINT,LPWSTR) )
DEFINE_UNICOWS_THUNK( gdi32, HENHMETAFILE, WINAPI, GetEnhMetaFileW, (LPCWSTR) )
DEFINE_UNICOWS_THUNK( kernel32, LPWSTR, WINAPI, GetEnvironmentStringsW, (void) )
DEFINE_UNICOWS_THUNK( kernel32, DWORD, WINAPI, GetEnvironmentVariableW, (LPCWSTR,LPWSTR,DWORD) )
DEFINE_UNICOWS_THUNK( kernel32, BOOL, WINAPI, GetFileAttributesExW, (LPCWSTR,GET_FILEEX_INFO_LEVELS,PVOID) )
DEFINE_UNICOWS_THUNK( kernel32, DWORD, WINAPI, GetFileAttributesW, (LPCWSTR) )
DEFINE_UNICOWS_THUNK( comdlg32, short, WINAPI, GetFileTitleW, (LPCWSTR,LPWSTR,WORD) )
DEFINE_UNICOWS_THUNK( version, DWORD, WINAPI, GetFileVersionInfoSizeW, (LPWSTR,PDWORD) )
DEFINE_UNICOWS_THUNK( version, BOOL, WINAPI, GetFileVersionInfoW, (LPWSTR,DWORD,DWORD,PVOID) )
DEFINE_UNICOWS_THUNK( kernel32, DWORD, WINAPI, GetFullPathNameW, (LPCWSTR,DWORD,LPWSTR,LPWSTR*) )
DEFINE_UNICOWS_THUNK( gdi32, DWORD, WINAPI, GetGlyphOutlineW, (HDC,UINT,UINT,LPGLYPHMETRICS,DWORD,PVOID,const MAT2*) )
DEFINE_UNICOWS_THUNK( gdi32, BOOL, WINAPI, GetICMProfileW, (HDC,LPDWORD,LPWSTR) )
DEFINE_UNICOWS_THUNK( gdi32, DWORD, WINAPI, GetKerningPairsW, (HDC,DWORD,LPKERNINGPAIR) )
DEFINE_UNICOWS_THUNK( user32, int, WINAPI, GetKeyNameTextW, (LONG,LPWSTR,int) )
DEFINE_UNICOWS_THUNK( user32, BOOL, WINAPI, GetKeyboardLayoutNameW, (LPWSTR) )
DEFINE_UNICOWS_THUNK( kernel32, int, WINAPI, GetLocaleInfoW, (LCID,LCTYPE,LPWSTR,int) )
DEFINE_UNICOWS_THUNK( gdi32, BOOL, WINAPI, GetLogColorSpaceW, (HCOLORSPACE,LPLOGCOLORSPACEW,DWORD) )
//DEFINE_UNICOWS_THUNK( kernel32, DWORD, WINAPI, GetLogicalDriveStringsW, (DWORD,LPWSTR) )
//DEFINE_UNICOWS_THUNK( kernel32, DWORD, WINAPI, GetLongPathNameW, (LPCWSTR,LPWSTR,DWORD) )
DEFINE_UNICOWS_THUNK( user32, BOOL, WINAPI, GetMenuItemInfoW, (HMENU,UINT,BOOL,LPMENUITEMINFOW) )
DEFINE_UNICOWS_THUNK( user32, int, WINAPI, GetMenuStringW, (HMENU,UINT,LPWSTR,int,UINT) )
DEFINE_UNICOWS_THUNK( user32, BOOL, WINAPI, GetMessageW, (LPMSG,HWND,UINT,UINT) )
DEFINE_UNICOWS_THUNK( gdi32, HMETAFILE, WINAPI, GetMetaFileW, (LPCWSTR) )
DEFINE_UNICOWS_THUNK( kernel32, DWORD, WINAPI, GetModuleFileNameW, (HINSTANCE,LPWSTR,DWORD) )
DEFINE_UNICOWS_THUNK( kernel32, HMODULE, WINAPI, GetModuleHandleW, (LPCWSTR) )
DEFINE_UNICOWS_THUNK( user32, BOOL, WINAPI, GetMonitorInfoW, (HMONITOR,LPMONITORINFO) )
DEFINE_UNICOWS_THUNK( kernel32, BOOL, WINAPI, GetNamedPipeHandleStateW, (HANDLE,PDWORD,PDWORD,PDWORD,PDWORD,LPWSTR,DWORD) )
DEFINE_UNICOWS_THUNK( kernel32, int, WINAPI, GetNumberFormatW, (LCID,DWORD,LPCWSTR,const NUMBERFMTW*,LPWSTR,int) )
DEFINE_UNICOWS_THUNK( gdi32, int, WINAPI, GetObjectW, (HGDIOBJ,int,PVOID) )
DEFINE_UNICOWS_THUNK( msvfw32, BOOL, WINAPI, GetOpenFileNamePreviewW, (LPOPENFILENAMEW) )
DEFINE_UNICOWS_THUNK( comdlg32, BOOL, WINAPI, GetOpenFileNameW, (LPOPENFILENAMEW) )
DEFINE_UNICOWS_THUNK( gdi32, UINT, WINAPI, GetOutlineTextMetricsW, (HDC,UINT,LPOUTLINETEXTMETRICW) )
DEFINE_UNICOWS_THUNK( winspool, DWORD, WINAPI, GetPrintProcessorDirectoryW, (LPWSTR,LPWSTR,DWORD,PBYTE,DWORD,PDWORD) )
DEFINE_UNICOWS_THUNK( kernel32, UINT, WINAPI, GetPrivateProfileIntW, (LPCWSTR,LPCWSTR,INT,LPCWSTR) )
DEFINE_UNICOWS_THUNK( kernel32, DWORD, WINAPI, GetPrivateProfileSectionNamesW, (LPWSTR,DWORD,LPCWSTR) )
DEFINE_UNICOWS_THUNK( kernel32, DWORD, WINAPI, GetPrivateProfileSectionW, (LPCWSTR,LPWSTR,DWORD,LPCWSTR) )
DEFINE_UNICOWS_THUNK( kernel32, DWORD, WINAPI, GetPrivateProfileStringW, (LPCWSTR,LPCWSTR,LPCWSTR,LPWSTR,DWORD,LPCWSTR) )
DEFINE_UNICOWS_THUNK( kernel32, BOOL, WINAPI, GetPrivateProfileStructW, (LPCWSTR,LPCWSTR,LPVOID,UINT,LPCWSTR) )
DEFINE_UNICOWS_THUNK( kernel32, UINT, WINAPI, GetProfileIntW, (LPCWSTR,LPCWSTR,INT) )
DEFINE_UNICOWS_THUNK( kernel32, DWORD, WINAPI, GetProfileSectionW, (LPCWSTR,LPWSTR,DWORD) )
DEFINE_UNICOWS_THUNK( kernel32, DWORD, WINAPI, GetProfileStringW, (LPCWSTR,LPCWSTR,LPCWSTR,LPWSTR,DWORD) )
DEFINE_UNICOWS_THUNK( user32, HANDLE, WINAPI, GetPropA, (HWND,LPCSTR) )
DEFINE_UNICOWS_THUNK( user32, HANDLE, WINAPI, GetPropW, (HWND,LPCWSTR) )
DEFINE_UNICOWS_THUNK( oleacc, UINT, WINAPI, GetRoleTextW, (DWORD,LPWSTR,UINT) )
DEFINE_UNICOWS_THUNK( msvfw32, BOOL, WINAPI, GetSaveFileNamePreviewW, (LPOPENFILENAMEW) )
DEFINE_UNICOWS_THUNK( comdlg32, BOOL, WINAPI, GetSaveFileNameW, (LPOPENFILENAMEW) )
DEFINE_UNICOWS_THUNK( kernel32, DWORD, WINAPI, GetShortPathNameW, (LPCWSTR,LPWSTR,DWORD) )
DEFINE_UNICOWS_THUNK( kernel32, VOID, WINAPI, GetStartupInfoW, (LPSTARTUPINFOW) )
DEFINE_UNICOWS_THUNK( oleacc, UINT, WINAPI, GetStateTextW, (DWORD,LPWSTR,UINT) )
DEFINE_UNICOWS_THUNK( kernel32, BOOL, WINAPI, GetStringTypeExW, (LCID,DWORD,LPCWSTR,int,LPWORD) )
DEFINE_UNICOWS_THUNK( kernel32, BOOL, WINAPI, GetStringTypeW, (DWORD,LPCWSTR,int,LPWORD) )
DEFINE_UNICOWS_THUNK( kernel32, UINT, WINAPI, GetSystemDirectoryW, (LPWSTR,UINT) )
DEFINE_UNICOWS_THUNK( kernel32, UINT, WINAPI, GetSystemWindowsDirectoryW, (LPWSTR,UINT) )
DEFINE_UNICOWS_THUNK( user32, DWORD, WINAPI, GetTabbedTextExtentW, (HDC,LPCWSTR,int,int,LPINT) )
DEFINE_UNICOWS_THUNK( kernel32, UINT, WINAPI, GetTempFileNameW, (LPCWSTR,LPCWSTR,UINT,LPWSTR) )
DEFINE_UNICOWS_THUNK( kernel32, DWORD, WINAPI, GetTempPathW, (DWORD,LPWSTR) )
DEFINE_UNICOWS_THUNK( gdi32, BOOL, WINAPI, GetTextExtentExPointW, ( HDC,LPCWSTR,int,int,LPINT,LPINT,LPSIZE ) )
DEFINE_UNICOWS_THUNK( gdi32, BOOL, WINAPI, GetTextExtentPoint32W, ( HDC,LPCWSTR,int,LPSIZE) )
DEFINE_UNICOWS_THUNK( gdi32, BOOL, WINAPI, GetTextExtentPointW, (HDC,LPCWSTR,int,LPSIZE) )
DEFINE_UNICOWS_THUNK( gdi32, int, WINAPI, GetTextFaceW, (HDC,int,LPWSTR) )
DEFINE_UNICOWS_THUNK( gdi32, BOOL, WINAPI, GetTextMetricsW, (HDC,LPTEXTMETRICW) )
DEFINE_UNICOWS_THUNK( kernel32, int, WINAPI, GetTimeFormatW, (LCID,DWORD,const SYSTEMTIME*,LPCWSTR,LPWSTR,int) )
DEFINE_UNICOWS_THUNK( advapi32, BOOL, WINAPI, GetUserNameW, (LPWSTR,PDWORD) )
DEFINE_UNICOWS_THUNK( kernel32, BOOL, WINAPI, GetVersionExW, (LPOSVERSIONINFOW) )
DEFINE_UNICOWS_THUNK( kernel32, BOOL, WINAPI, GetVolumeInformationW, (LPCWSTR,LPWSTR,DWORD,PDWORD,PDWORD,PDWORD,LPWSTR,DWORD) )
DEFINE_UNICOWS_THUNK( user32, LONG, WINAPI, GetWindowLongA, (HWND,int) )
DEFINE_UNICOWS_THUNK( user32, LONG, WINAPI, GetWindowLongW, (HWND,int) )
DEFINE_UNICOWS_THUNK( user32, UINT, WINAPI, GetWindowModuleFileNameW, (HWND,LPWSTR,UINT) )
DEFINE_UNICOWS_THUNK( user32, int, WINAPI, GetWindowTextLengthW, (HWND) )
DEFINE_UNICOWS_THUNK( user32, int, WINAPI, GetWindowTextW, (HWND,LPWSTR,int) )
DEFINE_UNICOWS_THUNK( kernel32, UINT, WINAPI, GetWindowsDirectoryW, (LPWSTR,UINT) )
DEFINE_UNICOWS_THUNK( kernel32, ATOM, WINAPI, GlobalAddAtomW, ( LPCWSTR) )
DEFINE_UNICOWS_THUNK( kernel32, ATOM, WINAPI, GlobalFindAtomW, (LPCWSTR) )
DEFINE_UNICOWS_THUNK( kernel32, UINT, WINAPI, GlobalGetAtomNameW, (ATOM,LPWSTR,int) )
DEFINE_UNICOWS_THUNK( kernel32, HANDLE, WINAPI, GopherFindFirstFileW, (HANDLE,LPCWSTR,LPCWSTR,LPVOID,DWORD,DWORD) )
DEFINE_UNICOWS_THUNK( user32, BOOL, WINAPI, GrayStringW, (HDC,HBRUSH,GRAYSTRINGPROC,LPARAM,int,int,int,int,int) )
DEFINE_UNICOWS_THUNK( user32, HANDLE, WINAPI, ImageList_LoadImageW, (HINSTANCE,LPCWSTR,int,int,COLORREF,UINT,UINT) )
DEFINE_UNICOWS_THUNK( user32, BOOL, WINAPI, InsertMenuItemW, (HMENU,UINT,BOOL,LPCMENUITEMINFOW) )
DEFINE_UNICOWS_THUNK( user32, BOOL, WINAPI, InsertMenuW, (HMENU,UINT,UINT,UINT,LPCWSTR) )
DEFINE_UNICOWS_THUNK( user32, BOOL, WINAPI, InternetFindNextFileW, (HANDLE,PVOID) )
DEFINE_UNICOWS_THUNK( kernel32, BOOL, WINAPI, IsBadStringPtrW, (LPCWSTR,UINT) )
DEFINE_UNICOWS_THUNK( user32, BOOL, WINAPI, IsCharAlphaNumericW, (WCHAR) )
DEFINE_UNICOWS_THUNK( user32, BOOL, WINAPI, IsCharAlphaW, (WCHAR) )
DEFINE_UNICOWS_THUNK( user32, BOOL, WINAPI, IsCharLowerW, (WCHAR) )
DEFINE_UNICOWS_THUNK( user32, BOOL, WINAPI, IsCharUpperW, (WCHAR) )
DEFINE_UNICOWS_THUNK( user32, BOOL, WINAPI, IsClipboardFormatAvailable, (UINT) )
DEFINE_UNICOWS_THUNK( sensapi, BOOL, APIENTRY, IsDestinationReachableW, (LPCWSTR,LPVOID) )
DEFINE_UNICOWS_THUNK( user32, BOOL, WINAPI, IsDialogMessageW, (HWND,LPMSG) )
DEFINE_UNICOWS_THUNK( advapi32, BOOL, WINAPI, IsTextUnicode, (PCVOID,int,LPINT) )
DEFINE_UNICOWS_THUNK( kernel32, BOOL, WINAPI, IsValidCodePage, (UINT) )
DEFINE_UNICOWS_THUNK( user32, BOOL, WINAPI, IsWindowUnicode, (HWND) )
DEFINE_UNICOWS_THUNK( kernel32, int, WINAPI, LCMapStringW, (LCID,DWORD,LPCWSTR,int,LPWSTR,int) )
DEFINE_UNICOWS_THUNK( user32, HACCEL, WINAPI, LoadAcceleratorsW, (HINSTANCE,LPCWSTR) )
DEFINE_UNICOWS_THUNK( user32, HBITMAP, WINAPI, LoadBitmapW, (HINSTANCE,LPCWSTR) )
DEFINE_UNICOWS_THUNK( user32, HCURSOR, WINAPI, LoadCursorFromFileW, (LPCWSTR) )
DEFINE_UNICOWS_THUNK( user32, HCURSOR, WINAPI, LoadCursorW, (HINSTANCE,LPCWSTR) )
DEFINE_UNICOWS_THUNK( user32, HICON, WINAPI, LoadIconW, (HINSTANCE,LPCWSTR) )
DEFINE_UNICOWS_THUNK( user32, HANDLE, WINAPI, LoadImageW, (HINSTANCE,LPCWSTR,UINT,int,int,UINT) )
DEFINE_UNICOWS_THUNK( user32, HKL, WINAPI, LoadKeyboardLayoutW, (LPCWSTR,UINT) )
DEFINE_UNICOWS_THUNK( kernel32, HINSTANCE, WINAPI, LoadLibraryExW, (LPCWSTR,HANDLE,DWORD) )
DEFINE_UNICOWS_THUNK( kernel32, HINSTANCE, WINAPI, LoadLibraryW, (LPCWSTR) )
DEFINE_UNICOWS_THUNK( user32, HMENU, WINAPI, LoadMenuIndirectW, (const MENUTEMPLATE*) )
DEFINE_UNICOWS_THUNK( user32, HMENU, WINAPI, LoadMenuW, (HINSTANCE,LPCWSTR) )
DEFINE_UNICOWS_THUNK( user32, int, WINAPI, LoadStringW, (HINSTANCE,UINT,LPWSTR,int) )
DEFINE_UNICOWS_THUNK( user32, HINSTANCE, WINAPI, MLLoadLibraryW, (LPCWSTR,HANDLE,DWORD,LPCWSTR,BOOL) )
DEFINE_UNICOWS_THUNK( user32, UINT, WINAPI, MapVirtualKeyExW, (UINT,UINT,HKL) )
DEFINE_UNICOWS_THUNK( user32, UINT, WINAPI, MapVirtualKeyW, (UINT,UINT) )
DEFINE_UNICOWS_THUNK( user32, int, WINAPI, MessageBoxExW, (HWND,LPCWSTR,LPCWSTR,UINT,WORD) )
DEFINE_UNICOWS_THUNK( user32, int, WINAPI, MessageBoxIndirectW, (CONST MSGBOXPARAMSW*) )
DEFINE_UNICOWS_THUNK( user32, int, WINAPI, MessageBoxW, (HWND,LPCWSTR,LPCWSTR,UINT) )
DEFINE_UNICOWS_THUNK( user32, BOOL, WINAPI, ModifyMenuW, (HMENU,UINT,UINT,UINT,LPCWSTR) )
DEFINE_UNICOWS_THUNK( kernel32, BOOL, WINAPI, MoveFileW, (LPCWSTR,LPCWSTR) )
DEFINE_UNICOWS_THUNK( kernel32, int, WINAPI, MultiByteToWideChar, (UINT,DWORD,LPCSTR,int,LPWSTR,int) )
DEFINE_UNICOWS_THUNK( mpr, DWORD, APIENTRY, MultinetGetConnectionPerformanceW, (LPNETRESOURCEW,LPNETCONNECTINFOSTRUCT) )
DEFINE_UNICOWS_THUNK( user32, BOOL, WINAPI, OemToCharBuffW, (LPCSTR,LPWSTR,DWORD) )
DEFINE_UNICOWS_THUNK( user32, BOOL, WINAPI, OemToCharW, (LPCSTR,LPWSTR) )
DEFINE_UNICOWS_THUNK( kernel32, HANDLE, WINAPI, OpenEventW, (DWORD,BOOL,LPCWSTR) )
DEFINE_UNICOWS_THUNK( kernel32, HANDLE, WINAPI, OpenFileMappingW, (DWORD,BOOL,LPCWSTR) )
DEFINE_UNICOWS_THUNK( kernel32, HANDLE, WINAPI, OpenMutexW, (DWORD,BOOL,LPCWSTR) )
DEFINE_UNICOWS_THUNK( winspool, BOOL, WINAPI, OpenPrinterW, (LPWSTR,PHANDLE,LPPRINTER_DEFAULTSW) )
DEFINE_UNICOWS_THUNK( kernel32, HANDLE, WINAPI, OpenSemaphoreW, (DWORD,BOOL,LPCWSTR) )
DEFINE_UNICOWS_THUNK( kernel32, HANDLE, WINAPI, OpenWaitableTimerW, (DWORD,BOOL,LPCWSTR) )
DEFINE_UNICOWS_THUNK( kernel32, void, WINAPI, OutputDebugStringW, (LPCWSTR) )
DEFINE_UNICOWS_THUNK( comdlg32, BOOL, WINAPI, PageSetupDlgW, (LPPAGESETUPDLGW) )
DEFINE_UNICOWS_THUNK( kernel32, BOOL, WINAPI, PeekConsoleInputW, (HANDLE,PINPUT_RECORD,DWORD,PDWORD) )
DEFINE_UNICOWS_THUNK( user32, BOOL, WINAPI, PeekMessageW, (LPMSG,HWND,UINT,UINT,UINT) )
DEFINE_UNICOWS_THUNK( winmm, BOOL, WINAPI, PlaySoundW, (LPCWSTR,HMODULE,DWORD) )
DEFINE_UNICOWS_THUNK( gdi32, BOOL, WINAPI, PolyTextOutW, (HDC,const POLYTEXTW*,int) )
DEFINE_UNICOWS_THUNK( user32, BOOL, WINAPI, PostMessageW, (HWND,UINT,WPARAM,LPARAM) )
DEFINE_UNICOWS_THUNK( user32, BOOL, WINAPI, PostThreadMessageW, (DWORD,UINT,WPARAM,LPARAM) )
DEFINE_UNICOWS_THUNK( comdlg32, BOOL, WINAPI, PrintDlgW, (LPPRINTDLGW) )
DEFINE_UNICOWS_THUNK( comdlg32, DWORD, WINAPI, PrinterMessageBoxW, (HANDLE,DWORD,HWND,LPWSTR,LPWSTR,DWORD) )
DEFINE_UNICOWS_THUNK( kernel32, DWORD, WINAPI, QueryDosDeviceW, (LPCWSTR,LPWSTR,DWORD) )
DEFINE_UNICOWS_THUNK( rasapi32, DWORD, APIENTRY, RasConnectionNotificationW, (HANDLE, HANDLE, DWORD) )
DEFINE_UNICOWS_THUNK( rasapi32, DWORD, APIENTRY, RasCreatePhonebookEntryW, (HWND, LPCWSTR) )
DEFINE_UNICOWS_THUNK( rasapi32, DWORD, APIENTRY, RasDeleteEntryW, (LPCWSTR, LPCWSTR) )
DEFINE_UNICOWS_THUNK( rasapi32, DWORD, APIENTRY, RasDeleteSubEntryW, (LPCWSTR, LPCWSTR, DWORD) )
DEFINE_UNICOWS_THUNK( rasapi32, DWORD, APIENTRY, RasEditPhonebookEntryW, (HWND, LPCWSTR, LPCWSTR) )
DEFINE_UNICOWS_THUNK( rasapi32, DWORD, APIENTRY, RasEnumConnectionsW, (LPVOID, LPDWORD, LPDWORD) )
DEFINE_UNICOWS_THUNK( rasapi32, DWORD, APIENTRY, RasEnumDevicesW, (LPVOID, LPDWORD, LPDWORD) )
DEFINE_UNICOWS_THUNK( rasapi32, DWORD, APIENTRY, RasEnumEntriesW, (LPCWSTR, LPCWSTR, LPVOID, LPDWORD, LPDWORD) )
DEFINE_UNICOWS_THUNK( rasapi32, DWORD, APIENTRY, RasGetConnectStatusW, (HANDLE, LPVOID) )
DEFINE_UNICOWS_THUNK( rasapi32, DWORD, APIENTRY, RasGetEntryDialParamsW, (LPCWSTR, LPVOID, LPBOOL) )
DEFINE_UNICOWS_THUNK( rasapi32, DWORD, APIENTRY, RasGetEntryPropertiesW, (LPCWSTR, LPCWSTR, LPVOID, LPDWORD, LPBYTE, LPDWORD) )
DEFINE_UNICOWS_THUNK( rasapi32, DWORD, APIENTRY, RasGetErrorStringW, (UINT, LPWSTR, DWORD) )
DEFINE_UNICOWS_THUNK( rasapi32, DWORD, APIENTRY, RasHangUpW, (HANDLE) )
DEFINE_UNICOWS_THUNK( rasapi32, DWORD, APIENTRY, RasRenameEntryW, (LPCWSTR, LPCWSTR, LPCWSTR) )
DEFINE_UNICOWS_THUNK( rasapi32, DWORD, APIENTRY, RasSetEntryDialParamsW, (LPCWSTR, LPVOID, BOOL) )
DEFINE_UNICOWS_THUNK( rasapi32, DWORD, APIENTRY, RasSetEntryPropertiesW, (LPCWSTR, LPCWSTR, LPVOID, DWORD, LPBYTE, DWORD) )
DEFINE_UNICOWS_THUNK( rasapi32, DWORD, APIENTRY, RasSetSubEntryPropertiesW, (LPCWSTR, LPCWSTR, DWORD, LPVOID, DWORD, LPBYTE, DWORD) )
DEFINE_UNICOWS_THUNK( rasapi32, DWORD, APIENTRY, RasValidateEntryNameW, (LPCWSTR, LPCWSTR) )
DEFINE_UNICOWS_THUNK( kernel32, BOOL, WINAPI, ReadConsoleInputW, (HANDLE,PINPUT_RECORD,DWORD,PDWORD) )
DEFINE_UNICOWS_THUNK( kernel32, BOOL, WINAPI, ReadConsoleOutputCharacterW, (HANDLE,LPWSTR,DWORD,COORD,PDWORD) )
DEFINE_UNICOWS_THUNK( kernel32, BOOL, WINAPI, ReadConsoleOutputW, (HANDLE,PCHAR_INFO,COORD,COORD,PSMALL_RECT) )
DEFINE_UNICOWS_THUNK( kernel32, BOOL, WINAPI, ReadConsoleW, (HANDLE,PVOID,DWORD,PDWORD,PVOID) )
DEFINE_UNICOWS_THUNK( advapi32, LONG, WINAPI, RegConnectRegistryW, (LPCWSTR,HKEY,PHKEY) )
DEFINE_UNICOWS_THUNK( advapi32, LONG, WINAPI, RegCreateKeyExW, (HKEY,LPCWSTR,DWORD,LPWSTR,DWORD,REGSAM,LPSECURITY_ATTRIBUTES,PHKEY,PDWORD) )
DEFINE_UNICOWS_THUNK( advapi32, LONG, WINAPI, RegCreateKeyW, (HKEY,LPCWSTR,PHKEY) )
DEFINE_UNICOWS_THUNK( advapi32, LONG, WINAPI, RegDeleteKeyW, (HKEY,LPCWSTR) )
DEFINE_UNICOWS_THUNK( advapi32, LONG, WINAPI, RegDeleteValueW, (HKEY,LPCWSTR) )
DEFINE_UNICOWS_THUNK( advapi32, LONG, WINAPI, RegEnumKeyExW, (HKEY,DWORD,LPWSTR,PDWORD,PDWORD,LPWSTR,PDWORD,PFILETIME) )
DEFINE_UNICOWS_THUNK( advapi32, LONG, WINAPI, RegEnumKeyW, (HKEY,DWORD,LPWSTR,DWORD) )
DEFINE_UNICOWS_THUNK( advapi32, LONG, WINAPI, RegEnumValueW, (HKEY,DWORD,LPWSTR,PDWORD,PDWORD,PDWORD,LPBYTE,PDWORD) )
DEFINE_UNICOWS_THUNK( advapi32, LONG, WINAPI, RegLoadKeyW, (HKEY,LPCWSTR,LPCWSTR) )
DEFINE_UNICOWS_THUNK( advapi32, LONG, WINAPI, RegOpenKeyExW, (HKEY,LPCWSTR,DWORD,REGSAM,PHKEY) )
DEFINE_UNICOWS_THUNK( advapi32, LONG, WINAPI, RegOpenKeyW, (HKEY,LPCWSTR,PHKEY) )
DEFINE_UNICOWS_THUNK( advapi32, LONG, WINAPI, RegQueryInfoKeyW, (HKEY,LPWSTR,PDWORD,PDWORD,PDWORD,PDWORD,PDWORD,PDWORD,PDWORD,PDWORD,PDWORD,PFILETIME) )
DEFINE_UNICOWS_THUNK( advapi32, LONG, WINAPI, RegQueryMultipleValuesW, (HKEY,PVALENTW,DWORD,LPWSTR,LPDWORD) )
DEFINE_UNICOWS_THUNK( advapi32, LONG, WINAPI, RegQueryValueExW, (HKEY,LPCWSTR,LPDWORD,LPDWORD,LPBYTE,LPDWORD) )
DEFINE_UNICOWS_THUNK( advapi32, LONG, WINAPI, RegQueryValueW, (HKEY,LPCWSTR,LPWSTR,PLONG) )
DEFINE_UNICOWS_THUNK( advapi32, LONG, WINAPI, RegReplaceKeyW, (HKEY,LPCWSTR,LPCWSTR,LPCWSTR) )
DEFINE_UNICOWS_THUNK( advapi32, LONG, WINAPI, RegSaveKeyW, (HKEY,LPCWSTR,LPSECURITY_ATTRIBUTES) )
DEFINE_UNICOWS_THUNK( advapi32, LONG, WINAPI, RegSetValueExW, (HKEY,LPCWSTR,DWORD,DWORD,const BYTE*,DWORD) )
DEFINE_UNICOWS_THUNK( advapi32, LONG, WINAPI, RegSetValueW, (HKEY,LPCWSTR,DWORD,LPCWSTR,DWORD) )
DEFINE_UNICOWS_THUNK( advapi32, LONG, WINAPI, RegUnLoadKeyW, (HKEY,LPCWSTR) )
DEFINE_UNICOWS_THUNK( user32, ATOM, WINAPI, RegisterClassExW, (CONST WNDCLASSEXW*) )
DEFINE_UNICOWS_THUNK( user32, ATOM, WINAPI, RegisterClassW, (CONST WNDCLASSW*) )
DEFINE_UNICOWS_THUNK( user32, UINT, WINAPI, RegisterClipboardFormatW, (LPCWSTR) )
DEFINE_UNICOWS_THUNK( user32, HDEVNOTIFY, WINAPI, RegisterDeviceNotificationW, (HANDLE,LPVOID,DWORD) )
DEFINE_UNICOWS_THUNK( user32, UINT, WINAPI, RegisterWindowMessageW, (LPCWSTR) )
DEFINE_UNICOWS_THUNK( kernel32, BOOL, WINAPI, RemoveDirectoryW, (LPCWSTR) )
DEFINE_UNICOWS_THUNK( gdi32, BOOL, WINAPI, RemoveFontResourceW, (LPCWSTR) )
DEFINE_UNICOWS_THUNK( user32, HANDLE, WINAPI, RemovePropA, (HWND,LPCSTR) )
DEFINE_UNICOWS_THUNK( user32, HANDLE, WINAPI, RemovePropW, (HWND,LPCWSTR) )
DEFINE_UNICOWS_THUNK( comdlg32, HWND, WINAPI, ReplaceTextW, (LPFINDREPLACEW) )
DEFINE_UNICOWS_THUNK( gdi32, HDC, WINAPI, ResetDCW, (HDC,const DEVMODEW*) )
DEFINE_UNICOWS_THUNK( shell32, LPVOID, WINAPI, SHBrowseForFolderW, (LPVOID) )
DEFINE_UNICOWS_THUNK( shell32, void, WINAPI, SHChangeNotify, (LONG,UINT,PCVOID,PCVOID) )
DEFINE_UNICOWS_THUNK( shell32, INT, WINAPI, SHCreateDirectoryExW, (HWND,LPCWSTR,LPSECURITY_ATTRIBUTES) )
DEFINE_UNICOWS_THUNK( shell32, int, WINAPI, SHFileOperationW, (LPSHFILEOPSTRUCTW) )
DEFINE_UNICOWS_THUNK( shell32, DWORD, WINAPI, SHGetFileInfoW, (LPCWSTR,DWORD,SHFILEINFOW*,UINT,UINT) )
DEFINE_UNICOWS_THUNK( shell32, BOOL, WINAPI, SHGetNewLinkInfoW, (LPCWSTR,DWORD,SHFILEINFOW*,UINT,UINT) )
DEFINE_UNICOWS_THUNK( shell32, BOOL, WINAPI, SHGetPathFromIDListW, (LPVOID,LPWSTR) )
DEFINE_UNICOWS_THUNK( shell32, int, __stdcall, SQLGetPrivateProfileStringW, (LPCWSTR,LPCWSTR,LPCWSTR,LPWSTR,int,LPCWSTR) )
DEFINE_UNICOWS_THUNK( shell32, BOOL, __stdcall, SQLWritePrivateProfileStringW, (LPCWSTR,LPCWSTR,LPCWSTR,LPCWSTR) )
DEFINE_UNICOWS_THUNK( kernel32, BOOL, WINAPI, ScrollConsoleScreenBufferW, (HANDLE,const SMALL_RECT*,const SMALL_RECT*,COORD,const CHAR_INFO*) )
DEFINE_UNICOWS_THUNK( kernel32, DWORD, WINAPI, SearchPathW, (LPCWSTR,LPCWSTR,LPCWSTR,DWORD,LPWSTR,LPWSTR*) )
DEFINE_UNICOWS_THUNK( user32, LONG, WINAPI, SendDlgItemMessageW, (HWND,int,UINT,WPARAM,LPARAM) )
DEFINE_UNICOWS_THUNK( user32, BOOL, WINAPI, SendMessageCallbackW, (HWND,UINT,WPARAM,LPARAM,SENDASYNCPROC,DWORD) )
DEFINE_UNICOWS_THUNK( user32, LRESULT, WINAPI, SendMessageTimeoutW, (HWND,UINT,WPARAM,LPARAM,UINT,UINT,PDWORD) )
DEFINE_UNICOWS_THUNK( user32, LRESULT, WINAPI, SendMessageW, (HWND,UINT,WPARAM,LPARAM) )
DEFINE_UNICOWS_THUNK( user32, BOOL, WINAPI, SendNotifyMessageW, (HWND,UINT,WPARAM,LPARAM) )
DEFINE_UNICOWS_THUNK( kernel32, int, WINAPI, SetCalendarInfoW, (LCID,CALID,CALTYPE,LPCWSTR) )
DEFINE_UNICOWS_THUNK( user32, DWORD, WINAPI, SetClassLongW, (HWND,int,LONG) )
DEFINE_UNICOWS_THUNK( kernel32, BOOL, WINAPI, SetComputerNameW, (LPCWSTR) )
DEFINE_UNICOWS_THUNK( kernel32, BOOL, WINAPI, SetConsoleTitleW, (LPCWSTR) )
DEFINE_UNICOWS_THUNK( kernel32, BOOL, WINAPI, SetCurrentDirectoryW, (LPCWSTR) )
DEFINE_UNICOWS_THUNK( kernel32, BOOL, WINAPI, SetDefaultCommConfigW, (LPCWSTR,LPCOMMCONFIG,DWORD) )
DEFINE_UNICOWS_THUNK( user32, BOOL, WINAPI, SetDlgItemTextW, (HWND,int,LPCWSTR) )
DEFINE_UNICOWS_THUNK( kernel32, BOOL, WINAPI, SetEnvironmentVariableW, (LPCWSTR,LPCWSTR) )
DEFINE_UNICOWS_THUNK( kernel32, BOOL, WINAPI, SetFileAttributesW, (LPCWSTR,DWORD) )
DEFINE_UNICOWS_THUNK( gdi32, BOOL, WINAPI, SetICMProfileW, (HDC,LPWSTR) )
DEFINE_UNICOWS_THUNK( winspool, BOOL, WINAPI, SetJobW, (HANDLE,DWORD,DWORD,PBYTE,DWORD) )
DEFINE_UNICOWS_THUNK( kernel32, BOOL, WINAPI, SetLocaleInfoW, (LCID,LCTYPE,LPCWSTR) )
DEFINE_UNICOWS_THUNK( user32, BOOL, WINAPI, SetMenuItemInfoW, ( HMENU,UINT,BOOL,LPCMENUITEMINFOW) )
DEFINE_UNICOWS_THUNK( winspool, BOOL, WINAPI, SetPrinterDataW, (HANDLE,LPWSTR,DWORD,PBYTE,DWORD) )
DEFINE_UNICOWS_THUNK( winspool, BOOL, WINAPI, SetPrinterW, (HANDLE,DWORD,PBYTE,DWORD) )
DEFINE_UNICOWS_THUNK( user32, BOOL, WINAPI, SetPropA, (HWND,LPCSTR,HANDLE) )
DEFINE_UNICOWS_THUNK( user32, BOOL, WINAPI, SetPropW, (HWND,LPCWSTR,HANDLE) )
DEFINE_UNICOWS_THUNK( kernel32, BOOL, WINAPI, SetVolumeLabelW, (LPCWSTR,LPCWSTR) )
DEFINE_UNICOWS_THUNK( user32, LONG, WINAPI, SetWindowLongA, (HWND,int,LONG) )
DEFINE_UNICOWS_THUNK( user32, LONG, WINAPI, SetWindowLongW, (HWND,int,LONG) )
DEFINE_UNICOWS_THUNK( user32, BOOL, WINAPI, SetWindowTextW, (HWND,LPCWSTR) )
DEFINE_UNICOWS_THUNK( user32, HHOOK, WINAPI, SetWindowsHookExW, (int,HOOKPROC,HINSTANCE,DWORD) )
DEFINE_UNICOWS_THUNK( user32, HHOOK, WINAPI, SetWindowsHookW, (int,HOOKPROC) )
DEFINE_UNICOWS_THUNK( shell32, int, WINAPI, ShellAboutW, (HWND,LPCWSTR,LPCWSTR,HICON) )
DEFINE_UNICOWS_THUNK( shell32, BOOL, WINAPI, ShellExecuteExW, (LPSHELLEXECUTEINFOW) )
DEFINE_UNICOWS_THUNK( shell32, HINSTANCE, WINAPI, ShellExecuteW, (HWND,LPCWSTR,LPCWSTR,LPCWSTR,LPCWSTR,INT) )
DEFINE_UNICOWS_THUNK( shell32, BOOL, WINAPI, Shell_NotifyIconW, (DWORD,PNOTIFYICONDATAW) )
DEFINE_UNICOWS_THUNK( winspool, DWORD, WINAPI, StartDocPrinterW, (HANDLE,DWORD,PBYTE) )
DEFINE_UNICOWS_THUNK( gdi32, int, WINAPI, StartDocW, (HDC,const DOCINFOW*) )
DEFINE_UNICOWS_THUNK( user32, BOOL, WINAPI, SystemParametersInfoW, (UINT,UINT,PVOID,UINT) )
DEFINE_UNICOWS_THUNK( user32, LONG, WINAPI, TabbedTextOutW, (HDC,int,int,LPCWSTR,int,int,LPINT,int) )
DEFINE_UNICOWS_THUNK( gdi32, BOOL, WINAPI, TextOutW, (HDC,int,int,LPCWSTR,int) )
DEFINE_UNICOWS_THUNK( user32, int, WINAPI, TranslateAcceleratorW, (HWND,HACCEL,LPMSG) )
DEFINE_UNICOWS_THUNK( user32, BOOL, WINAPI, UnregisterClassW, (LPCWSTR,HINSTANCE) )
DEFINE_UNICOWS_THUNK( gdi32, BOOL, WINAPI, UpdateICMRegKeyW, (DWORD,LPWSTR,LPWSTR,UINT) )
DEFINE_UNICOWS_THUNK( kernel32, BOOL, WINAPI, UpdateResourceW, (HANDLE,LPCWSTR,LPCWSTR,WORD,PVOID,DWORD) )
DEFINE_UNICOWS_THUNK( version, DWORD, WINAPI, VerFindFileW, (DWORD,LPWSTR,LPWSTR,LPWSTR,LPWSTR,PUINT,LPWSTR,PUINT) )
DEFINE_UNICOWS_THUNK( version, DWORD, WINAPI, VerInstallFileW, (DWORD,LPWSTR,LPWSTR,LPWSTR,LPWSTR,LPWSTR,LPWSTR,PUINT) )
DEFINE_UNICOWS_THUNK( kernel32, DWORD, WINAPI, VerLanguageNameW, (DWORD,LPWSTR,DWORD) )
DEFINE_UNICOWS_THUNK( version, BOOL, WINAPI, VerQueryValueW, (const LPVOID,LPWSTR,LPVOID*,PUINT) )
DEFINE_UNICOWS_THUNK( user32, SHORT, WINAPI, VkKeyScanExW, (WCHAR,HKL) )
DEFINE_UNICOWS_THUNK( user32, SHORT, WINAPI, VkKeyScanW, (WCHAR) )
DEFINE_UNICOWS_THUNK( user32, DWORD, WINAPI, SetupDecompressOrCopyFileW, (PCWSTR,PCWSTR,PUINT) )
DEFINE_UNICOWS_THUNK( mpr, DWORD, APIENTRY, WNetAddConnection2W, (LPNETRESOURCEW,LPCWSTR,LPCWSTR,DWORD) )
DEFINE_UNICOWS_THUNK( mpr, DWORD, APIENTRY, WNetAddConnection3W, (HWND,LPNETRESOURCEW,LPCWSTR,LPCWSTR,DWORD) )
DEFINE_UNICOWS_THUNK( mpr, DWORD, APIENTRY, WNetAddConnectionW, (LPCWSTR,LPCWSTR,LPCWSTR) )
DEFINE_UNICOWS_THUNK( mpr, DWORD, APIENTRY, WNetCancelConnection2W, (LPCWSTR,DWORD,BOOL) )
DEFINE_UNICOWS_THUNK( mpr, DWORD, APIENTRY, WNetCancelConnectionW, (LPCWSTR,BOOL) )
DEFINE_UNICOWS_THUNK( mpr, DWORD, APIENTRY, WNetConnectionDialog1W, (LPCONNECTDLGSTRUCTW) )
DEFINE_UNICOWS_THUNK( mpr, DWORD, APIENTRY, WNetDisconnectDialog1W, (LPDISCDLGSTRUCTW) )
DEFINE_UNICOWS_THUNK( mpr, DWORD, APIENTRY, WNetEnumResourceW, (HANDLE,PDWORD,PVOID,PDWORD) )
DEFINE_UNICOWS_THUNK( mpr, DWORD, APIENTRY, WNetGetConnectionW, (LPCWSTR,LPWSTR,PDWORD) )
DEFINE_UNICOWS_THUNK( mpr, DWORD, APIENTRY, WNetGetLastErrorW, (PDWORD,LPWSTR,DWORD,LPWSTR,DWORD) )
DEFINE_UNICOWS_THUNK( mpr, DWORD, APIENTRY, WNetGetNetworkInformationW, (LPCWSTR,LPNETINFOSTRUCT) )
DEFINE_UNICOWS_THUNK( mpr, DWORD, APIENTRY, WNetGetProviderNameW, (DWORD,LPWSTR,PDWORD) )
DEFINE_UNICOWS_THUNK( mpr, DWORD, APIENTRY, WNetGetResourceInformationW, (LPNETRESOURCEW,LPVOID,LPDWORD,LPWSTR*) )
DEFINE_UNICOWS_THUNK( mpr, DWORD, APIENTRY, WNetGetResourceParentW, (LPNETRESOURCEW,LPVOID,LPDWORD) )
DEFINE_UNICOWS_THUNK( mpr, DWORD, APIENTRY, WNetGetUniversalNameW, (LPCWSTR,DWORD,PVOID,PDWORD) )
DEFINE_UNICOWS_THUNK( mpr, DWORD, APIENTRY, WNetGetUserW, (LPCWSTR,LPWSTR,PDWORD) )
DEFINE_UNICOWS_THUNK( mpr, DWORD, APIENTRY, WNetOpenEnumW, (DWORD,DWORD,DWORD,LPNETRESOURCEW,LPHANDLE) )
DEFINE_UNICOWS_THUNK( mpr, DWORD, APIENTRY, WNetUseConnectionW, (HWND,LPNETRESOURCEW,LPCWSTR,LPCWSTR,DWORD,LPWSTR,PDWORD,PDWORD) )
DEFINE_UNICOWS_THUNK( kernel32, BOOL, WINAPI, WaitNamedPipeW, (LPCWSTR,DWORD) )
DEFINE_UNICOWS_THUNK( kernel32, int, WINAPI, WideCharToMultiByte, (UINT,DWORD,LPCWSTR,int,LPSTR,int,LPCSTR,LPBOOL) )
DEFINE_UNICOWS_THUNK( user32, BOOL, WINAPI, WinHelpW, (HWND,LPCWSTR,UINT,DWORD) )
DEFINE_UNICOWS_THUNK( kernel32, BOOL, WINAPI, WriteConsoleInputW, (HANDLE,const INPUT_RECORD*,DWORD,PDWORD) )
DEFINE_UNICOWS_THUNK( kernel32, BOOL, WINAPI, WriteConsoleOutputCharacterW, (HANDLE,LPCWSTR,DWORD,COORD,PDWORD) )
DEFINE_UNICOWS_THUNK( kernel32, BOOL, WINAPI, WriteConsoleOutputW, (HANDLE,const CHAR_INFO*,COORD,COORD,PSMALL_RECT) )
DEFINE_UNICOWS_THUNK( kernel32, BOOL, WINAPI, WriteConsoleW, (HANDLE,PCVOID,DWORD,PDWORD,PVOID) )
DEFINE_UNICOWS_THUNK( kernel32, BOOL, WINAPI, WritePrivateProfileSectionW, (LPCWSTR,LPCWSTR,LPCWSTR) )
DEFINE_UNICOWS_THUNK( kernel32, BOOL, WINAPI, WritePrivateProfileStringW, (LPCWSTR,LPCWSTR,LPCWSTR,LPCWSTR) )
DEFINE_UNICOWS_THUNK( kernel32, BOOL, WINAPI, WritePrivateProfileStructW, (LPCWSTR,LPCWSTR,LPVOID,UINT,LPCWSTR) )
DEFINE_UNICOWS_THUNK( kernel32, BOOL, WINAPI, WriteProfileSectionW, (LPCWSTR,LPCWSTR) )
DEFINE_UNICOWS_THUNK( kernel32, BOOL, WINAPI, WriteProfileStringW, (LPCWSTR,LPCWSTR,LPCWSTR) )
DEFINE_UNICOWS_THUNK( avicap32, HWND, WINAPI, capCreateCaptureWindowW, (LPCWSTR, DWORD, int, int, int, int, HWND, int) )
DEFINE_UNICOWS_THUNK( avicap32, BOOL, WINAPI, capGetDriverDescriptionW, (UINT, LPWSTR, int, LPWSTR, int) )
DEFINE_UNICOWS_THUNK( kernel32, LPWSTR, WINAPI, lstrcatW, (LPWSTR,LPCWSTR) )
DEFINE_UNICOWS_THUNK( kernel32, int, WINAPI, lstrcmpW, (LPCWSTR,LPCWSTR) )
DEFINE_UNICOWS_THUNK( kernel32, int, WINAPI, lstrcmpiW, ( LPCWSTR,LPCWSTR) )
DEFINE_UNICOWS_THUNK( kernel32, LPWSTR, WINAPI, lstrcpyW, (LPWSTR,LPCWSTR) )
DEFINE_UNICOWS_THUNK( kernel32, LPWSTR, WINAPI, lstrcpynW, (LPWSTR,LPCWSTR,int) )
DEFINE_UNICOWS_THUNK( kernel32, int, WINAPI, lstrlenW, (LPCWSTR) )
DEFINE_UNICOWS_THUNK( winmm, BOOL, WINAPI, sndPlaySoundW, (LPCWSTR,UINT) )
DEFINE_UNICOWS_THUNK( winmm, PROC, WINAPI, wglGetProcAddress, (LPCSTR) )
DEFINE_UNICOWS_THUNK( user32, int, WINAPIV, wsprintfW, (LPWSTR,LPCWSTR,...) )
DEFINE_UNICOWS_THUNK( user32, int, WINAPI, wvsprintfW, (LPWSTR,LPCWSTR,va_list arglist) )
#endif
