/*
 * Decompiled with CFR 0.152.
 */
package sun.awt.X11;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Scrollbar;
import java.awt.event.AdjustmentEvent;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.awt.peer.ScrollbarPeer;
import java.util.logging.Level;
import java.util.logging.Logger;
import sun.awt.X11.XComponentPeer;
import sun.awt.X11.XCreateWindowParams;
import sun.awt.X11.XHorizontalScrollbar;
import sun.awt.X11.XScrollbar;
import sun.awt.X11.XScrollbarClient;
import sun.awt.X11.XVerticalScrollbar;

class XScrollbarPeer
extends XComponentPeer
implements ScrollbarPeer,
XScrollbarClient {
    private static final Logger log = Logger.getLogger("sun.awt.X11.XScrollbarPeer");
    private static final int DEFAULT_LENGTH = 50;
    private static final int DEFAULT_WIDTH_SOLARIS = 19;
    private static final int DEFAULT_WIDTH_LINUX = 15;
    XScrollbar tsb;

    public void preInit(XCreateWindowParams xCreateWindowParams) {
        super.preInit(xCreateWindowParams);
        Scrollbar scrollbar = (Scrollbar)this.target;
        this.tsb = scrollbar.getOrientation() == 1 ? new XVerticalScrollbar(this) : new XHorizontalScrollbar(this);
        int n = scrollbar.getMinimum();
        int n2 = scrollbar.getMaximum();
        int n3 = scrollbar.getVisibleAmount();
        int n4 = scrollbar.getValue();
        int n5 = scrollbar.getLineIncrement();
        int n6 = scrollbar.getPageIncrement();
        this.tsb.setValues(n4, n3, n, n2, n5, n6);
    }

    XScrollbarPeer(Scrollbar scrollbar) {
        super(scrollbar);
        this.target = scrollbar;
        this.xSetVisible(true);
    }

    private int getDefaultDimension() {
        if (System.getProperty("os.name").equals("Linux")) {
            return 15;
        }
        return 19;
    }

    public Dimension getMinimumSize() {
        Scrollbar scrollbar = (Scrollbar)this.target;
        return scrollbar.getOrientation() == 1 ? new Dimension(this.getDefaultDimension(), 50) : new Dimension(50, this.getDefaultDimension());
    }

    public void repaint() {
        Graphics graphics = this.getGraphics();
        if (graphics != null) {
            this.paint(graphics);
        }
    }

    public void paint(Graphics graphics) {
        Scrollbar scrollbar = (Scrollbar)this.target;
        Color[] colorArray = this.getGUIcolors();
        graphics.setColor(colorArray[0]);
        this.tsb.paint(graphics, colorArray, true);
    }

    public void repaintScrollbarRequest(XScrollbar xScrollbar) {
        this.repaint();
    }

    public void notifyValue(XScrollbar xScrollbar, int n, int n2, boolean bl) {
        Scrollbar scrollbar = (Scrollbar)this.target;
        scrollbar.setValue(n2);
        this.postEvent(new AdjustmentEvent(scrollbar, 601, n, n2, bl));
    }

    public void handleJavaMouseEvent(MouseEvent mouseEvent) {
        super.handleJavaMouseEvent(mouseEvent);
        int n = mouseEvent.getX();
        int n2 = mouseEvent.getY();
        int n3 = mouseEvent.getModifiers();
        int n4 = mouseEvent.getID();
        if ((mouseEvent.getModifiers() & 0x10) == 0) {
            return;
        }
        switch (mouseEvent.getID()) {
            case 501: {
                this.target.requestFocus();
                this.tsb.handleMouseEvent(n4, n3, n, n2);
                break;
            }
            case 502: {
                this.tsb.handleMouseEvent(n4, n3, n, n2);
                break;
            }
            case 506: {
                this.tsb.handleMouseEvent(n4, n3, n, n2);
            }
        }
    }

    public void handleJavaKeyEvent(KeyEvent keyEvent) {
        super.handleJavaKeyEvent(keyEvent);
        if (log.isLoggable(Level.FINEST)) {
            log.finer("KeyEvent on scrollbar: " + keyEvent);
        }
        if (!keyEvent.isConsumed() && keyEvent.getID() == 402) {
            switch (keyEvent.getKeyCode()) {
                case 38: {
                    log.finer("Scrolling up");
                    this.tsb.notifyValue(this.tsb.getValue() - this.tsb.getUnitIncrement());
                    break;
                }
                case 40: {
                    log.finer("Scrolling down");
                    this.tsb.notifyValue(this.tsb.getValue() + this.tsb.getUnitIncrement());
                    break;
                }
                case 37: {
                    log.finer("Scrolling up");
                    this.tsb.notifyValue(this.tsb.getValue() - this.tsb.getUnitIncrement());
                    break;
                }
                case 39: {
                    log.finer("Scrolling down");
                    this.tsb.notifyValue(this.tsb.getValue() + this.tsb.getUnitIncrement());
                    break;
                }
                case 33: {
                    log.finer("Scrolling page up");
                    this.tsb.notifyValue(this.tsb.getValue() - this.tsb.getBlockIncrement());
                    break;
                }
                case 34: {
                    log.finer("Scrolling page down");
                    this.tsb.notifyValue(this.tsb.getValue() + this.tsb.getBlockIncrement());
                    break;
                }
                case 36: {
                    log.finer("Scrolling to home");
                    this.tsb.notifyValue(0);
                    break;
                }
                case 35: {
                    log.finer("Scrolling to end");
                    this.tsb.notifyValue(this.tsb.getMaximum());
                }
            }
        }
    }

    public void setValue(int n) {
        this.tsb.setValue(n);
        this.repaint();
    }

    public void setValues(int n, int n2, int n3, int n4) {
        this.tsb.setValues(n, n2, n3, n4);
        this.repaint();
    }

    public void setLineIncrement(int n) {
        this.tsb.setUnitIncrement(n);
    }

    public void setPageIncrement(int n) {
        this.tsb.setBlockIncrement(n);
    }

    public void layout() {
        super.layout();
        this.tsb.setSize(this.width, this.height);
    }
}

