/*************************************************************************
 *
 *  OpenOffice.org - a multi-platform office productivity suite
 *
 *  $RCSfile: NodeImpl.hxx,v $
 *
 *  $Revision: 1.2 $
 *
 *  last change: $Author: hbrinkm $ $Date: 2006/11/01 09:14:35 $
 *
 *  The Contents of this file are made available subject to
 *  the terms of GNU Lesser General Public License Version 2.1.
 *
 *
 *    GNU Lesser General Public License Version 2.1
 *    =============================================
 *    Copyright 2005 by Sun Microsystems, Inc.
 *    901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License version 2.1, as published by the Free Software Foundation.
 *
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with this library; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *    MA  02111-1307  USA
 *
 ************************************************************************/

/*  Copyright 2005 Sun Microsystems, Inc. */

#ifndef INCLUDED_NODEIMPL_HXX
#define INCLUDED_NODEIMPL_HXX

#include <odiapi/core/Node.hxx>

#include <string>
#include <boost/shared_ptr.hpp>

namespace odiapi { namespace core {

    class NodeImpl : public Node
    {   
    public:
		NodeImpl(writerfilter::QName_t id, odiapi::props::PropertyPoolHandle_Pointer_t poolHandle, const std::string& text);

        virtual writerfilter::QName_t getId() const;
		virtual odiapi::props::PropertyPoolHandle_Pointer_t getProperties() const;
        virtual const std::string& getText() const;
		virtual void insertSibling(Node::Pointer_t sibling);
		virtual void appendChildren(Node::Pointer_t children);
        virtual bool hasPrevious() const;
        virtual const Node& getPrevious() const;
        virtual bool hasNext() const;
        virtual const Node& getNext() const;
        virtual const Node& getParent() const;
        virtual const Node& getFirstChild() const;
        virtual const Node& getLastChild() const;
        virtual Node* getNextSibling() const;
        virtual Node* getPrevSibling() const;

	private:
        bool hasChildren() const;
		NodeImpl* getLeftMostDescendant(NodeImpl* node) const;
        NodeImpl* getLastSibling(NodeImpl* node) const;

    private:
        writerfilter::QName_t mId;
		odiapi::props::PropertyPoolHandle_Pointer_t mPropertyPoolHandle;
        std::string mText;
        NodeImpl* mParent;
        NodeImpl* mNext;
        NodeImpl* mPrevious;
        NodeImpl* mNextSibling;
        NodeImpl* mPreviousSibling;
        NodeImpl* mFirstChild;
        NodeImpl* mLastChild;
    };

} } // namespace core {  namespace odiapi {

#endif // INCLUDED_NODEIMPL_HXX

