/*************************************************************************
 *
 *  OpenOffice.org - a multi-platform office productivity suite
 *
 *  $RCSfile: SwXMLSectionList.hxx,v $
 *
 *  $Revision: 1.5 $
 *
 *  last change: $Author: rt $ $Date: 2005/09/09 01:31:00 $
 *
 *  The Contents of this file are made available subject to
 *  the terms of GNU Lesser General Public License Version 2.1.
 *
 *
 *    GNU Lesser General Public License Version 2.1
 *    =============================================
 *    Copyright 2005 by Sun Microsystems, Inc.
 *    901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License version 2.1, as published by the Free Software Foundation.
 *
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with this library; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *    MA  02111-1307  USA
 *
 ************************************************************************/
#ifndef _SW_XMLSECTIONLIST_HXX
#define _SW_XMLSECTIONLIST_HXX

#ifndef _XMLOFF_XMLICTXT_HXX
#include <xmloff/xmlictxt.hxx>
#endif
#ifndef _XMLOFF_XMLIMP_HXX
#include <xmloff/xmlimp.hxx>
#endif

class SvStrings;

class SwXMLSectionList : public SvXMLImport
{
protected:
	// This method is called after the namespace map has been updated, but
	// before a context for the current element has been pushed.
	virtual SvXMLImportContext *CreateContext( sal_uInt16 nPrefix,
				  const ::rtl::OUString& rLocalName,
				  const ::com::sun::star::uno::Reference<
					::com::sun::star::xml::sax::XAttributeList > & xAttrList );
public:
	SvStrings & rSectionList;

	// #110680#
	SwXMLSectionList( 
		const ::com::sun::star::uno::Reference< ::com::sun::star::lang::XMultiServiceFactory > xServiceFactory,
		SvStrings & rNewSectionList );

	virtual ~SwXMLSectionList ( )
		throw();
};

class SvXMLSectionListContext : public SvXMLImportContext
{
private:
	SwXMLSectionList & rLocalRef;
public:
	SvXMLSectionListContext ( SwXMLSectionList& rImport,
						   sal_uInt16 nPrefix, 
						   const rtl::OUString& rLocalName,
						   const ::com::sun::star::uno::Reference< 
						   ::com::sun::star::xml::sax::XAttributeList > & xAttrList );
	virtual SvXMLImportContext *CreateChildContext( sal_uInt16 nPrefix,
						   const rtl::OUString& rLocalName,
						   const ::com::sun::star::uno::Reference< 
						   ::com::sun::star::xml::sax::XAttributeList > & xAttrList );
	~SvXMLSectionListContext ( void );
};

class SvXMLIgnoreSectionListContext : public SvXMLImportContext
{
private:
	SwXMLSectionList & rLocalRef;
public:
	SvXMLIgnoreSectionListContext ( SwXMLSectionList& rImport,
						   sal_uInt16 nPrefix, 
						   const rtl::OUString& rLocalName,
						   const ::com::sun::star::uno::Reference< 
						   ::com::sun::star::xml::sax::XAttributeList > & xAttrList );
	virtual SvXMLImportContext *CreateChildContext( sal_uInt16 nPrefix,
						   const rtl::OUString& rLocalName,
						   const ::com::sun::star::uno::Reference< 
						   ::com::sun::star::xml::sax::XAttributeList > & xAttrList );
	~SvXMLIgnoreSectionListContext ( void );
};
#endif
