/*************************************************************************
 *
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER.
 * 
 * Copyright 2008 by Sun Microsystems, Inc.
 *
 * OpenOffice.org - a multi-platform office productivity suite
 *
 * $RCSfile: sdtransform.cxx,v $
 *
 * $Revision: 1.4.36.2 $
 *
 * This file is part of OpenOffice.org.
 *
 * OpenOffice.org is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License version 3
 * only, as published by the Free Software Foundation.
 *
 * OpenOffice.org is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License version 3 for more details
 * (a copy is included in the LICENSE file that accompanied this code).
 *
 * You should have received a copy of the GNU Lesser General Public License
 * version 3 along with OpenOffice.org.  If not, see
 * <http://www.openoffice.org/license.html>
 * for a copy of the LGPLv3 License.
 *
 ************************************************************************/

// MARKER(update_precomp.py): autogen include statement, do not remove
#include "precompiled_sd.hxx"

#include <svtools/style.hxx>
#include <svtools/itemset.hxx>
#include <svtools/itempool.hxx>
#include <svtools/whiter.hxx>

#include <svx/svdoutl.hxx>
#include <svx/xmlcnitm.hxx>
#include <svx/svdotext.hxx>
#include <svx/svdogrp.hxx>
#include <svx/eeitem.hxx>
#include <svx/lrspitem.hxx>
#include <svx/numitem.hxx>

#include "drawdoc.hxx"
#include "glob.hxx"

using ::rtl::OUString;
using namespace ::com::sun::star::style;

class SdTransformOOo3xDocument
{
public:
	SdTransformOOo3xDocument( SdDrawDocument& rDocument );

	void transform();

	void transformMasterPages();
	void transformDrawPages();

	void transformShapes( SdrObjList& rShapes );
	void transformShape( SdrObject& rObj );

	void transformTextShape( SdrTextObj& rTextShape );

	SdDrawDocument&	mrDocument;
	SdrOutliner& mrOutliner;
};

/** transforms the given model from OOo 3.x to OOo 2.x. This merges
	the EE_PARA_NUMBULLET and EE_PARA_LRSPACE items */
void TransformOOo3xDocument( SdDrawDocument* pDocument )
{
	if( pDocument )
	{
		SdTransformOOo3xDocument aTransformer( *pDocument );
		aTransformer.transform();
	}
}

SdTransformOOo3xDocument::SdTransformOOo3xDocument( SdDrawDocument& rDocument )
: mrDocument( rDocument )
, mrOutliner( rDocument.GetDrawOutliner() )
{
}

void SdTransformOOo3xDocument::transform()
{
	transformMasterPages();
	transformDrawPages();
}

void SdTransformOOo3xDocument::transformMasterPages()
{
	sal_uInt16 nMasterPageCount = mrDocument.GetMasterPageCount();
	for( sal_uInt16 nMasterPage = 0; nMasterPage < nMasterPageCount; nMasterPage++ )
	{
		SdrObjList* pPage = mrDocument.GetMasterPage( nMasterPage );
		if( pPage )
			transformShapes( *pPage );
	}
}

void SdTransformOOo3xDocument::transformDrawPages()
{
	sal_uInt16 nPageCount = mrDocument.GetPageCount();
	for( sal_uInt16 nPage = 0; nPage < nPageCount; nPage++ )
	{
		SdrObjList* pPage = mrDocument.GetPage( nPage );
		if( pPage )
			transformShapes( *pPage );
	}
}

void SdTransformOOo3xDocument::transformShapes( SdrObjList& rShapes )
{
	sal_uInt32 nShapeCount = rShapes.GetObjCount();
	for( sal_uInt32 nShape = 0; nShape < nShapeCount; nShape++ )
	{
		SdrObject* pObj = rShapes.GetObj( nShape );
		if( pObj )
			transformShape( *pObj );
	}
}

void SdTransformOOo3xDocument::transformShape( SdrObject& rObj )
{
	SdrTextObj* pTextShape = dynamic_cast< SdrTextObj* >( &rObj );
	if( pTextShape )
	{
		transformTextShape( *pTextShape );
		return;
	}

	SdrObjGroup* pGroupShape = dynamic_cast< SdrObjGroup* >( &rObj );
	if( pGroupShape )
	{
		SdrObjList* pObjList = pGroupShape->GetSubList();
		if( pObjList )
			transformShapes( *pObjList );
		return;
	}
}

void SdTransformOOo3xDocument::transformTextShape( SdrTextObj& rTextShape )
{
	if(!rTextShape.IsEmptyPresObj())
	{
		OutlinerParaObject* pOPO = rTextShape.GetOutlinerParaObject();
		if (pOPO)
		{
			mrOutliner.SetText( *pOPO );
            if( mrOutliner.MergeNumberingRulesAndLRSpaces())
                rTextShape.SetOutlinerParaObject(mrOutliner.CreateParaObject());

			mrOutliner.Clear();
		}
	}
}
