#*************************************************************************
#
#   OpenOffice.org - a multi-platform office productivity suite
#
#   $RCSfile: images.pl,v $
#
#   $Revision: 1.4 $
#
#   last change: $Author: rt $ $Date: 2005/09/09 01:16:04 $
#
#   The Contents of this file are made available subject to
#   the terms of GNU Lesser General Public License Version 2.1.
#
#
#     GNU Lesser General Public License Version 2.1
#     =============================================
#     Copyright 2005 by Sun Microsystems, Inc.
#     901 San Antonio Road, Palo Alto, CA 94303, USA
#
#     This library is free software; you can redistribute it and/or
#     modify it under the terms of the GNU Lesser General Public
#     License version 2.1, as published by the Free Software Foundation.
#
#     This library is distributed in the hope that it will be useful,
#     but WITHOUT ANY WARRANTY; without even the implied warranty of
#     MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
#     Lesser General Public License for more details.
#
#     You should have received a copy of the GNU Lesser General Public
#     License along with this library; if not, write to the Free Software
#     Foundation, Inc., 59 Temple Place, Suite 330, Boston,
#     MA  02111-1307  USA
#
#*************************************************************************
my $replacefile = "";

while (my $a = shift @ARGV) {
    if ($a eq '-o') {
	$replacefile = shift @ARGV || die "-o requires filename";
    } 
}
my $outfile = "$replacefile.test";

open OUTFILE, ">$outfile" || die "$0 ERROR: cannot open $outfile for writing!\n";

print OUTFILE << "HEADER"
// This file is autogenerated by macros/images.pl

HEADER
;

my @themes = split / /, $ENV{CUSTOM_IMAGE_SETS};
while (my $theme = shift @themes)
{
    $theme =~ /^\s*$/ && next;
    $themezip = $theme . "_Zip";
    print "Build theme '$theme'\n";

    print OUTFILE << "EOFRAG"
File gid_File_Images_$themezip 
    Carrier=gid_Datacarrier; 
    Time="0200"; 
    Date="29022004"; 
    UnixRights=444; 
    Dir=gid_Dir_Share_Config; 
    Name="images_$theme.zip"; 
    Styles = (PACKED); 
End
EOFRAG
;
}

close OUTFILE;

my $do_replace = 1;

# Now compare our output with what came before
if (-f $replacefile)
{
    my ($A, $B);
    open $A, "$outfile" || die "Can't open $outfile: $!";
    open $B, "$replacefile" || die "Can't open $replacefile: $!";
    my @alines = <$A>;
    my @blines = <$B>;
    if (join (' ', @alines) eq join (' ', @blines)) {
	print "Image list unchanged\n";
	unlink $outfile;
	exit (0);
    }
    close $A;
    close $B;
}

unlink $replacefile;
rename $outfile, $replacefile;

exit (0);
