/*************************************************************************
 *
 *  OpenOffice.org - a multi-platform office productivity suite
 *
 *  $RCSfile: xmlFixedText.cxx,v $
 *
 *  $Revision: 1.3 $
 *
 *  last change: $Author: hr $ $Date: 2007/09/26 14:21:55 $
 *
 *  The Contents of this file are made available subject to
 *  the terms of GNU Lesser General Public License Version 2.1.
 *
 *
 *    GNU Lesser General Public License Version 2.1
 *    =============================================
 *    Copyright 2005 by Sun Microsystems, Inc.
 *    901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License version 2.1, as published by the Free Software Foundation.
 *
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with this library; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *    MA  02111-1307  USA
 *
 ************************************************************************/
#include "precompiled_reportdesign.hxx"

#ifndef RPT_XMLFIXEDTEXT_HXX
#include "xmlFixedText.hxx"
#endif
#ifndef RPT_XMLFILTER_HXX
#include "xmlfilter.hxx"
#endif
#ifndef _XMLOFF_XMLTOKEN_HXX
#include <xmloff/xmltoken.hxx>
#endif
#ifndef _XMLOFF_XMLNMSPE_HXX
#include <xmloff/xmlnmspe.hxx>
#endif
#ifndef _XMLOFF_NMSPMAP_HXX
#include <xmloff/nmspmap.hxx>
#endif
#ifndef RPT_XMLENUMS_HXX
#include "xmlEnums.hxx"
#endif
#ifndef RPT_XMLREPORTELEMENT_HXX
#include "xmlReportElement.hxx"
#endif
#ifndef _TOOLS_DEBUG_HXX
#include <tools/debug.hxx>
#endif


namespace rptxml
{
	using namespace ::com::sun::star;
	using namespace ::com::sun::star::report;
	using namespace ::com::sun::star::uno;
	using namespace ::com::sun::star::xml::sax;
DBG_NAME( rpt_OXMLFixedText )

OXMLFixedText::OXMLFixedText( ORptFilter& rImport,
				sal_uInt16 nPrfx
                , const ::rtl::OUString& rLName
				,const Reference< XFixedText > & _xComponent 
                ) :
	SvXMLImportContext( rImport, nPrfx, rLName)
,m_xComponent(_xComponent)
{
    DBG_CTOR( rpt_OXMLFixedText,NULL);
	OSL_ENSURE(m_xComponent.is(),"Component is NULL!");
}
// -----------------------------------------------------------------------------

OXMLFixedText::~OXMLFixedText()
{
    DBG_DTOR( rpt_OXMLFixedText,NULL);
}
// -----------------------------------------------------------------------------
void OXMLFixedText::Characters( const ::rtl::OUString& rChars )
{
	m_sLabel += rChars;
}
// -----------------------------------------------------------------------------
void OXMLFixedText::EndElement()
{
    m_xComponent->setLabel(m_sLabel);
}
//----------------------------------------------------------------------------
} // namespace rptxml
// -----------------------------------------------------------------------------
