/*************************************************************************
 *
 *  OpenOffice.org - a multi-platform office productivity suite
 *
 *  $RCSfile: IAppElementNotification.hxx,v $
 *
 *  $Revision: 1.5 $
 *
 *  last change: $Author: rt $ $Date: 2006/12/01 17:30:06 $
 *
 *  The Contents of this file are made available subject to
 *  the terms of GNU Lesser General Public License Version 2.1.
 *
 *
 *    GNU Lesser General Public License Version 2.1
 *    =============================================
 *    Copyright 2005 by Sun Microsystems, Inc.
 *    901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License version 2.1, as published by the Free Software Foundation.
 *
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with this library; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *    MA  02111-1307  USA
 *
 ************************************************************************/
#ifndef DBAUI_IAPPELEMENTNOTIFICATION_HXX
#define DBAUI_IAPPELEMENTNOTIFICATION_HXX

#ifndef _SAL_TYPES_H_
#include <sal/types.h>
#endif
#ifndef _LINK_HXX
#include <tools/link.hxx>
#endif
#ifndef DBAUI_APPELEMENTTYPE_HXX
#include "AppElementType.hxx"
#endif

class SvTreeListBox;
class SvLBoxEntry;
class ListBox;
class SvtIconChoiceCtrl;
namespace rtl
{
	class OUString;
}
//........................................................................
namespace dbaui
{
//........................................................................
	class SAL_NO_VTABLE IApplicationElementNotification
	{
	public:

		/** called when the handle <method>OApplicationDetailView::OnEntryDoubleClick</method> was called.
			@param	_pTree
				The tree list box.
            @return
                <TRUE/> if the double click event has been handled by the called, and should not
                be processed further.
		*/
		virtual bool onEntryDoubleClick(SvTreeListBox* _pTree) = 0;

		/** called when the handle <method>OApplicationSwapWindow::OnContainerSelectHdl</method> was called.
			@param	_pTree
				The tree list box.
			@return
				<TRUE/> if the cotainer could be changed otherwise <FALSE/>
		*/
		virtual sal_Bool onContainerSelect(ElementType _eType) = 0;

		/** called when the handle <method>OApplicationDetailView::OnEntrySelectHdl</method> was called.
			@param	_pEntry
				the selected entry
		*/
		virtual void onEntrySelect(SvLBoxEntry* _pEntry) = 0;

		/** called when the handle <method>OApplicationDetailView::OnDeSelectHdl</method> was called.
			@param	_pTree
				The tree list box.
		*/
		virtual void onEntryDeSelect(SvTreeListBox* _pTree) = 0;

		/** called when the handle <method>IApplicationElementNotification::OnCutEntry</method> was called.
			@param	_pEntry
				The entry which was cutted.
		*/
		virtual void onCutEntry(SvLBoxEntry* _pEntry) = 0;

		/** called when the handle <method>OApplicationDetailView::OnCopyEntry</method> was called.
			@param	_pEntry
				The entry which was cutted.
		*/
		virtual void onCopyEntry(SvLBoxEntry* _pEntry) = 0;

		/** called when the handle <method>OApplicationDetailView::OnPasteEntry</method> was called.
			@param	_pEntry
				The entry which was cutted.
		*/
		virtual void onPasteEntry(SvLBoxEntry* _pEntry) = 0;

		/** called when the handle <method>OApplicationDetailView::OnDeleteEntry</method> was called.
			@param	_pEntry
				The entry which was cutted.
		*/
		virtual void onDeleteEntry(SvLBoxEntry* _pEntry) = 0;

		/** called when the handle <method>OApplicationDetailView::OnCreationClickHdlHdl</method> was called.
			@param	_sCommand
				The command which should be executed.
		*/
		virtual void onCreationClick(const ::rtl::OUString& _sCommand) = 0;
	};
	
//........................................................................
} // namespace dbaui
//........................................................................
#endif // DBAUI_IAPPELEMENTNOTIFICATION_HXX

