/*
 *
 * Copyright (c) 1998-2002
 * Dr John Maddock
 *
 * Permission to use, copy, modify, distribute and sell this software
 * and its documentation for any purpose is hereby granted without fee,
 * provided that the above copyright notice appear in all copies and
 * that both that copyright notice and this permission notice appear
 * in supporting documentation.  Dr John Maddock makes no representations
 * about the suitability of this software for any purpose.  
 * It is provided "as is" without express or implied warranty.
 *
 */
 
 /*
  *   LOCATION:    see http://www.boost.org for most recent version.
  *   FILE         regex_libary_include.hpp
  *   VERSION      see <boost/version.hpp>
  *   DESCRIPTION: Automatic library inclusion for Borland/Microsoft compilers.
  *                Note this is an internal header file included
  *                by regex.hpp, do not include on its own.
  */

/*************************************************************************

Libraries for Borland and Microsoft compilers are automatically
selected here, the name of the lib is selected according to the following
formula:

BOOST_LIB_NAME
   + "_"
   + BOOST_LIB_TOOLSET
   + "_"
   + BOOST_LIB_THREAD_OPT
   + BOOST_LIB_RT_OPT
   + BOOST_LIB_LINK_OPT
   + BOOST_LIB_DEBUG_OPT

These are defined as:

BOOST_LIB_NAME:       The base name of the lib (boost_regex).

BOOST_LIB_TOOLSET:    The compiler toolset name (vc6, vc7, bcb5 etc).

BOOST_LIB_THREAD_OPT: "s" for single thread builds,
                      "m" for multithread builds.

BOOST_LIB_RT_OPT:     "s" for static runtime,
                      "d" for dynamic runtime.

BOOST_LIB_LINK_OPT:   "s" for static link,
                      "i" for dynamic link.

BOOST_LIB_DEBUG_OPT:  nothing for release builds,
                      "d" for debug builds,
                      "dd" for debug-diagnostic builds (_STLP_DEBUG).

***************************************************************************/

#if !defined(BOOST_REGEX_LIBRARY_INCLUDE_HPP) && !defined(BOOST_REGEX_NO_LIB)
#define BOOST_REGEX_LIBRARY_INCLUDE_HPP

#define BOOST_LIB_NAME "boost_regex"

//
// select toolset:
//
#if defined(BOOST_MSVC) && (BOOST_MSVC == 1200) && (defined(__SGI_STL_PORT) || defined(_STLPORT_VERSION))

   // vc6-stlport:
#  define BOOST_LIB_TOOLSET "vc6-stlport"

#elif defined(BOOST_MSVC) && (BOOST_MSVC == 1200)

   // vc6:
#  define BOOST_LIB_TOOLSET "vc6"

#elif defined(BOOST_MSVC) && (BOOST_MSVC >= 1300)

   // vc7:
#  define BOOST_LIB_TOOLSET "vc7"

#elif defined(__BORLANDC__) && (__BORLANDC__ >= 0x560)

   // CBuilder 6:
#  define BOOST_LIB_TOOLSET "bcb6"

#elif defined(__BORLANDC__) && (__BORLANDC__ >= 0x550)

   // CBuilder 6:
#  define BOOST_LIB_TOOLSET "bcb5"

#elif defined(__BORLANDC__) && (__BORLANDC__ >= 0x540)

   // CBuilder 6:
#  define BOOST_LIB_TOOLSET "bcb4"

#endif

//
// select thread opt:
//
#if defined(_MT) || defined(__MT__)
#  define BOOST_LIB_THREAD_OPT "m"
#else
#  define BOOST_LIB_THREAD_OPT "s"
#endif

//
// select runtime opt:
//
#if defined(_DLL) || defined(_RTLDLL)
#  define BOOST_LIB_RT_OPT "d"
#else
#  define BOOST_LIB_RT_OPT "s"
#endif

//
// select linkage opt:
//
#if (defined(_DLL) || defined(_RTLDLL)) && !defined(BOOST_REGEX_STATIC_LINK)
#  define BOOST_LIB_LINK_OPT "i"
#else
#  define BOOST_LIB_LINK_OPT "s"
#endif

//
// select debug opt:
//
#if defined(BOOST_MSVC) && defined(_DEBUG) && (defined(_STLP_DEBUG) || defined(__STL_DEBUG))
#  define BOOST_LIB_DEBUG_OPT "dd"
#elif defined(BOOST_MSVC) && defined(_DEBUG)
#  define BOOST_LIB_DEBUG_OPT "d"
#elif defined(__BORLANDC__) && (__BORLANDC__ == 0x560) && (defined(_STLP_DEBUG) || defined(__STL_DEBUG))
#  define BOOST_LIB_DEBUG_OPT "dd"
#else
#  define BOOST_LIB_DEBUG_OPT 
#endif

//
// now include the lib:
//
#if defined(BOOST_LIB_NAME) \
      && defined(BOOST_LIB_TOOLSET) \
      && defined(BOOST_LIB_THREAD_OPT) \
      && defined(BOOST_LIB_RT_OPT) \
      && defined(BOOST_LIB_LINK_OPT) \
      && defined(BOOST_LIB_DEBUG_OPT)

#  pragma comment(lib, BOOST_LIB_NAME "_" BOOST_LIB_TOOLSET "_" BOOST_LIB_THREAD_OPT BOOST_LIB_RT_OPT BOOST_LIB_LINK_OPT BOOST_LIB_DEBUG_OPT ".lib")

#endif

//
// finally undef any macros we may have set:
//
#if defined(BOOST_LIB_NAME)
#  undef BOOST_LIB_NAME
#endif
#if defined(BOOST_LIB_TOOLSET)
#  undef BOOST_LIB_TOOLSET
#endif
#if defined(BOOST_LIB_THREAD_OPT)
#  undef BOOST_LIB_THREAD_OPT
#endif
#if defined(BOOST_LIB_RT_OPT)
#  undef BOOST_LIB_RT_OPT
#endif
#if defined(BOOST_LIB_LINK_OPT)
#  undef BOOST_LIB_LINK_OPT
#endif
#if defined(BOOST_LIB_DEBUG_OPT)
#  undef BOOST_LIB_DEBUG_OPT
#endif


#endif // BOOST_REGEX_LIBRARY_INCLUDE_HPP






