/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.parser;

import com.sun.xml.parser.Parser;
import com.sun.xml.parser.Resolver;
import com.sun.xml.parser.ValidatingParser;
import com.sun.xml.tree.XmlDocument;
import com.sun.xml.tree.XmlDocumentBuilder;
import java.io.IOException;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.w3c.dom.Document;
import org.xml.sax.EntityResolver;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class DocumentBuilderImpl
extends DocumentBuilder {
    private DocumentBuilderFactory dbf;
    private EntityResolver er = null;
    private ErrorHandler eh = null;
    private Parser parser = null;
    private XmlDocumentBuilder builder = null;
    private boolean namespaceAware = false;
    private boolean validating = false;

    DocumentBuilderImpl(DocumentBuilderFactory documentBuilderFactory) {
        this.dbf = documentBuilderFactory;
        this.builder = new XmlDocumentBuilder();
        if (documentBuilderFactory.isValidating()) {
            this.parser = new ValidatingParser();
            this.validating = true;
        } else {
            this.parser = new Parser();
        }
        if (documentBuilderFactory.isNamespaceAware()) {
            this.builder.setDisableNamespaces(false);
            this.namespaceAware = true;
        }
        this.builder.setParser(this.parser);
        this.parser.setDocumentHandler(this.builder);
    }

    public boolean isNamespaceAware() {
        return this.namespaceAware;
    }

    public boolean isValidating() {
        return this.validating;
    }

    public Document newDocument() {
        return new XmlDocument();
    }

    public Document parse(InputSource inputSource) throws SAXException, IOException {
        if (inputSource == null) {
            throw new IllegalArgumentException("InputSource cannot be null");
        }
        if (this.er != null) {
            this.parser.setEntityResolver(this.er);
        } else {
            this.parser.setEntityResolver(new Resolver());
        }
        if (this.eh != null) {
            this.parser.setErrorHandler(this.eh);
        }
        this.parser.parse(inputSource);
        return this.builder.getDocument();
    }

    public void setEntityResolver(EntityResolver entityResolver) {
        this.er = entityResolver;
    }

    public void setErrorHandler(ErrorHandler errorHandler) {
        this.eh = errorHandler;
    }
}

