/*
 * Decompiled with CFR 0.152.
 */
package java.util.logging;

import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.LogManager;
import java.util.logging.Logger;
import java.util.logging.LoggingMXBean;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class Logging
implements LoggingMXBean {
    private static LogManager logManager = LogManager.getLogManager();
    private static String EMPTY_STRING = "";

    Logging() {
    }

    @Override
    public List<String> getLoggerNames() {
        Enumeration<String> enumeration = logManager.getLoggerNames();
        ArrayList<String> arrayList = new ArrayList<String>();
        while (enumeration.hasMoreElements()) {
            arrayList.add(enumeration.nextElement());
        }
        return arrayList;
    }

    @Override
    public String getLoggerLevel(String string) {
        Logger logger = logManager.getLogger(string);
        if (logger == null) {
            return null;
        }
        Level level = logger.getLevel();
        if (level == null) {
            return EMPTY_STRING;
        }
        return level.getName();
    }

    @Override
    public void setLoggerLevel(String string, String string2) {
        if (string == null) {
            throw new NullPointerException("loggerName is null");
        }
        Logger logger = logManager.getLogger(string);
        if (logger == null) {
            throw new IllegalArgumentException("Logger " + string + "does not exist");
        }
        Level level = null;
        if (string2 != null) {
            level = Level.parse(string2);
        }
        logger.setLevel(level);
    }

    @Override
    public String getParentLoggerName(String string) {
        Logger logger = logManager.getLogger(string);
        if (logger == null) {
            return null;
        }
        Logger logger2 = logger.getParent();
        if (logger2 == null) {
            return EMPTY_STRING;
        }
        return logger2.getName();
    }
}

