/*************************************************************************
 *
 *  OpenOffice.org - a multi-platform office productivity suite
 *
 *  $RCSfile: svpdummies.hxx,v $
 *
 *  $Revision: 1.2 $
 *
 *  last change: $Author: rt $ $Date: 2007/07/24 10:26:33 $
 *
 *  The Contents of this file are made available subject to
 *  the terms of GNU Lesser General Public License Version 2.1.
 *
 *
 *    GNU Lesser General Public License Version 2.1
 *    =============================================
 *    Copyright 2005 by Sun Microsystems, Inc.
 *    901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License version 2.1, as published by the Free Software Foundation.
 *
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with this library; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *    MA  02111-1307  USA
 *
 ************************************************************************/

#ifndef _SVP_SVPDUMMIES_HXX

#include <vcl/salogl.hxx>
#include <vcl/salsound.hxx>
#include <vcl/salobj.hxx>
#include <vcl/sysdata.hxx>
#include <vcl/salimestatus.hxx>
#include <vcl/salsys.hxx>

class SalGraphics;

class SvpSalOpenGL : public SalOpenGL
{
public:					
    SvpSalOpenGL() {}
    virtual ~SvpSalOpenGL();
						
    // overload all pure virtual methods
	virtual bool		IsValid();
	virtual oglFunction	GetOGLFnc( const char * );
	virtual void		OGLEntry( SalGraphics* pGraphics );
	virtual void		OGLExit( SalGraphics* pGraphics );
    virtual void		StartScene( SalGraphics* pGraphics );
	virtual void		StopScene();
};

class SvpSalSound : public SalSound
{
    bool m_bPlaying;
    bool m_bLooping;
    bool m_bPaused;
public:
    SvpSalSound() : m_bPlaying( false ), m_bLooping( false ), m_bPaused( false ) {}
	virtual ~SvpSalSound();
	
    // overload all pure virtual methods
    virtual bool		IsValid();
    virtual bool		Init( const String&	rSoundName,
                              ULONG&		rSoundLen );
   	virtual void		Play( ULONG nStartTime, ULONG nPlayTime, bool bLoop );
	virtual void		Stop();
	virtual void		Pause();
	virtual void		Continue();
    virtual bool		IsLoopMode() const;
	virtual bool		IsPlaying() const;
    virtual bool		IsPaused() const;
};

class SvpSalObject : public SalObject
{
public:
	SystemChildData m_aSystemChildData;

    SvpSalObject();
    virtual ~SvpSalObject();

    // overload all pure virtual methods
 	virtual void					ResetClipRegion();
	virtual USHORT					GetClipRegionType();
	virtual void					BeginSetClipRegion( ULONG nRects );
	virtual void					UnionClipRegion( long nX, long nY, long nWidth, long nHeight );
	virtual void					EndSetClipRegion();

	virtual void					SetPosSize( long nX, long nY, long nWidth, long nHeight );
	virtual void					Show( BOOL bVisible );
	virtual void					Enable( BOOL nEnable );
	virtual void					GrabFocus();

	virtual void					SetBackground();
	virtual void					SetBackground( SalColor nSalColor );

	virtual const SystemEnvData*	GetSystemData() const;
};

class SvpImeStatus : public SalI18NImeStatus
{
  public:
        SvpImeStatus() {}
        virtual ~SvpImeStatus();

        virtual bool canToggle();
        virtual void toggle();
};

class SvpSalSystem : public SalSystem
{
    public:
    SvpSalSystem() {}
    virtual ~SvpSalSystem();
    // get info about the display
    virtual unsigned int GetDisplayScreenCount();
    virtual bool IsMultiDisplay();
    virtual unsigned int GetDefaultDisplayNumber();
    virtual Rectangle GetDisplayScreenPosSizePixel( unsigned int nScreen );
    virtual Rectangle GetDisplayWorkAreaPosSizePixel( unsigned int nScreen );
    virtual rtl::OUString GetScreenName( unsigned int nScreen );

	
	virtual int ShowNativeMessageBox( const String& rTitle,
                                      const String& rMessage,
                                      int nButtonCombination,
                                      int nDefaultButton);
};


#endif // _SVP_SVPDUMMIES_H
