/*************************************************************************
 *
 *  OpenOffice.org - a multi-platform office productivity suite
 *
 *  $RCSfile: scuiautofmt.hxx,v $
 *
 *  $Revision: 1.4 $
 *
 *  last change: $Author: rt $ $Date: 2005/09/08 21:48:19 $
 *
 *  The Contents of this file are made available subject to
 *  the terms of GNU Lesser General Public License Version 2.1.
 *
 *
 *    GNU Lesser General Public License Version 2.1
 *    =============================================
 *    Copyright 2005 by Sun Microsystems, Inc.
 *    901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License version 2.1, as published by the Free Software Foundation.
 *
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with this library; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *    MA  02111-1307  USA
 *
 ************************************************************************/
#ifndef SCUI_AUTOFMT_HXX
#define SCUI_AUTOFMT_HXX
#include "autofmt.hxx"

class ScAutoFormatDlg : public ModalDialog
{
public:
			ScAutoFormatDlg( Window*					pParent,
							 ScAutoFormat*				pAutoFormat,
                             const ScAutoFormatData*    pSelFormatData,
                             ScDocument*                pDoc );
			~ScAutoFormatDlg();

	USHORT GetIndex() const { return nIndex; }
	String GetCurrFormatName();

private:
    FixedLine       aFlFormat;
	ListBox			aLbFormat;
	AutoFmtPreview*	pWndPreview;
	OKButton		aBtnOk;
	CancelButton	aBtnCancel;
	HelpButton		aBtnHelp;
	PushButton		aBtnAdd;
	PushButton		aBtnRemove;
	MoreButton		aBtnMore;
    FixedLine       aFlFormatting;
	CheckBox		aBtnNumFormat;
	CheckBox		aBtnBorder;
	CheckBox		aBtnFont;
	CheckBox		aBtnPattern;
	CheckBox		aBtnAlignment;
	CheckBox		aBtnAdjust;
	PushButton		aBtnRename;
	String			aStrTitle;
	String			aStrLabel;
	String			aStrClose;
	String			aStrDelTitle;
	String			aStrDelMsg;
	String			aStrRename;

	//------------------------
	ScAutoFormat*			pFormat;
	const ScAutoFormatData*	pSelFmtData;
	USHORT					nIndex;
	BOOL					bCoreDataChanged;
	BOOL					bFmtInserted;

	void Init			();
	void UpdateChecks	();
	//------------------------
	DECL_LINK( CheckHdl, Button * );
	DECL_LINK( AddHdl, void * );
	DECL_LINK( RemoveHdl, void * );
	DECL_LINK( SelFmtHdl, void * );
	DECL_LINK( CloseHdl, PushButton * );
	DECL_LINK( DblClkHdl, void * );
	DECL_LINK( RenameHdl, void *);

};
#endif

