/*
 * Decompiled with CFR 0.152.
 */
package com.jrefinery.data;

import com.jrefinery.data.AbstractSeriesDataset;
import com.jrefinery.data.CombinationDataset;
import com.jrefinery.data.HighLowDataset;
import com.jrefinery.data.IntervalXYDataset;
import com.jrefinery.data.SeriesDataset;
import com.jrefinery.data.SignalsDataset;
import com.jrefinery.data.XYDataset;

public class SubSeriesDataset
extends AbstractSeriesDataset
implements HighLowDataset,
SignalsDataset,
IntervalXYDataset,
CombinationDataset {
    private SeriesDataset parent = null;
    private int[] map;

    public SubSeriesDataset(SeriesDataset seriesDataset, int[] nArray) {
        this.parent = seriesDataset;
        this.map = nArray;
    }

    public SubSeriesDataset(SeriesDataset seriesDataset, int n) {
        this(seriesDataset, new int[]{n});
    }

    public Number getHighValue(int n, int n2) {
        return ((HighLowDataset)this.parent).getHighValue(this.map[n], n2);
    }

    public Number getLowValue(int n, int n2) {
        return ((HighLowDataset)this.parent).getLowValue(this.map[n], n2);
    }

    public Number getOpenValue(int n, int n2) {
        return ((HighLowDataset)this.parent).getOpenValue(this.map[n], n2);
    }

    public Number getCloseValue(int n, int n2) {
        return ((HighLowDataset)this.parent).getCloseValue(this.map[n], n2);
    }

    public Number getVolumeValue(int n, int n2) {
        return ((HighLowDataset)this.parent).getVolumeValue(this.map[n], n2);
    }

    public Number getXValue(int n, int n2) {
        return ((XYDataset)this.parent).getXValue(this.map[n], n2);
    }

    public Number getYValue(int n, int n2) {
        return ((XYDataset)this.parent).getYValue(this.map[n], n2);
    }

    public int getItemCount(int n) {
        return ((XYDataset)this.parent).getItemCount(this.map[n]);
    }

    public int getSeriesCount() {
        return this.map.length;
    }

    public String getSeriesName(int n) {
        return this.parent.getSeriesName(this.map[n]);
    }

    public Number getStartXValue(int n, int n2) {
        if (this.parent instanceof IntervalXYDataset) {
            return ((IntervalXYDataset)this.parent).getStartXValue(this.map[n], n2);
        }
        return this.getXValue(n, n2);
    }

    public Number getEndXValue(int n, int n2) {
        if (this.parent instanceof IntervalXYDataset) {
            return ((IntervalXYDataset)this.parent).getEndXValue(this.map[n], n2);
        }
        return this.getXValue(n, n2);
    }

    public Number getStartYValue(int n, int n2) {
        if (this.parent instanceof IntervalXYDataset) {
            return ((IntervalXYDataset)this.parent).getStartYValue(this.map[n], n2);
        }
        return this.getYValue(n, n2);
    }

    public Number getEndYValue(int n, int n2) {
        if (this.parent instanceof IntervalXYDataset) {
            return ((IntervalXYDataset)this.parent).getEndYValue(this.map[n], n2);
        }
        return this.getYValue(n, n2);
    }

    public int getType(int n, int n2) {
        if (this.parent instanceof SignalsDataset) {
            return ((SignalsDataset)this.parent).getType(this.map[n], n2);
        }
        return this.getYValue(n, n2).intValue();
    }

    public double getLevel(int n, int n2) {
        if (this.parent instanceof SignalsDataset) {
            return ((SignalsDataset)this.parent).getLevel(this.map[n], n2);
        }
        return this.getYValue(n, n2).doubleValue();
    }

    public SeriesDataset getParent() {
        return this.parent;
    }

    public int[] getMap() {
        return (int[])this.map.clone();
    }
}

