/*
 * Decompiled with CFR 0.152.
 */
package com.jrefinery.chart;

import com.jrefinery.chart.BarRenderer;
import com.jrefinery.chart.CategoryItemRenderer;
import com.jrefinery.chart.CategoryPlot;
import com.jrefinery.chart.ChartRenderingInfo;
import com.jrefinery.chart.Marker;
import com.jrefinery.chart.ValueAxis;
import com.jrefinery.chart.entity.CategoryItemEntity;
import com.jrefinery.chart.entity.EntityCollection;
import com.jrefinery.chart.tooltips.CategoryToolTipGenerator;
import com.jrefinery.chart.urls.CategoryURLGenerator;
import com.jrefinery.data.CategoryDataset;
import com.jrefinery.data.IntervalCategoryDataset;
import com.jrefinery.data.Range;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.Shape;
import java.awt.geom.Line2D;
import java.awt.geom.Rectangle2D;

public class HorizontalIntervalBarRenderer
extends BarRenderer
implements CategoryItemRenderer {
    public HorizontalIntervalBarRenderer() {
        this(null, null);
    }

    public HorizontalIntervalBarRenderer(CategoryToolTipGenerator categoryToolTipGenerator) {
        this(categoryToolTipGenerator, null);
    }

    public HorizontalIntervalBarRenderer(CategoryURLGenerator categoryURLGenerator) {
        this(null, categoryURLGenerator);
    }

    public HorizontalIntervalBarRenderer(CategoryToolTipGenerator categoryToolTipGenerator, CategoryURLGenerator categoryURLGenerator) {
        super(categoryToolTipGenerator, categoryURLGenerator);
    }

    public void initialise(Graphics2D graphics2D, Rectangle2D rectangle2D, CategoryPlot categoryPlot, ValueAxis valueAxis, CategoryDataset categoryDataset, ChartRenderingInfo chartRenderingInfo) {
        super.initialise(graphics2D, rectangle2D, categoryPlot, valueAxis, categoryDataset, chartRenderingInfo);
        this.calculateCategoryAndItemSpans(graphics2D, rectangle2D, categoryPlot, categoryDataset, rectangle2D.getHeight());
    }

    public boolean hasItemGaps() {
        return false;
    }

    public int barWidthsPerCategory(CategoryDataset categoryDataset) {
        return categoryDataset.getSeriesCount();
    }

    public void drawRangeMarker(Graphics2D graphics2D, CategoryPlot categoryPlot, ValueAxis valueAxis, Marker marker, Rectangle2D rectangle2D, Shape shape) {
        double d = marker.getValue();
        Range range = valueAxis.getRange();
        if (!range.contains(d)) {
            return;
        }
        double d2 = valueAxis.translateValueToJava2D(marker.getValue(), rectangle2D);
        Line2D.Double double_ = new Line2D.Double(d2, rectangle2D.getMinY(), d2, rectangle2D.getMaxY());
        graphics2D.setPaint(marker.getOutlinePaint());
        graphics2D.draw(double_);
    }

    public void drawCategoryItem(Graphics2D graphics2D, Rectangle2D rectangle2D, CategoryPlot categoryPlot, ValueAxis valueAxis, CategoryDataset categoryDataset, int n, Object object, int n2, Object object2) {
        EntityCollection entityCollection;
        double d;
        IntervalCategoryDataset intervalCategoryDataset = (IntervalCategoryDataset)categoryDataset;
        Number number = intervalCategoryDataset.getStartValue(n, object);
        double d2 = valueAxis.translateValueToJava2D(number.doubleValue(), rectangle2D);
        Number number2 = intervalCategoryDataset.getEndValue(n, object);
        double d3 = valueAxis.translateValueToJava2D(number2.doubleValue(), rectangle2D);
        if (d3 < d2) {
            d = d3;
            d3 = d2;
            d2 = d;
        }
        d = rectangle2D.getY() + rectangle2D.getHeight() * categoryPlot.getIntroGapPercent();
        int n3 = categoryDataset.getCategoryCount();
        int n4 = categoryDataset.getSeriesCount();
        if (n3 > 1) {
            d = d + (double)n2 * this.categorySpan / (double)n3 + (double)n2 * this.categoryGapSpan / (double)(n3 - 1) + (double)n * this.itemSpan / (double)(n3 * n4);
            if (n4 > 1) {
                d += (double)n * this.itemGapSpan / (double)(n3 * (n4 - 1));
            }
        } else {
            d += (double)n * this.itemSpan / (double)(n3 * n4);
            if (n4 > 1) {
                d += (double)n * this.itemGapSpan / (double)(n3 * (n4 - 1));
            }
        }
        double d4 = Math.abs(d3 - d2);
        double d5 = this.itemWidth;
        Rectangle2D.Double double_ = new Rectangle2D.Double(d2, d, d4, d5);
        Paint paint = categoryPlot.getSeriesPaint(n);
        graphics2D.setPaint(paint);
        graphics2D.fill(double_);
        if (this.itemWidth > 3.0) {
            graphics2D.setStroke(categoryPlot.getSeriesStroke(n));
            graphics2D.setPaint(categoryPlot.getSeriesOutlinePaint(n));
            graphics2D.draw(double_);
        }
        if (this.getInfo() != null && (entityCollection = this.getInfo().getEntityCollection()) != null) {
            String string = null;
            if (this.getToolTipGenerator() != null) {
                string = this.getToolTipGenerator().generateToolTip(categoryDataset, n, object);
            }
            String string2 = null;
            if (this.getURLGenerator() != null) {
                string2 = this.getURLGenerator().generateURL(categoryDataset, n, object);
            }
            CategoryItemEntity categoryItemEntity = new CategoryItemEntity(double_, string, string2, n, object, n2);
            entityCollection.addEntity(categoryItemEntity);
        }
    }
}

