/*
 * Decompiled with CFR 0.152.
 */
package org.openoffice.setup.Util;

import java.util.Enumeration;
import org.openoffice.setup.InstallData;
import org.openoffice.setup.Installer.Installer;
import org.openoffice.setup.Installer.InstallerFactory;
import org.openoffice.setup.SetupData.PackageDescription;
import org.openoffice.setup.SetupData.SetupDataProvider;

public class InstallChangeCtrl {
    private InstallChangeCtrl() {
    }

    private static void setUpdatePackage(PackageDescription packageData, InstallData installData) {
        if (packageData.isUpdatePackage()) {
            installData.setUpdatePackage(packageData);
        } else {
            Enumeration e = packageData.children();
            while (e.hasMoreElements()) {
                PackageDescription child = (PackageDescription)e.nextElement();
                InstallChangeCtrl.setUpdatePackage(child, installData);
            }
        }
    }

    private static void setChangeInstallDir(InstallData installData, Installer installer) {
        String changeInstallDir = installer.getChangeInstallDir(installData.getUpdatePackage());
        installData.setInstallDir(changeInstallDir);
    }

    public static void checkInstallChange(InstallData data) {
        Installer installer = InstallerFactory.getInstance();
        PackageDescription packageData = SetupDataProvider.getPackageDescription();
        if (data.getUpdatePackage() == null) {
            InstallChangeCtrl.setUpdatePackage(packageData, data);
        }
        if (data.getUpdatePackage() != null) {
            data.setOlderVersionExists(false);
            data.setNewerVersionExists(false);
            data.setSameVersionExists(false);
            boolean packageIsInstalled = installer.isPackageInstalled(data.getUpdatePackage(), data);
            if (packageIsInstalled) {
                if (installer.isInstalledPackageOlder(data.getUpdatePackage(), data)) {
                    data.setOlderVersionExists(true);
                    System.err.println("An older product is installed");
                } else if (installer.isInstallSetPackageOlder(data.getUpdatePackage(), data)) {
                    data.setNewerVersionExists(true);
                    System.err.println("A newer product is installed");
                } else {
                    data.setSameVersionExists(true);
                    System.err.println("Same product is installed");
                }
                if (data.isRootInstallation()) {
                    InstallChangeCtrl.setChangeInstallDir(data, installer);
                    data.setIsChangeInstallation(true);
                }
            }
        }
    }
}

