/*
 * Decompiled with CFR 0.152.
 */
package org.openoffice.setup;

import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.PropertyResourceBundle;
import java.util.ResourceBundle;
import javax.swing.ImageIcon;
import org.openoffice.setup.SetupData.SetupDataProvider;

public class ResourceManager {
    static PropertyResourceBundle stringResourceBundle;
    static PropertyResourceBundle fileNameResourceBundle;
    static HashMap setupFiles;

    private ResourceManager() {
    }

    public static void checkFileExistence(File htmlDirectory) {
        Enumeration<String> e = fileNameResourceBundle.getKeys();
        while (e.hasMoreElements()) {
            String key = e.nextElement();
            String fileName = (String)fileNameResourceBundle.getObject(key);
            if (!fileName.endsWith("html")) {
                setupFiles.put(key, fileName);
            }
            if (!fileName.endsWith("html")) continue;
            boolean fileExists = true;
            File file = new File(htmlDirectory, fileName);
            File newFile = null;
            if (file.exists()) {
                setupFiles.put(key, fileName);
            } else {
                fileExists = false;
                int pos1 = fileName.lastIndexOf("_");
                if (pos1 > 0) {
                    int pos2 = fileName.lastIndexOf(".");
                    String newFileName = fileName.substring(0, pos1) + fileName.substring(pos2, fileName.length());
                    newFile = new File(htmlDirectory, newFileName);
                    if (newFile.exists()) {
                        fileExists = true;
                        setupFiles.put(key, newFileName);
                    } else {
                        String simplePage = "Excuse.html";
                        File simpleFile = new File(htmlDirectory, simplePage);
                        if (simpleFile.exists()) {
                            fileExists = true;
                            setupFiles.put(key, simplePage);
                        }
                    }
                }
            }
            if (fileExists) continue;
            if (newFile != null) {
                System.err.println("ERROR: Neither file \"" + file.getPath() + "\" nor file \"" + newFile.getPath() + "\" do exist!");
            } else {
                System.err.println("ERROR: File \"" + file.getPath() + "\" does not exist!");
            }
            System.exit(1);
        }
    }

    public static String getString(String key) {
        String value = (String)stringResourceBundle.getObject(key);
        if (value != null && value.indexOf(36) >= 0) {
            value = SetupDataProvider.replaceMacros(value);
        }
        return value;
    }

    public static String getFileName(String key) {
        String value = (String)setupFiles.get(key);
        return value;
    }

    public static ImageIcon getIcon(String key) {
        String name = ResourceManager.getFileName(key);
        try {
            Class<?> c = Class.forName("org.openoffice.setup.ResourceManager");
            URL url = c.getResource(name);
            if (url != null) {
                return new ImageIcon(url);
            }
            System.err.println("Error: file not found: " + name);
        }
        catch (ClassNotFoundException e) {
            System.err.println(e);
        }
        return new ImageIcon();
    }

    public static ImageIcon getIconFromPath(File file) {
        try {
            URL url = file.toURL();
            if (url != null) {
                return new ImageIcon(url);
            }
            System.err.println("Error: file not found: " + file.getPath());
        }
        catch (MalformedURLException e) {
            System.err.println(e);
        }
        return new ImageIcon();
    }

    static {
        setupFiles = new HashMap();
        Locale locale = Locale.getDefault();
        System.err.println("System locale: " + locale);
        try {
            stringResourceBundle = (PropertyResourceBundle)ResourceBundle.getBundle("org.openoffice.setup.setupstrings", locale);
            fileNameResourceBundle = (PropertyResourceBundle)ResourceBundle.getBundle("org.openoffice.setup.setupfiles", locale);
        }
        catch (MissingResourceException ex) {
            ex.printStackTrace();
            System.exit(1);
        }
    }
}

