/*************************************************************************
 *
 *  OpenOffice.org - a multi-platform office productivity suite
 *
 *  $RCSfile: xoutx.hxx,v $
 *
 *  $Revision: 1.2 $
 *
 *  last change: $Author: vg $ $Date: 2007/04/11 16:59:41 $
 *
 *  The Contents of this file are made available subject to
 *  the terms of GNU Lesser General Public License Version 2.1.
 *
 *
 *    GNU Lesser General Public License Version 2.1
 *    =============================================
 *    Copyright 2005 by Sun Microsystems, Inc.
 *    901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License version 2.1, as published by the Free Software Foundation.
 *
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with this library; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *    MA  02111-1307  USA
 *
 ************************************************************************/

#ifndef _XOUTX_HXX
#define _XOUTX_HXX

#ifndef _SV_BITMAP_HXX
#include <vcl/bitmap.hxx>
#endif

#include <svx/xhatch.hxx>
#include <svx/xgrad.hxx>
#ifndef _SVX_RECTENUM_HXX //autogen
#include <svx/rectenum.hxx>
#endif
#ifndef _XENUM_HXX
#include <svx/xenum.hxx>
#endif
#ifndef _OUTDEV_HXX //autogen
#include <vcl/outdev.hxx>
#endif
#ifndef _BITMAP_HXX //autogen
#include <vcl/bitmap.hxx>
#endif

#ifndef INCLUDED_SVXDLLAPI_H
#include "svx/svxdllapi.h"
#endif

#ifndef _BGFX_POLYGON_B2DPOLYPOLYGON_HXX
#include <basegfx/polygon/b2dpolypolygon.hxx>
#endif

class FormattedText;
class XLineAttrSetItem;
class XFillAttrSetItem;
class XLineAttrSetItem;
class XFillAttrSetItem;
class XOutdevItemPool;
class XLineParam;
struct ImpData;
class SfxItemSet;
class GraphicObject;

// #101498# predeclaration for DrawPortionInfo
class DrawPortionInfo;

/*************************************************************************
|*
|* Extended OutputDevice
|*
\************************************************************************/

class SVX_DLLPUBLIC XOutputDevice
{
private:

	XGradient*			pTransGradient;
	sal_Bool			bSolidHatch;

	long*				pLinePattern;
	USHORT				nLinePatternCnt;

	XLineStyle			eLineStyle;
	Color				aLineColor;
	USHORT				nLineTransparence;
	long				nLineWidth;
	basegfx::B2DPolyPolygon			maLineStartPolyPolygon;
	basegfx::B2DPolyPolygon			maLineEndPolyPolygon;
	long				nLineStartSqLen, nLineEndSqLen;
	BOOL				bLineStart, bLineEnd;
	BOOL				bHair;

	XFillStyle			eFillStyle;
	Color				aFillColor;
	USHORT				nFillTransparence;

	Bitmap				maFillBitmap;
	GraphicObject*      mpFillGraphicObject;
    void*               mpDummy1;
    void*               mpDummy2;
    void*               mpDummy3;
    void*               mpDummy4;
    void*               mpDummy5;
    long                mnDummy;
    long                mnDummy2;
    long                mnDummy3;
    long                mnDummy4;
    long                mnDummy5;
	MapMode				maLastMapMode;
	Size				maFillBitmapSize;
	Size				maBmpSize;
	Size				maBmpOutputSize;
    long                mnDummy6;
    long                mnDummy7;
	Point				maStartPoint;
	USHORT				mnBmpPerCentX;
	USHORT				mnBmpPerCentY;
	USHORT				mnBmpOffX;
	USHORT				mnBmpOffY;
	USHORT				mnBmpOffPosX;
	USHORT				mnBmpOffPosY;
	OutDevType			meLastOutDevType;
	RECT_POINT			meBmpRectPoint;
	BOOL				mbBmpTile;
	BOOL				mbBmpStretch;
	BOOL				mbBmpLogSize;
	BOOL				mbDummy;
	BOOL				mbRecalc;

	XGradient			aGradient;
	XHatch				aHatch;
	BOOL				bDither;

	BOOL				bIgnoreLineAttr;
	BOOL				bIgnoreLineStyle;
	BOOL				bIgnoreFillAttr;

	XFormTextStyle      eFormTextStyle;
	XFormTextAdjust     eFormTextAdjust;
	long                nFormTextDistance;
	long                nFormTextStart;
	BOOL                bFormTextMirror;
	BOOL                bFormTextOutline;
	XFormTextShadow     eFormTextShadow;
	Color               aFormTextShdwColor;
	USHORT              nFormTextShdwTransp;
	long                nFormTextShdwXVal;
	long                nFormTextShdwYVal;
	XFormTextStdForm    eFormTextStdForm;
	BOOL                bFormTextHideForm;

	// Zwischenspeicher fuer FormText-Auto-Fonthoehe bei mehreren
	// zusammengehoerigen Aufrufen
	long				nFtAutoHeightSave;
	// umschliessendes Rechteck der Formtext-Effekte
	Rectangle			aFormTextBoundRect;

	SVX_DLLPRIVATE void				ImpDrawFillPolyPolygon( const PolyPolygon& rPoly, BOOL bRect, BOOL bPrinter );
	SVX_DLLPRIVATE void				ImpDrawLinePolygon(const Polygon& rPoly, BOOL bClosePoly);

protected:

	OutputDevice*		pOut;
	Point				aOfs;

	void				CalcFatLineJoin(const Point& rEnd, const Point& rNext, XLineParam& rParam);
	void				DrawFillPolyPolygon( const PolyPolygon& rPoly, BOOL bRect = FALSE );
	void				DrawLinePolygon( const Polygon& rPoly, BOOL bClosePoly );
	void				DrawStartEndPoly(const Point& rPoint, const basegfx::B2DPolyPolygon& rPolyPolygon, const XLineParam& rParam);
	void				DrawLineStartEnd(const Polygon& rPoly);
	void				DrawFatLine(const Point& rStart, const Point& rEnd, const Point* pNext, XLineParam& rParam);
	void				DrawPatternLine(const Point& rStart, const Point& rEnd, XLineParam& rParam);

	// #101498# changed interface due to bidi requirements
	sal_Int32 ImpDrawFormText(DrawPortionInfo* pInfo, const Polygon& rPoly, sal_Int32 nAbsStart, 
		sal_Bool bToLastPoint, sal_Bool bDraw, sal_Bool bIsShadow);
	void ImpDrawFormTextShadow(DrawPortionInfo* pInfo, const Polygon& rPoly, sal_Int32 nAbsStart, 
		sal_Bool bToLastPoint, sal_Bool bDraw);

	void				ImpDrawBitmapFill( const Rectangle& rRect, BOOL bPrinter );
	void				ImpCalcBmpFillStartValues( const Rectangle& rRect, BOOL bPrinter );
	void				ImpDrawTiledBitmap( OutputDevice* pOut, const Rectangle& rRect,
											const Point& rStartPoint, const Rectangle& rClipRect,
                                            BOOL bPrinter );

private:				// Declare but do not implement
						SVX_DLLPRIVATE XOutputDevice(const XOutputDevice& rOut);
public:
						XOutputDevice(OutputDevice* pOut);
						~XOutputDevice();

	OutputDevice*		GetOutDev() const { return pOut; }
	void				SetOutDev(OutputDevice* pNewOut) { pOut=pNewOut; }

	RasterOp			GetRasterOp() const { return pOut->GetRasterOp(); }
	void				SetRasterOp(RasterOp eRop) { pOut->SetRasterOp(eRop); }

	// Allgemeine Ausgabemethoden
	void				DrawLine( const Point& rStart, const Point& rEnd );
	void				DrawRect( const Rectangle& rRect, ULONG nXRound=0, ULONG nYRound=0 );
	void				DrawEllipse( const Rectangle& rRect );
	void				DrawArc( const Rectangle& rRect, const Point& rStart, const Point& rEnd );
	void				DrawPie( const Rectangle& rRect, const Point& rStart, const Point& rEnd );
	void				DrawPolyLine( const Polygon& rPoly );
	void				DrawPolygon( const Polygon& rPoly );
	void				DrawPolyPolygon( const PolyPolygon& rPolyPoly );
	void				DrawPolyLine( const basegfx::B2DPolygon& rPolygon );
	void				DrawPolygon( const basegfx::B2DPolygon& rPolygon );
	void				DrawPolyPolygon( const basegfx::B2DPolyPolygon& rPolyPolygon );

	// Bitmap Ausgabemethoden
	void				DrawBitmap( const Point& rPos, const Size& rSize, const Bitmap& rBmp );
	void				DrawBitmap( const Point& rDestPos, const Size& rDestSize,
									const Point& rSrcPos,  const Size& rSrcSize );

	// Text Ausgabemethoden
	// Der formatierte Text kommt aus der EditEngine von MT
	void				DrawFormattedText( const Point& rPos, const FormattedText& rText );

	// #101498# changed interface due to bidi requirements
	sal_Int32 DrawFormText(DrawPortionInfo* pInfo, const Polygon& rPoly,
		sal_Int32 nAbsStart = 0L, sal_Bool bToLastPoint = sal_True, 
		sal_Bool bDraw = sal_True);

	const Rectangle&	GetFormTextBoundRect() const { return aFormTextBoundRect; }

	// Nur Temporaer
	const Color&		GetLineColor() const { return pOut->GetLineColor(); }
	void				SetLineColor( const Color& rColor ) { pOut->SetLineColor( rColor ); }

	const Color&		GetFillColor() const { return pOut->GetFillColor(); }
	void				SetFillColor( const Color& rColor ) { pOut->SetFillColor( rColor ); }

	// Attributeinstellungen
	void				SetLineAttr(const SfxItemSet& rAttr);
	void				SetFillAttr(const SfxItemSet& rAttr);
	void				SetTextAttr(const SfxItemSet& rAttr);

	// Attributeinstellungen ignorieren
	void				SetIgnoreLineAttr(BOOL bIgnore) { bIgnoreLineAttr = bIgnore; }
	BOOL				GetIgnoreLineAttr() { return bIgnoreLineAttr; }
	void				SetIgnoreLineStyle(BOOL bIgnore) { bIgnoreLineStyle = bIgnore; }
	BOOL				GetIgnoreLineStyle() { return bIgnoreLineStyle; }
	void				SetIgnoreFillAttr(BOOL bIgnore) { bIgnoreFillAttr = bIgnore; }
	BOOL				GetIgnoreFillAttr() { return bIgnoreFillAttr; }

	// StarView- Linecolor/style und Fillcolor/style temporaer ueberschreiben, z.B. fuer
	// dragging in SvDraw
	void				OverrideLineColor(const Color& rColor );
	void				OverrideFillColor(const Color& rColor );

	// Zum Abschalten der Linienenden
	BOOL				IsLineStart() const { return bLineStart; }
	void				OverrideLineStart(BOOL bOn) { bLineStart=bOn; }
	BOOL				IsLineEnd() const { return bLineEnd; }
	void				OverrideLineEnd(BOOL bOn) { bLineEnd=bOn; }

	// Allgemeine Einstellungen
	const Point&		GetOffset() const { return aOfs; }
	void				SetOffset( const Point& rOfs );

	MapMode				GetMapMode() const;
	void				SetMapMode( const MapMode& rMap );

	// Initialisierung der Linienenden statisch, damit auch ohne XOutDev
	// von SvDraw verwendbar
	static long getLineStartEndDistance(const basegfx::B2DPolyPolygon& rPolyPolygon, long nNewWidth, bool bCenter);

private:
	long ImpInitLineStartEnd(basegfx::B2DPolyPolygon& rPolyPolygon, long nNewWidth, bool bCenter);
};

#endif      // _XOUTX_HXX

