/*************************************************************************
 *
 *  OpenOffice.org - a multi-platform office productivity suite
 *
 *  $RCSfile: tabvwsh9.cxx,v $
 *
 *  $Revision: 1.11 $
 *
 *  last change: $Author: vg $ $Date: 2007/02/27 13:58:55 $
 *
 *  The Contents of this file are made available subject to
 *  the terms of GNU Lesser General Public License Version 2.1.
 *
 *
 *    GNU Lesser General Public License Version 2.1
 *    =============================================
 *    Copyright 2005 by Sun Microsystems, Inc.
 *    901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License version 2.1, as published by the Free Software Foundation.
 *
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with this library; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *    MA  02111-1307  USA
 *
 ************************************************************************/

// MARKER(update_precomp.py): autogen include statement, do not remove
#include "precompiled_sc.hxx"



// INCLUDE ---------------------------------------------------------------

#include <svx/svdmark.hxx>
#include <svx/svdview.hxx>
#include <svx/galbrws.hxx>
#include <svx/gallery.hxx>
#include <svx/hlnkitem.hxx>
#include <sfx2/bindings.hxx>
#include <sfx2/request.hxx>
#include <sfx2/viewfrm.hxx>
#include <sfx2/dispatch.hxx>
#include <svtools/whiter.hxx>
#include <avmedia/mediaplayer.hxx>

#include "tabvwsh.hxx"
#include "viewdata.hxx"
#include "tabview.hxx"
#include "drwlayer.hxx"
#include "userdat.hxx"
#include "docsh.hxx"

// forwards -> galwrap.cxx (wg. CLOOKs)

USHORT	GallerySGA_FORMAT_GRAPHIC();
Graphic GalleryGetGraphic		();
BOOL	GalleryIsLinkage		();
String	GalleryGetFullPath		();
String	GalleryGetFilterName	();

// forwards -> imapwrap.cxx (wg. CLOOKs)

class SvxIMapDlg;

USHORT			ScIMapChildWindowId();
SvxIMapDlg*		ScGetIMapDlg();
const void*		ScIMapDlgGetObj( SvxIMapDlg* pDlg );
const ImageMap&	ScIMapDlgGetMap( SvxIMapDlg* pDlg );

//------------------------------------------------------------------

void ScTabViewShell::ExecChildWin(SfxRequest& rReq)
{
	USHORT nSlot = rReq.GetSlot();
	switch(nSlot)
	{
		case SID_GALLERY:
		{
			SfxViewFrame* pThisFrame = GetViewFrame();
			pThisFrame->ToggleChildWindow( GalleryChildWindow::GetChildWindowId() );
			pThisFrame->GetBindings().Invalidate( SID_GALLERY );
			rReq.Ignore();
		}
		break;
	
		case SID_AVMEDIA_PLAYER:
		{
			SfxViewFrame* pThisFrame = GetViewFrame();
			pThisFrame->ToggleChildWindow( ::avmedia::MediaPlayer::GetChildWindowId() );
			pThisFrame->GetBindings().Invalidate( SID_AVMEDIA_PLAYER );
			rReq.Ignore();
		}
		break;
	}
}

void ScTabViewShell::GetChildWinState( SfxItemSet& rSet )
{
	if( SFX_ITEM_AVAILABLE == rSet.GetItemState( SID_GALLERY ) )
	{
		USHORT nId = GalleryChildWindow::GetChildWindowId();
		rSet.Put( SfxBoolItem( SID_GALLERY, GetViewFrame()->HasChildWindow( nId ) ) );
	}
	else if( SFX_ITEM_AVAILABLE == rSet.GetItemState( SID_AVMEDIA_PLAYER ) )
	{
		USHORT nId = ::avmedia::MediaPlayer::GetChildWindowId();
		rSet.Put( SfxBoolItem( SID_AVMEDIA_PLAYER, GetViewFrame()->HasChildWindow( nId ) ) );
	}
}

//------------------------------------------------------------------

void ScTabViewShell::ExecGallery( SfxRequest& rReq )
{
	const SfxItemSet* pArgs = rReq.GetArgs();

	if ( pArgs )
	{
		const SfxPoolItem* pItem = NULL;
		SfxItemState eState = pArgs->GetItemState(SID_GALLERY_FORMATS, TRUE, &pItem);
		if ( eState == SFX_ITEM_SET )
		{
			UINT32 nFormats = ((const SfxUInt32Item*)pItem)->GetValue();

			/******************************************************************
			* Graphik einfuegen
			******************************************************************/
			if ( nFormats & GallerySGA_FORMAT_GRAPHIC() )
			{
				MakeDrawLayer();

				Graphic aGraphic = GalleryGetGraphic();
				Point 	aPos     = GetInsertPos();

				String aPath, aFilter;
				if ( GalleryIsLinkage() )			// als Link einfuegen?
				{
					aPath = GalleryGetFullPath();
					aFilter = GalleryGetFilterName();
				}

				PasteGraphic( aPos, aGraphic, aPath, aFilter );
			}
			else if ( nFormats & SGA_FORMAT_SOUND )
			{
				//	#98115# for sounds (linked or not), insert a hyperlink button,
				//	like in Impress and Writer

				GalleryExplorer* pGal = SVX_GALLERY();
				if ( pGal )
				{
        		    const SfxStringItem aMediaURLItem( SID_INSERT_AVMEDIA, pGal->GetURL().GetMainURL( INetURLObject::NO_DECODE ) );
       			    GetViewFrame()->GetDispatcher()->Execute( SID_INSERT_AVMEDIA, SFX_CALLMODE_SYNCHRON, &aMediaURLItem, 0L );
				}
			}
		}
	}
}

void ScTabViewShell::GetGalleryState( SfxItemSet& /* rSet */ )
{
}

//------------------------------------------------------------------

ScInputHandler* ScTabViewShell::GetInputHandler() const
{
	return pInputHandler;
}

//------------------------------------------------------------------

String __EXPORT ScTabViewShell::GetDescription() const
{
	return String::CreateFromAscii(RTL_CONSTASCII_STRINGPARAM(" ** Test ** "));
}

void ScTabViewShell::ExecImageMap( SfxRequest& rReq )
{
	USHORT nSlot = rReq.GetSlot();
	switch(nSlot)
	{
		case SID_IMAP:
		{
			SfxViewFrame* pThisFrame = GetViewFrame();
			USHORT nId = ScIMapChildWindowId();
			pThisFrame->ToggleChildWindow( nId );
			GetViewFrame()->GetBindings().Invalidate( SID_IMAP );

			if ( pThisFrame->HasChildWindow( nId ) )
			{
				SvxIMapDlg*	pDlg = ScGetIMapDlg();
				if ( pDlg )
				{
					SdrView* pDrView = GetSdrView();
					if ( pDrView )
					{
						const SdrMarkList& rMarkList = pDrView->GetMarkedObjectList();
						if ( rMarkList.GetMarkCount() == 1 )
							UpdateIMap( rMarkList.GetMark( 0 )->GetMarkedSdrObj() );
					}
				}
			}

			rReq.Ignore();
		}
		break;

		case SID_IMAP_EXEC:
		{
			SdrView* pDrView = GetSdrView();
			SdrMark* pMark = pDrView ? pDrView->GetMarkedObjectList().GetMark(0) : 0;

			if ( pMark )
			{
				SdrObject*	pSdrObj = pMark->GetMarkedSdrObj();
				SvxIMapDlg*	pDlg = ScGetIMapDlg();

				if ( ScIMapDlgGetObj(pDlg) == (void*) pSdrObj )
				{
					const ImageMap&	rImageMap = ScIMapDlgGetMap(pDlg);
					ScIMapInfo*		pIMapInfo = ScDrawLayer::GetIMapInfo( pSdrObj );

					if ( !pIMapInfo )
						pSdrObj->InsertUserData( new ScIMapInfo( rImageMap ) );
					else
						pIMapInfo->SetImageMap( rImageMap );

	                GetViewData()->GetDocShell()->SetDrawModified();
				}
			}
		}
		break;
	}
}

void ScTabViewShell::GetImageMapState( SfxItemSet& rSet )
{
	SfxWhichIter aIter(rSet);
	USHORT nWhich = aIter.FirstWhich();
	while ( nWhich )
	{
		switch ( nWhich )
		{
			case SID_IMAP:
				{
					//	Disabled wird nicht mehr...

					BOOL bThere = FALSE;
					SfxViewFrame* pThisFrame = GetViewFrame();
					USHORT nId = ScIMapChildWindowId();
					if ( pThisFrame->KnowsChildWindow(nId) )
						if ( pThisFrame->HasChildWindow(nId) )
							bThere = TRUE;

					ObjectSelectionType eType=GetCurObjectSelectionType();
					BOOL bEnable=(eType==OST_OleObject) ||(eType==OST_Graphic);
					if(!bThere && !bEnable)
					{
					   rSet.DisableItem( nWhich );
					}
					else
					{
						rSet.Put( SfxBoolItem( nWhich, bThere ) );
					}
				}
				break;

			case SID_IMAP_EXEC:
				{
					BOOL bDisable = TRUE;

					SdrView* pDrView = GetSdrView();
					if ( pDrView )
					{
						const SdrMarkList& rMarkList = pDrView->GetMarkedObjectList();
						if ( rMarkList.GetMarkCount() == 1 )
							if ( ScIMapDlgGetObj(ScGetIMapDlg()) ==
										(void*) rMarkList.GetMark(0)->GetMarkedSdrObj() )
								bDisable = FALSE;
					}

					rSet.Put( SfxBoolItem( SID_IMAP_EXEC, bDisable ) );
				}
				break;
		}

		nWhich = aIter.NextWhich();
	}
}




