/*
 * Decompiled with CFR 0.152.
 */
package com.jrefinery.chart;

import com.jrefinery.chart.Axis;
import com.jrefinery.chart.CategoryAxis;
import com.jrefinery.chart.CategoryItemRenderer;
import com.jrefinery.chart.CategoryPlot;
import com.jrefinery.chart.ChartRenderingInfo;
import com.jrefinery.chart.HorizontalAxis;
import com.jrefinery.chart.HorizontalValuePlot;
import com.jrefinery.chart.Marker;
import com.jrefinery.chart.Plot;
import com.jrefinery.chart.ValueAxis;
import com.jrefinery.chart.VerticalAxis;
import com.jrefinery.chart.VerticalCategoryAxis;
import com.jrefinery.data.CategoryDataset;
import com.jrefinery.data.DatasetUtilities;
import com.jrefinery.data.Range;
import java.awt.AlphaComposite;
import java.awt.Composite;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Paint;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.geom.Line2D;
import java.awt.geom.Rectangle2D;
import java.util.Iterator;

public class HorizontalCategoryPlot
extends CategoryPlot
implements HorizontalValuePlot {
    public HorizontalCategoryPlot(CategoryDataset categoryDataset, CategoryAxis categoryAxis, ValueAxis valueAxis, CategoryItemRenderer categoryItemRenderer) {
        this(categoryDataset, categoryAxis, valueAxis, categoryItemRenderer, Plot.DEFAULT_INSETS, Plot.DEFAULT_BACKGROUND_PAINT, null, 1.0f, Plot.DEFAULT_OUTLINE_STROKE, Plot.DEFAULT_OUTLINE_PAINT, 1.0f, 0.05, 0.05, 0.2, 0.15);
    }

    public HorizontalCategoryPlot(CategoryDataset categoryDataset, CategoryAxis categoryAxis, ValueAxis valueAxis, CategoryItemRenderer categoryItemRenderer, Insets insets, Paint paint, Image image, float f, Stroke stroke, Paint paint2, float f2, double d, double d2, double d3, double d4) {
        super(categoryDataset, categoryAxis, valueAxis, categoryItemRenderer, insets, paint, image, f, stroke, paint2, f2, d, d2, d3, d4);
    }

    public CategoryDataset getCategoryDataset() {
        return (CategoryDataset)this.dataset;
    }

    public double getCategoryCoordinate(int n, Rectangle2D rectangle2D) {
        double d = rectangle2D.getY() + rectangle2D.getHeight() * this.introGapPercent;
        int n2 = this.getCategoryDataset().getCategoryCount();
        if (n2 > 1) {
            double d2 = rectangle2D.getHeight() * (1.0 - this.introGapPercent - this.trailGapPercent - this.categoryGapsPercent);
            double d3 = rectangle2D.getHeight() * this.categoryGapsPercent;
            d = d + ((double)n + 0.5) * (d2 / (double)n2) + (double)n * (d3 / (double)(n2 - 1));
        } else {
            d += ((double)n + 0.5) * rectangle2D.getHeight() * (1.0 - this.introGapPercent - this.trailGapPercent);
        }
        return d;
    }

    public boolean isCompatibleHorizontalAxis(Axis axis) {
        return axis instanceof HorizontalAxis && axis instanceof ValueAxis;
    }

    public boolean isCompatibleVerticalAxis(Axis axis) {
        return axis instanceof VerticalCategoryAxis;
    }

    public boolean isCompatibleDomainAxis(CategoryAxis categoryAxis) {
        if (categoryAxis == null) {
            return true;
        }
        return this.isCompatibleVerticalAxis(categoryAxis);
    }

    public boolean isCompatibleRangeAxis(ValueAxis valueAxis) {
        if (valueAxis == null) {
            return true;
        }
        return this.isCompatibleHorizontalAxis(valueAxis);
    }

    public void draw(Graphics2D graphics2D, Rectangle2D rectangle2D, ChartRenderingInfo chartRenderingInfo) {
        if (chartRenderingInfo != null) {
            chartRenderingInfo.setPlotArea(rectangle2D);
        }
        if (this.insets != null) {
            rectangle2D.setRect(rectangle2D.getX() + (double)this.insets.left, rectangle2D.getY() + (double)this.insets.top, rectangle2D.getWidth() - (double)this.insets.left - (double)this.insets.right, rectangle2D.getHeight() - (double)this.insets.top - (double)this.insets.bottom);
        }
        if (rectangle2D.getWidth() >= 10.0 && rectangle2D.getHeight() >= 10.0) {
            Rectangle2D rectangle2D2 = this.renderer.getAxisArea(rectangle2D);
            VerticalAxis verticalAxis = (VerticalAxis)((Object)this.getDomainAxis());
            HorizontalAxis horizontalAxis = (HorizontalAxis)((Object)this.getRangeAxis());
            double d = verticalAxis.reserveWidth(graphics2D, this, rectangle2D2);
            Rectangle2D rectangle2D3 = horizontalAxis.reserveAxisArea(graphics2D, this, rectangle2D2, d);
            Rectangle2D.Double double_ = new Rectangle2D.Double(rectangle2D.getX() + d, rectangle2D.getY(), rectangle2D.getWidth() - d, rectangle2D.getHeight() - rectangle2D3.getHeight());
            Rectangle2D.Double double_2 = new Rectangle2D.Double(rectangle2D2.getX() + d, rectangle2D2.getY(), rectangle2D2.getWidth() - d, rectangle2D2.getHeight() - rectangle2D3.getHeight());
            if (chartRenderingInfo != null) {
                chartRenderingInfo.setDataArea(double_);
            }
            Shape shape = this.renderer.getDataClipRegion(double_);
            if (this.renderer != null) {
                this.renderer.drawPlotBackground(graphics2D, this, double_2, shape);
            }
            this.getDomainAxis().draw(graphics2D, rectangle2D2, double_2);
            this.getRangeAxis().draw(graphics2D, rectangle2D2, double_2);
            if (this.rangeMarkers != null && this.renderer != null) {
                Iterator iterator = this.rangeMarkers.iterator();
                while (iterator.hasNext()) {
                    Marker marker = (Marker)iterator.next();
                    this.renderer.drawRangeMarker(graphics2D, this, this.getRangeAxis(), marker, double_2, shape);
                }
                this.render(graphics2D, double_2, chartRenderingInfo, shape);
            }
        }
    }

    public void render(Graphics2D graphics2D, Rectangle2D rectangle2D, ChartRenderingInfo chartRenderingInfo, Shape shape) {
        CategoryDataset categoryDataset = this.getCategoryDataset();
        if (categoryDataset != null) {
            ValueAxis valueAxis;
            Shape shape2 = graphics2D.getClip();
            graphics2D.clip(rectangle2D);
            Composite composite = graphics2D.getComposite();
            AlphaComposite alphaComposite = AlphaComposite.getInstance(3, this.foregroundAlpha);
            graphics2D.setComposite(alphaComposite);
            int n = categoryDataset.getSeriesCount();
            this.renderer.initialise(graphics2D, rectangle2D, this, this.getRangeAxis(), categoryDataset, chartRenderingInfo);
            int n2 = 0;
            ValueAxis valueAxis2 = null;
            Iterator iterator = categoryDataset.getCategories().iterator();
            while (iterator.hasNext()) {
                valueAxis = iterator.next();
                int n3 = 0;
                while (n3 < n) {
                    this.renderer.drawCategoryItem(graphics2D, rectangle2D, this, this.getRangeAxis(), categoryDataset, n3, valueAxis, n2, valueAxis2);
                    ++n3;
                }
                ++n2;
                valueAxis2 = valueAxis;
            }
            valueAxis = this.getRangeAxis();
            if (valueAxis.isCrosshairVisible()) {
                this.drawVerticalLine(graphics2D, rectangle2D, valueAxis.getCrosshairValue(), valueAxis.getCrosshairStroke(), valueAxis.getCrosshairPaint());
            }
            graphics2D.setClip(shape2);
            graphics2D.setComposite(composite);
        }
    }

    public String getPlotType() {
        return "Horizontal Category Plot";
    }

    public Range getHorizontalDataRange() {
        Range range = null;
        CategoryDataset categoryDataset = this.getCategoryDataset();
        if (categoryDataset != null) {
            range = this.renderer != null && this.renderer.isStacked() ? DatasetUtilities.getStackedRangeExtent(categoryDataset) : DatasetUtilities.getRangeExtent(categoryDataset);
        }
        return range;
    }

    public ValueAxis getHorizontalValueAxis() {
        return this.rangeAxis;
    }

    public void handleClick(int n, int n2, ChartRenderingInfo chartRenderingInfo) {
        ValueAxis valueAxis = this.getRangeAxis();
        double d = valueAxis.translateJava2DtoValue(n, chartRenderingInfo.getDataArea());
        valueAxis.setAnchorValue(d);
        valueAxis.setCrosshairValue(d);
    }

    private void drawVerticalLine(Graphics2D graphics2D, Rectangle2D rectangle2D, double d, Stroke stroke, Paint paint) {
        double d2 = this.getRangeAxis().translateValueToJava2D(d, rectangle2D);
        Line2D.Double double_ = new Line2D.Double(d2, rectangle2D.getMinY(), d2, rectangle2D.getMaxY());
        graphics2D.setStroke(stroke);
        graphics2D.setPaint(paint);
        graphics2D.draw(double_);
    }
}

