/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.internal.ws.encoding.fastinfoset;

import com.sun.xml.internal.fastinfoset.stax.StAXDocumentParser;
import com.sun.xml.internal.fastinfoset.stax.StAXDocumentSerializer;
import com.sun.xml.internal.fastinfoset.vocab.ParserVocabulary;
import com.sun.xml.internal.fastinfoset.vocab.SerializerVocabulary;
import com.sun.xml.internal.org.jvnet.fastinfoset.FastInfosetSource;
import com.sun.xml.internal.ws.api.SOAPVersion;
import com.sun.xml.internal.ws.api.message.Message;
import com.sun.xml.internal.ws.api.message.Messages;
import com.sun.xml.internal.ws.api.message.Packet;
import com.sun.xml.internal.ws.api.pipe.Codec;
import com.sun.xml.internal.ws.api.pipe.ContentType;
import com.sun.xml.internal.ws.encoding.ContentTypeImpl;
import com.sun.xml.internal.ws.encoding.fastinfoset.FastInfosetStreamReaderRecyclable;
import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.channels.ReadableByteChannel;
import java.nio.channels.WritableByteChannel;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;
import javax.xml.ws.WebServiceException;

public class FastInfosetCodec
implements Codec {
    private static final int DEFAULT_INDEXED_STRING_SIZE_LIMIT = 32;
    private static final int DEFAULT_INDEXED_STRING_MEMORY_LIMIT = 0x400000;
    private StAXDocumentParser _parser;
    private StAXDocumentSerializer _serializer;
    private final boolean _retainState;
    private final ContentType _contentType;

    FastInfosetCodec(boolean bl) {
        this._retainState = bl;
        this._contentType = bl ? new ContentTypeImpl("application/vnd.sun.stateful.fastinfoset") : new ContentTypeImpl("application/fastinfoset");
    }

    public String getMimeType() {
        return this._contentType.getContentType();
    }

    public Codec copy() {
        return new FastInfosetCodec(this._retainState);
    }

    public ContentType getStaticContentType(Packet packet) {
        return this._contentType;
    }

    public ContentType encode(Packet packet, OutputStream outputStream) {
        Message message = packet.getMessage();
        if (message != null && message.hasPayload()) {
            XMLStreamWriter xMLStreamWriter = this.getXMLStreamWriter(outputStream);
            try {
                xMLStreamWriter.writeStartDocument();
                packet.getMessage().writePayloadTo(xMLStreamWriter);
                xMLStreamWriter.writeEndDocument();
                xMLStreamWriter.flush();
            }
            catch (XMLStreamException xMLStreamException) {
                throw new WebServiceException(xMLStreamException);
            }
        }
        return this._contentType;
    }

    public ContentType encode(Packet packet, WritableByteChannel writableByteChannel) {
        throw new UnsupportedOperationException();
    }

    public void decode(InputStream inputStream, String string, Packet packet) throws IOException {
        Message message = null;
        message = (inputStream = FastInfosetCodec.hasSomeData(inputStream)) != null ? Messages.createUsingPayload(new FastInfosetSource(inputStream), SOAPVersion.SOAP_11) : Messages.createEmpty(SOAPVersion.SOAP_11);
        packet.setMessage(message);
    }

    public void decode(ReadableByteChannel readableByteChannel, String string, Packet packet) {
        throw new UnsupportedOperationException();
    }

    private XMLStreamWriter getXMLStreamWriter(OutputStream outputStream) {
        if (this._serializer != null) {
            this._serializer.setOutputStream(outputStream);
            return this._serializer;
        }
        this._serializer = FastInfosetCodec.createNewStreamWriter(outputStream, this._retainState);
        return this._serializer;
    }

    private XMLStreamReader getXMLStreamReader(InputStream inputStream) {
        if (this._parser != null) {
            this._parser.setInputStream(inputStream);
            return this._parser;
        }
        this._parser = FastInfosetCodec.createNewStreamReader(inputStream, this._retainState);
        return this._parser;
    }

    public static FastInfosetCodec create() {
        return FastInfosetCodec.create(false);
    }

    public static FastInfosetCodec create(boolean bl) {
        return new FastInfosetCodec(bl);
    }

    static StAXDocumentSerializer createNewStreamWriter(OutputStream outputStream, boolean bl) {
        return FastInfosetCodec.createNewStreamWriter(outputStream, bl, 32, 0x400000);
    }

    static StAXDocumentSerializer createNewStreamWriter(OutputStream outputStream, boolean bl, int n, int n2) {
        StAXDocumentSerializer stAXDocumentSerializer = new StAXDocumentSerializer(outputStream);
        if (bl) {
            SerializerVocabulary serializerVocabulary = new SerializerVocabulary();
            stAXDocumentSerializer.setVocabulary(serializerVocabulary);
            stAXDocumentSerializer.setAttributeValueSizeLimit(n);
            stAXDocumentSerializer.setCharacterContentChunkSizeLimit(n);
            stAXDocumentSerializer.setAttributeValueMapMemoryLimit(n2);
            stAXDocumentSerializer.setCharacterContentChunkMapMemoryLimit(n2);
        }
        return stAXDocumentSerializer;
    }

    static StAXDocumentParser createNewStreamReader(InputStream inputStream, boolean bl) {
        StAXDocumentParser stAXDocumentParser = new StAXDocumentParser(inputStream);
        stAXDocumentParser.setStringInterning(true);
        if (bl) {
            ParserVocabulary parserVocabulary = new ParserVocabulary();
            stAXDocumentParser.setVocabulary(parserVocabulary);
        }
        return stAXDocumentParser;
    }

    static StAXDocumentParser createNewStreamReaderRecyclable(InputStream inputStream, boolean bl) {
        FastInfosetStreamReaderRecyclable fastInfosetStreamReaderRecyclable = new FastInfosetStreamReaderRecyclable(inputStream);
        fastInfosetStreamReaderRecyclable.setStringInterning(true);
        fastInfosetStreamReaderRecyclable.setForceStreamClose(true);
        if (bl) {
            ParserVocabulary parserVocabulary = new ParserVocabulary();
            fastInfosetStreamReaderRecyclable.setVocabulary(parserVocabulary);
        }
        return fastInfosetStreamReaderRecyclable;
    }

    private static InputStream hasSomeData(InputStream inputStream) throws IOException {
        if (inputStream != null && inputStream.available() < 1) {
            if (!inputStream.markSupported()) {
                inputStream = new BufferedInputStream(inputStream);
            }
            inputStream.mark(1);
            if (inputStream.read() != -1) {
                inputStream.reset();
            } else {
                inputStream = null;
            }
        }
        return inputStream;
    }
}

